/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public final class StringUtil {
    public static final char QUOTE_CHAR = '\"';
    public static final String QUOTE = "\"";
    public static final String LS = System.getProperty("line.separator", "\n");
    private static final String NANOS_FORMAT = "%d ns";
    private static final String MICROS_FORMAT = "%.1f micros";
    private static final String MILLIS_FORMAT = "%.1f ms";
    private static final String SECONDS_FORMAT = "%.3f sec";

    private StringUtil() {
    }

    public static String quote(Object o) {
        return StringUtil.quote(o, '\"');
    }

    public static String quote(Object o, char leftHandChar) {
        String s = o == null ? "null" : StringUtil.toString(o);
        char leftChar = leftHandChar;
        char rightChar = leftHandChar;
        switch (leftHandChar) {
            case '(': {
                rightChar = ')';
                break;
            }
            case '{': {
                rightChar = '}';
                break;
            }
            case '[': {
                rightChar = ']';
                break;
            }
            case '<': {
                rightChar = '>';
                break;
            }
        }
        return leftChar + s + rightChar;
    }

    public static String toHexString(byte theByte) {
        String result = Integer.toHexString(theByte & 0xFF);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static String toHexString(byte[] bytes) {
        return StringUtil.toHexString(bytes, null);
    }

    public static String toHexString(byte[] bytes, String delim) {
        StringBuilder buf = new StringBuilder();
        if (bytes.length != 0) {
            if (delim == null || delim.length() == 0) {
                for (int i = 0; i < bytes.length; ++i) {
                    buf.append(StringUtil.toHexString(bytes[i]));
                }
            } else {
                for (int i = 0; i < bytes.length; ++i) {
                    buf.append(StringUtil.toHexString(bytes[i])).append(delim);
                }
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    public static String stripSuffix(String s, String suffix) {
        String result = s;
        if (s.endsWith(suffix)) {
            result = s.substring(0, s.length() - suffix.length());
        }
        return result;
    }

    public static String replaceSuffix(String s, String fromSuffix, String toSuffix) {
        if (!s.endsWith(fromSuffix)) {
            throw new IllegalArgumentException(fromSuffix);
        }
        return StringUtil.stripSuffix(s, fromSuffix) + toSuffix;
    }

    public static String stripPrefix(String s, String prefix) {
        String result = s;
        if (s.startsWith(prefix)) {
            result = s.substring(prefix.length(), s.length());
        }
        return result;
    }

    public static String stripPrefixAndSuffix(String s, String prefix, String suffix) {
        return StringUtil.stripPrefix(StringUtil.stripSuffix(s, suffix), prefix);
    }

    public static String upperCaseFirstLetter(String s) {
        String result = s;
        if (s.length() >= 1) {
            result = s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1, s.length());
        }
        return result;
    }

    public static String toString(Object o) {
        String s;
        if (o instanceof String) {
            s = (String)o;
        } else if (o instanceof Throwable) {
            s = ExceptionUtil.toString((Throwable)o);
        } else if (o instanceof Attribute) {
            Attribute a = (Attribute)o;
            s = a.getName() + "=" + StringUtil.toString(a.getValue());
        } else if (o instanceof AttributeList) {
            Map<String, Object> items = JMXUtil.attributeListToValueMap((AttributeList)o);
            s = "{" + MapUtil.toString(items) + "}";
        } else if (o instanceof byte[]) {
            byte[] b = (byte[])byte[].class.cast(o);
            s = "byte[] of length " + b.length;
        } else {
            s = o == null ? "null" : (o instanceof Object[] ? StringUtil.toString(", ", (Object[])o) : "" + o);
        }
        return s;
    }

    public static String toString(String[] args) {
        return StringUtil.toString(", ", args);
    }

    public static String toString(String delim, String ... args) {
        return StringUtil.toString(delim, (Object[])args);
    }

    public static String toString(String delim, Object ... args) {
        String result;
        if (args == null) {
            result = "" + null;
        } else if (args.length == 0) {
            result = "";
        } else if (args.length == 1) {
            result = StringUtil.toString(args[0]);
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < args.length - 1; ++i) {
                builder.append(StringUtil.toString(args[i]));
                builder.append(delim);
            }
            builder.append(StringUtil.toString(args[args.length - 1]));
            result = builder.toString();
        }
        return result;
    }

    public static String getPrefix(Set<String> prefixes, String s) {
        String result = null;
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix)) continue;
            result = prefix;
            break;
        }
        return result;
    }

    public static String findAndStripPrefix(Set<String> prefixes, String s) {
        String prefix = StringUtil.getPrefix(prefixes, s);
        if (prefix == null) {
            throw new IllegalArgumentException(s);
        }
        return StringUtil.stripPrefix(s, prefix);
    }

    private static double micros(long nanos) {
        return (double)nanos / 1000.0;
    }

    private static double millis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    private static double seconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public static String getSecondsString(long nanos) {
        return StringUtil.getTimingString(nanos, TimeUnit.SECONDS);
    }

    public static String getMillisString(long nanos) {
        return StringUtil.getTimingString(nanos, TimeUnit.MILLISECONDS);
    }

    public static String getTimingString(long nanos, TimeUnit timeUnit) {
        String result = null;
        if (null != timeUnit) {
            switch (timeUnit) {
                case NANOSECONDS: {
                    result = String.format(NANOS_FORMAT, nanos);
                    break;
                }
                case MICROSECONDS: {
                    result = String.format(MICROS_FORMAT, StringUtil.micros(nanos));
                    break;
                }
                case MILLISECONDS: {
                    result = String.format(MILLIS_FORMAT, StringUtil.millis(nanos));
                    break;
                }
                case SECONDS: {
                    result = String.format(SECONDS_FORMAT, StringUtil.seconds(nanos));
                    break;
                }
            }
        }
        return result;
    }

    public static String getTimingString(long nanos) {
        long MICROSECOND = 1000L;
        long MILLISECOND = 1000000L;
        String runTimeString = nanos < 10000L ? nanos + " nanoseconds" : (nanos < 10000000L ? nanos / 1000L + " microseconds" : nanos / 1000000L + " milliseconds");
        return runTimeString;
    }

    public static <T> String[] toStringArray(Collection<T> c) {
        String[] strings = new String[c.size()];
        int i = 0;
        for (T o : c) {
            strings[i] = StringUtil.toString(o);
            ++i;
        }
        return strings;
    }

    public static String[] toStringArray(Object[] items) {
        String[] strings = new String[items.length];
        int i = 0;
        for (Object o : items) {
            strings[i] = StringUtil.toString(o);
            ++i;
        }
        return strings;
    }

    public static String toString(Collection c, String delim) {
        String[] strings = StringUtil.toStringArray(c);
        return StringUtil.toString(delim, (Object[])strings);
    }

    public static String toString(Collection c) {
        return StringUtil.toString(c, ", ");
    }

    public static List<String> objectNamesToStrings(Collection<ObjectName> objectNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (ObjectName objectName : objectNames) {
            result.add("" + objectName);
        }
        return result;
    }

    public static String[] objectNamesToStrings(ObjectName[] objectNames) {
        String[] strings = new String[objectNames.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = "" + objectNames[i];
        }
        return strings;
    }

    public static String toLines(List<String> items) {
        StringBuilder buf = new StringBuilder();
        for (String item : items) {
            buf.append(StringUtil.toString(item));
            buf.append(LS);
        }
        return buf.toString();
    }
}

