/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.stringifier;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public final class X509CertificateStringifier
implements Stringifier {
    public static final X509CertificateStringifier DEFAULT = new X509CertificateStringifier();

    private static byte[] getFingerprint(byte[] signature, String alg) {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            result = md.digest(signature);
        }
        catch (NoSuchAlgorithmException e) {
            result = signature;
            e.printStackTrace();
        }
        return result;
    }

    public static String stringify(X509Certificate cert) {
        StringBuilder buf = new StringBuilder();
        String NL = "\n";
        buf.append("Issuer: ").append(cert.getIssuerDN().getName()).append("\n");
        buf.append("Issued to: ").append(cert.getSubjectDN().getName()).append("\n");
        buf.append("Version: ").append(cert.getVersion()).append("\n");
        buf.append("Not valid before: ").append(cert.getNotBefore()).append("\n");
        buf.append("Not valid after: ").append(cert.getNotAfter()).append("\n");
        buf.append("Serial number: ").append(cert.getSerialNumber()).append("\n");
        buf.append("Signature algorithm: ").append(cert.getSigAlgName()).append("\n");
        buf.append("Signature algorithm OID: ").append(cert.getSigAlgOID()).append("\n");
        buf.append("Signature fingerprint (MD5): ");
        byte[] fingerprint = X509CertificateStringifier.getFingerprint(cert.getSignature(), "MD5");
        buf.append(StringUtil.toHexString(fingerprint, ":")).append("\n");
        buf.append("Signature fingerprint (SHA1): ");
        fingerprint = X509CertificateStringifier.getFingerprint(cert.getSignature(), "SHA1");
        buf.append(StringUtil.toHexString(fingerprint, ":")).append("\n");
        return buf.toString();
    }

    @Override
    public String stringify(Object object) {
        return X509CertificateStringifier.stringify((X509Certificate)object);
    }
}

