/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.SingleThreadModel;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.catalina.Auditor;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Server;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.MappingImpl;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.ContextsAdapterUtility;
import org.apache.catalina.core.DynamicFilterRegistrationImpl;
import org.apache.catalina.core.DynamicServletRegistrationImpl;
import org.apache.catalina.core.FilterRegistrationImpl;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.ServletRegistrationImpl;
import org.apache.catalina.core.SessionCookieConfigImpl;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.FilterMaps;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.ServletMap;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.ContextBindings;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.WARDirContext;
import org.apache.naming.resources.WebDirContext;
import org.glassfish.grizzly.http.server.naming.NamingContext;
import org.glassfish.grizzly.http.server.util.AlternateDocBase;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.web.loader.ServletContainerInitializerUtil;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.valve.GlassFishValve;

public class StandardContext
extends ContainerBase
implements Context,
ServletContext {
    private static final String DEFAULT_RESPONSE_CHARACTER_ENCODING = "ISO-8859-1";
    private static final ClassLoader standardContextClassLoader = StandardContext.class.getClassLoader();
    private static final Set<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = EnumSet.of(SessionTrackingMode.COOKIE);
    protected static final URLEncoder urlEncoder;
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    private static final RuntimePermission GET_CLASSLOADER_PERMISSION;
    private String altDDName = null;
    private boolean antiJARLocking = false;
    private String hostName;
    private final List<EventListener> eventListeners = new ArrayList<EventListener>();
    protected ArrayList<ServletContextListener> contextListeners = new ArrayList();
    private final List<HttpSessionListener> sessionListeners = new ArrayList<HttpSessionListener>();
    private final List<ApplicationParameter> applicationParameters = new ArrayList<ApplicationParameter>();
    private boolean available = false;
    private NotificationBroadcasterSupport broadcaster = null;
    private CharsetMapper charsetMapper = null;
    private String charsetMapperClass = CharsetMapper.class.getName();
    private String requestCharacterEncoding;
    private String responseCharacterEncoding;
    private String configFile = null;
    private boolean configured = false;
    private final List<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
    protected ApplicationContext context = null;
    private boolean isContextInitializedCalled = false;
    private String compilerClasspath = null;
    private boolean cookies = true;
    private boolean enableURLRewriting = true;
    private boolean crossContext = false;
    private boolean delegate = false;
    private String displayName = null;
    private String defaultWebXml;
    private boolean distributable = false;
    private final ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private String docBase = null;
    private final Map<String, ErrorPage> exceptionPages = new HashMap<String, ErrorPage>();
    private ErrorPage defaultErrorPage;
    private final Map<String, FilterConfig> filterConfigs = new HashMap<String, FilterConfig>();
    private final Map<String, FilterDef> filterDefs = new HashMap<String, FilterDef>();
    private final List<FilterMap> filterMaps = new ArrayList<FilterMap>();
    private final ArrayList<String> instanceListeners = new ArrayList();
    private final List<InstanceListener> instanceListenerInstances = new ArrayList<InstanceListener>();
    private LoginConfig loginConfig = null;
    private final Mapper mapper = new Mapper();
    private NamingContextListener namingContextListener = null;
    private NamingResources namingResources = new NamingResources();
    private final Map<String, MessageDestination> messageDestinations = new HashMap<String, MessageDestination>();
    private final Map<String, String> mimeMappings = new HashMap<String, String>();
    private final HashMap<String, String> parameters = new HashMap();
    private boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean unpackWAR = true;
    private boolean override = false;
    private String originalDocBase = null;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private boolean securePagesWithPragma = true;
    private final Map<String, String> roleMappings = new HashMap<String, String>();
    private final List<String> securityRoles = new ArrayList<String>();
    private final Map<String, String> servletMappings = new HashMap<String, String>();
    private int sessionTimeout = 30;
    private boolean sessionTimeoutOveridden = false;
    private long sequenceNumber = 0L;
    private final Map<Integer, ErrorPage> statusPages = new HashMap<Integer, ErrorPage>();
    private long unloadDelay = 2000L;
    private final List<String> watchedResources = Collections.synchronizedList(new ArrayList());
    private String[] welcomeFiles = new String[0];
    private final ArrayList<String> wrapperLifecycles = new ArrayList();
    private final List<String> wrapperListeners = new ArrayList<String>();
    private String workDir = null;
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    private int managerChecksFrequency = 6;
    private int count = 0;
    private boolean cachingAllowed = true;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    protected int cacheTTL = 5000;
    private DirContext webappResources = null;
    private long startupTime;
    private long startTimeMillis;
    private long tldScanTime;
    protected boolean caseSensitiveMapping = true;
    private boolean reuseSessionID = false;
    private boolean allowRelativeRedirect = false;
    private String engineName = null;
    private String j2EEApplication = "null";
    private String j2EEServer = "none";
    private Auditor[] auditors = null;
    private static AtomicInteger instanceIDCounter;
    private boolean webXmlValidation = false;
    private String jvmRoute;
    private boolean webXmlNamespaceAware = false;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    protected boolean isJsfApplication = false;
    private boolean isReload = false;
    private ArrayList<AlternateDocBase> alternateDocBases = null;
    private boolean useMyFaces;
    private Set<SessionTrackingMode> sessionTrackingModes;
    private String encodedPath = null;
    private SessionCookieConfig sessionCookieConfig;
    private String sessionCookieName = "JSESSIONID";
    private boolean sessionCookieNameInitialized = false;
    protected ConcurrentMap<String, ServletRegistrationImpl> servletRegisMap = new ConcurrentHashMap<String, ServletRegistrationImpl>();
    protected ConcurrentMap<String, FilterRegistrationImpl> filterRegisMap = new ConcurrentHashMap<String, FilterRegistrationImpl>();
    private List<String> orderedLibs;
    private JspConfigDescriptor jspConfigDesc;
    private boolean isProgrammaticServletContextListenerRegistrationAllowed = false;
    private MySecurityManager mySecurityManager;
    private Iterable<ServletContainerInitializer> servletContainerInitializers = null;
    private int effectiveMajorVersion = 0;
    private int effectiveMinorVersion = 0;
    private boolean isEmbedded = false;
    protected boolean directoryDeployed = false;
    protected boolean showArchivedRealPathEnabled = true;
    protected int servletReloadCheckSecs = 1;
    protected boolean directoryListing = false;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.namingResources.setContainer(this);
        if (Globals.IS_SECURITY_ENABLED) {
            this.mySecurityManager = AccessController.doPrivileged(new PrivilegedCreateSecurityManager());
        }
    }

    @Override
    public String getEncodedPath() {
        return this.encodedPath;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.encodedPath = urlEncoder.encode(name);
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitiveMapping(boolean caseSensitiveMap) {
        this.caseSensitiveMapping = caseSensitiveMap;
    }

    public boolean isCaseSensitiveMapping() {
        return this.caseSensitiveMapping;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    public synchronized boolean isUseNaming() {
        return this.useNaming;
    }

    public synchronized void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    @Override
    public List<EventListener> getApplicationEventListeners() {
        return this.eventListeners;
    }

    public List<HttpSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    @Override
    public boolean getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        boolean oldAvailable = this.available;
        this.available = available;
        this.support.firePropertyChange("available", (Object)oldAvailable, (Object)this.available);
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        boolean oldAntiJARLocking = this.antiJARLocking;
        this.antiJARLocking = antiJARLocking;
        this.support.firePropertyChange("antiJARLocking", oldAntiJARLocking, this.antiJARLocking);
    }

    @Override
    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    @Override
    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        if (mapper != null) {
            this.charsetMapperClass = mapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
        this.requestCharacterEncoding = encoding;
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.responseCharacterEncoding;
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
        this.responseCharacterEncoding = encoding;
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", (Object)oldConfigured, (Object)this.configured);
    }

    @Override
    public boolean getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
        this.support.firePropertyChange("cookies", (Object)oldCookies, (Object)this.cookies);
    }

    @Override
    public boolean isEnableURLRewriting() {
        return this.enableURLRewriting;
    }

    @Override
    public void setEnableURLRewriting(boolean enableURLRewriting) {
        boolean oldEnableURLRewriting = this.enableURLRewriting;
        this.enableURLRewriting = enableURLRewriting;
        this.support.firePropertyChange("enableURLRewriting", (Object)oldEnableURLRewriting, (Object)this.enableURLRewriting);
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", (Object)oldCrossContext, (Object)this.crossContext);
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String defaultWebXml) {
        this.defaultWebXml = defaultWebXml;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long tldScanTime) {
        this.tldScanTime = tldScanTime;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getAltDDName() {
        return this.altDDName;
    }

    @Override
    public void setAltDDName(String altDDName) {
        this.altDDName = altDDName;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", altDDName);
            this.context.setAttributeReadOnly("org.apache.catalina.deploy.alt_dd");
        }
    }

    public String getCompilerClasspath() {
        return this.compilerClasspath;
    }

    public void setCompilerClasspath(String compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
        if (this.getManager() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Propagating distributable={0} to manager", distributable);
            }
            this.getManager().setDistributable(distributable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDocBase() {
        StandardContext standardContext = this;
        synchronized (standardContext) {
            return this.docBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDocBase(String docBase) {
        StandardContext standardContext = this;
        synchronized (standardContext) {
            this.docBase = docBase;
        }
    }

    public void addAlternateDocBase(String urlPattern, String docBase) {
        if (urlPattern == null || docBase == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00130"));
        }
        AlternateDocBase alternateDocBase = new AlternateDocBase();
        alternateDocBase.setUrlPattern(urlPattern);
        alternateDocBase.setDocBase(docBase);
        alternateDocBase.setBasePath(this.getBasePath(docBase));
        if (this.alternateDocBases == null) {
            this.alternateDocBases = new ArrayList();
        }
        this.alternateDocBases.add(alternateDocBase);
    }

    public ArrayList<AlternateDocBase> getAlternateDocBases() {
        return this.alternateDocBases;
    }

    public int getManagerChecksFrequency() {
        return this.managerChecksFrequency;
    }

    public void setManagerChecksFrequency(int managerChecksFrequency) {
        if (managerChecksFrequency <= 0) {
            return;
        }
        int oldManagerChecksFrequency = this.managerChecksFrequency;
        this.managerChecksFrequency = managerChecksFrequency;
        this.support.firePropertyChange("managerChecksFrequency", (Object)oldManagerChecksFrequency, (Object)this.managerChecksFrequency);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public String getEngineName() {
        if (this.engineName != null) {
            return this.engineName;
        }
        return this.domain;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String j2EEApplication) {
        this.j2EEApplication = j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String j2EEServer) {
        this.j2EEServer = j2EEServer;
    }

    @Override
    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    @Override
    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00131"));
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "AS-WEB-CORE-00168", loginPage);
                }
                config.setLoginPage("/" + loginPage);
            } else {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00132"), loginPage);
                throw new IllegalArgumentException(msg);
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "AS-WEB-CORE-00169", errorPage);
                }
                config.setErrorPage("/" + errorPage);
            } else {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00133"), errorPage);
                throw new IllegalArgumentException(msg);
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictedSetPipeline(Pipeline pl) {
        StandardContext standardContext = this;
        synchronized (standardContext) {
            pl.setBasic(new StandardContextValve());
            this.pipeline = pl;
            this.hasCustomPipeline = true;
        }
    }

    @Override
    public NamingResources getNamingResources() {
        return this.namingResources;
    }

    @Override
    public void setNamingResources(NamingResources namingResources) {
        NamingResources oldNamingResources = this.namingResources;
        this.namingResources = namingResources;
        this.support.firePropertyChange("namingResources", oldNamingResources, this.namingResources);
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public void setPath(String path) {
        this.setName(RequestUtil.urlDecode(path, "UTF-8"));
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Setting deployment descriptor public ID to ''{0}''", publicId);
        }
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public boolean getOverride() {
        return this.override;
    }

    public String getOriginalDocBase() {
        return this.originalDocBase;
    }

    public void setOriginalDocBase(String docBase) {
        this.originalDocBase = docBase;
    }

    @Override
    public boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", (Object)oldPrivileged, (Object)this.privileged);
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    @Override
    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", (Object)oldOverride, (Object)this.override);
    }

    @Override
    public boolean isJsfApplication() {
        return this.isJsfApplication;
    }

    @Override
    public boolean hasAdHocPaths() {
        return false;
    }

    @Override
    public String getAdHocServletName(String path) {
        return null;
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", (Object)oldReplaceWelcomeFiles, (Object)this.replaceWelcomeFiles);
    }

    @Override
    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    @Override
    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        boolean oldSecurePagesWithPragma = this.securePagesWithPragma;
        this.securePagesWithPragma = securePagesWithPragma;
        this.support.firePropertyChange("securePagesWithPragma", (Object)oldSecurePagesWithPragma, (Object)this.securePagesWithPragma);
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
    }

    public boolean isUseMyFaces() {
        return this.useMyFaces;
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this);
            if (this.altDDName != null && this.context.getAttribute("org.apache.catalina.deploy.alt_dd") == null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
                this.context.setAttributeReadOnly("org.apache.catalina.deploy.alt_dd");
            }
        }
        return this.context.getFacade();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isSessionTimeoutOveridden() {
        return this.sessionTimeoutOveridden;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "setSessionTimeout", this.getName());
            throw new IllegalStateException(msg);
        }
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout == 0 ? -1 : timeout;
        this.support.firePropertyChange("sessionTimeout", (Object)oldSessionTimeout, (Object)this.sessionTimeout);
        this.sessionTimeoutOveridden = true;
    }

    public long getUnloadDelay() {
        return this.unloadDelay;
    }

    public void setUnloadDelay(long unloadDelay) {
        long oldUnloadDelay = this.unloadDelay;
        this.unloadDelay = unloadDelay;
        this.support.firePropertyChange("unloadDelay", oldUnloadDelay, this.unloadDelay);
    }

    public boolean getUnpackWAR() {
        return this.unpackWAR;
    }

    public void setUnpackWAR(boolean unpackWAR) {
        this.unpackWAR = unpackWAR;
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00166"));
        }
        DirContext oldResources = this.webappResources;
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            BaseDirContext baseDirContext = (BaseDirContext)resources;
            baseDirContext.setCached(this.isCachingAllowed());
            baseDirContext.setCacheTTL(this.getCacheTTL());
            baseDirContext.setCacheMaxSize(this.getCacheMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            FileDirContext fileDirContext = (FileDirContext)resources;
            fileDirContext.setCaseSensitive(this.isCaseSensitive());
            fileDirContext.setAllowLinking(this.isAllowLinking());
        }
        this.webappResources = resources;
        this.resources = null;
        this.support.firePropertyChange("resources", oldResources, this.webappResources);
    }

    private synchronized void setAlternateResources(AlternateDocBase alternateDocBase, DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00166"));
        }
        DirContext oldResources = ContextsAdapterUtility.unwrap(alternateDocBase.getWebappResources());
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setCaseSensitive(this.isCaseSensitive());
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        alternateDocBase.setWebappResources(ContextsAdapterUtility.wrap(resources));
        alternateDocBase.setResources(null);
    }

    @Override
    public boolean getReuseSessionID() {
        return this.reuseSessionID;
    }

    @Override
    public void setReuseSessionID(boolean reuse) {
        this.reuseSessionID = reuse;
    }

    @Override
    public boolean getAllowRelativeRedirect() {
        return this.allowRelativeRedirect;
    }

    @Override
    public void setAllowRelativeRedirect(boolean allowRelativeURLs) {
        this.allowRelativeRedirect = allowRelativeURLs;
    }

    @Override
    public Auditor[] getAuditors() {
        return this.auditors;
    }

    @Override
    public void setAuditors(Auditor[] auditor) {
        this.auditors = auditor;
    }

    public void setReload(boolean isReload) {
        this.isReload = isReload;
    }

    public boolean isReload() {
        return this.isReload;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public void setDirectoryListing(boolean directoryListing) {
        Servlet servlet;
        this.directoryListing = directoryListing;
        Wrapper wrapper = (Wrapper)this.findChild("default");
        if (wrapper != null && (servlet = ((StandardWrapper)wrapper).getServlet()) instanceof DefaultServlet) {
            ((DefaultServlet)servlet).setListings(directoryListing);
        }
    }

    public boolean isDirectoryListing() {
        return this.directoryListing;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getWorkPath() {
        if (this.getWorkDir() == null) {
            return null;
        }
        File workDir = new File(this.getWorkDir());
        if (!workDir.isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                workDir = new File(catalinaHomePath, this.getWorkDir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return workDir.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWorkDir() {
        StandardContext standardContext = this;
        synchronized (standardContext) {
            return this.workDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkDir(String workDir) {
        StandardContext standardContext = this;
        synchronized (standardContext) {
            this.workDir = workDir;
            if (this.started) {
                this.postWorkDirectory();
            }
        }
    }

    @Override
    public void addApplicationListener(String listener) {
        this.addListener(listener, false);
    }

    @Override
    public void addApplicationParameter(ApplicationParameter parameter) {
        String newName = parameter.getName();
        for (ApplicationParameter applicationParameter : this.applicationParameters) {
            if (!newName.equals(applicationParameter.getName())) continue;
            if (applicationParameter.getOverride()) {
                applicationParameter.setValue(parameter.getValue());
            }
            return;
        }
        this.applicationParameters.add(parameter);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addApplicationParameter", parameter);
        }
    }

    @Override
    public void addChild(Container child) {
        this.addChild(child, false, true);
    }

    protected void addChild(Container child, boolean isProgrammatic, boolean createRegistration) {
        String jspFile;
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00134"));
        }
        Wrapper wrapper = (Wrapper)child;
        String wrapperName = child.getName();
        if (createRegistration) {
            ServletRegistrationImpl regis = null;
            regis = isProgrammatic || null == wrapper.getServletClassName() && null == wrapper.getJspFile() ? this.createDynamicServletRegistrationImpl((StandardWrapper)wrapper) : this.createServletRegistrationImpl((StandardWrapper)wrapper);
            this.servletRegisMap.put(wrapperName, regis);
            if (null == wrapper.getServletClassName() && null == wrapper.getJspFile()) {
                return;
            }
        }
        if ("javax.faces.webapp.FacesServlet".equals(wrapper.getServletClassName())) {
            this.isJsfApplication = true;
        }
        Wrapper oldJspServlet = null;
        boolean isJspServlet = "jsp".equals(wrapperName);
        if (isJspServlet && (oldJspServlet = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(oldJspServlet);
        }
        if ((jspFile = wrapper.getJspFile()) != null && !jspFile.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "AS-WEB-CORE-00170", jspFile);
                }
                wrapper.setJspFile("/" + jspFile);
            } else {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00135"), jspFile);
                throw new IllegalArgumentException(msg);
            }
        }
        super.addChild(child);
        if (this.getAvailable() && wrapper instanceof StandardWrapper) {
            ((StandardWrapper)wrapper).registerJMX(this);
        }
        if (isJspServlet && oldJspServlet != null) {
            String[] jspMappings = oldJspServlet.findMappings();
            for (int i = 0; jspMappings != null && i < jspMappings.length; ++i) {
                this.addServletMapping(jspMappings[i], wrapperName);
            }
        }
    }

    protected ServletRegistrationImpl createServletRegistrationImpl(StandardWrapper wrapper) {
        return new ServletRegistrationImpl(wrapper, this);
    }

    protected ServletRegistrationImpl createDynamicServletRegistrationImpl(StandardWrapper wrapper) {
        return new DynamicServletRegistrationImpl(wrapper, this);
    }

    @Override
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections;
        for (SecurityCollection collection : collections = constraint.findCollections()) {
            String[] patterns = collection.findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (this.validateURLPattern(patterns[j])) continue;
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00136"), patterns[j]);
                throw new IllegalArgumentException(msg);
            }
        }
        this.constraints.add(constraint);
    }

    @Override
    public void addEjb(ContextEjb ejb) {
        this.namingResources.addEjb(ejb);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addEjb", ejb.getName());
        }
    }

    @Override
    public void addEnvironment(ContextEnvironment environment) {
        ContextEnvironment env = this.findEnvironment(environment.getName());
        if (env != null && !env.getOverride()) {
            return;
        }
        this.namingResources.addEnvironment(environment);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addEnvironment", environment.getName());
        }
    }

    public void addResourceParams(ResourceParams resourceParameters) {
        this.namingResources.addResourceParams(resourceParameters);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceParams", resourceParameters.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00137"));
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "AS-WEB-CORE-00138");
                }
                errorPage.setLocation("/" + location);
            } else {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00138"), location);
                throw new IllegalArgumentException(msg);
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            Map<String, ErrorPage> map = this.exceptionPages;
            synchronized (map) {
                this.exceptionPages.put(exceptionType, errorPage);
            }
        } else if (errorPage.getErrorCode() > 0) {
            Map<Integer, ErrorPage> map = this.statusPages;
            synchronized (map) {
                int errorCode = errorPage.getErrorCode();
                if (errorCode >= 400 && errorCode < 600) {
                    this.statusPages.put(errorCode, errorPage);
                } else {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00139", errorCode);
                }
            }
        } else {
            this.defaultErrorPage = errorPage;
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addErrorPage", errorPage);
        }
    }

    @Override
    public void addFilterDef(FilterDef filterDef) {
        this.addFilterDef(filterDef, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDef(FilterDef filterDef, boolean isProgrammatic, boolean createRegistration) {
        if (createRegistration) {
            FilterRegistrationImpl regis = null;
            regis = isProgrammatic || null == filterDef.getFilterClassName() ? new DynamicFilterRegistrationImpl(filterDef, this) : new FilterRegistrationImpl(filterDef, this);
            this.filterRegisMap.put(filterDef.getFilterName(), regis);
            if (null == filterDef.getFilterClassName()) {
                return;
            }
        }
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addFilterDef", filterDef);
        }
    }

    public void addFilterMaps(FilterMaps filterMaps) {
        FilterMap fmap;
        String[] servletNames = filterMaps.getServletNames();
        String[] urlPatterns = filterMaps.getURLPatterns();
        for (String servletName : servletNames) {
            fmap = new FilterMap();
            fmap.setFilterName(filterMaps.getFilterName());
            fmap.setServletName(servletName);
            fmap.setDispatcherTypes(filterMaps.getDispatcherTypes());
            this.addFilterMap(fmap);
        }
        for (String urlPattern : urlPatterns) {
            fmap = new FilterMap();
            fmap.setFilterName(filterMaps.getFilterName());
            fmap.setURLPattern(urlPattern);
            fmap.setDispatcherTypes(filterMaps.getDispatcherTypes());
            this.addFilterMap(fmap);
        }
    }

    @Override
    public void addFilterMap(FilterMap filterMap) {
        this.addFilterMap(filterMap, true);
    }

    public void addFilterMap(FilterMap filterMap, boolean isMatchAfter) {
        String filterName = filterMap.getFilterName();
        String servletName = filterMap.getServletName();
        String urlPattern = filterMap.getURLPattern();
        if (null == this.filterRegisMap.get(filterName)) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00140"), filterName);
            throw new IllegalArgumentException(msg);
        }
        if (servletName == null && urlPattern == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00141"));
        }
        if (servletName != null && urlPattern != null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00141"));
        }
        if (urlPattern != null && !this.validateURLPattern(urlPattern)) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00142"), urlPattern);
            throw new IllegalArgumentException(msg);
        }
        if (isMatchAfter) {
            this.filterMaps.add(filterMap);
        } else {
            this.filterMaps.add(0, filterMap);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addFilterMap", filterMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServletNameFilterMappings(String filterName) {
        HashSet<String> mappings = new HashSet<String>();
        List<FilterMap> list = this.filterMaps;
        synchronized (list) {
            for (FilterMap fm : this.filterMaps) {
                if (!filterName.equals(fm.getFilterName()) || fm.getServletName() == null) continue;
                mappings.add(fm.getServletName());
            }
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getUrlPatternFilterMappings(String filterName) {
        HashSet<String> mappings = new HashSet<String>();
        List<FilterMap> list = this.filterMaps;
        synchronized (list) {
            for (FilterMap fm : this.filterMaps) {
                if (!filterName.equals(fm.getFilterName()) || fm.getURLPattern() == null) continue;
                mappings.add(fm.getURLPattern());
            }
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addFilter", this.getName());
            throw new IllegalStateException(msg);
        }
        if (filterName == null || filterName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00144"));
        }
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            if (this.findFilterDef(filterName) != null) {
                return null;
            }
            DynamicFilterRegistrationImpl regis = (DynamicFilterRegistrationImpl)this.filterRegisMap.get(filterName);
            FilterDef filterDef = null;
            filterDef = null == regis ? new FilterDef() : regis.getFilterDefinition();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClassName(className);
            this.addFilterDef(filterDef, true, regis == null);
            if (null == regis) {
                regis = (DynamicFilterRegistrationImpl)this.filterRegisMap.get(filterName);
            }
            return regis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addFilter", this.getName());
            throw new IllegalStateException(msg);
        }
        if (filterName == null || filterName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00144"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00191"));
        }
        Container host = this.getParent();
        if (host != null) {
            for (Container child : host.findChildren()) {
                if (child == this || !((StandardContext)child).hasFilter(filter)) continue;
                return null;
            }
        }
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            for (Map.Entry<String, FilterDef> e : this.filterDefs.entrySet()) {
                if (!filterName.equals(e.getKey()) && filter != e.getValue().getFilter()) continue;
                return null;
            }
            DynamicFilterRegistrationImpl regis = (DynamicFilterRegistrationImpl)this.filterRegisMap.get(filterName);
            FilterDef filterDef = null;
            filterDef = null == regis ? new FilterDef() : regis.getFilterDefinition();
            filterDef.setFilterName(filterName);
            filterDef.setFilter(filter);
            this.addFilterDef(filterDef, true, regis == null);
            if (null == regis) {
                regis = (DynamicFilterRegistrationImpl)this.filterRegisMap.get(filterName);
            }
            return regis;
        }
    }

    public boolean hasFilter(Filter filter) {
        for (Map.Entry<String, FilterDef> e : this.filterDefs.entrySet()) {
            if (filter != e.getValue().getFilter()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addFilter", this.getName());
            throw new IllegalStateException(msg);
        }
        if (filterName == null || filterName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00144"));
        }
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            if (this.findFilterDef(filterName) != null) {
                return null;
            }
            DynamicFilterRegistrationImpl regis = (DynamicFilterRegistrationImpl)this.filterRegisMap.get(filterName);
            FilterDef filterDef = null;
            filterDef = null == regis ? new FilterDef() : regis.getFilterDefinition();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClass(filterClass);
            this.addFilterDef(filterDef, true, regis == null);
            if (null == regis) {
                regis = (DynamicFilterRegistrationImpl)this.filterRegisMap.get(filterName);
            }
            return regis;
        }
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return this.createFilterInstance(clazz);
        }
        catch (Throwable t) {
            throw new ServletException("Unable to create Filter from class " + clazz.getName(), t);
        }
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        return (FilterRegistration)this.filterRegisMap.get(filterName);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return Collections.unmodifiableMap(this.filterRegisMap);
    }

    @Override
    public synchronized SessionCookieConfig getSessionCookieConfig() {
        if (this.sessionCookieConfig == null) {
            this.sessionCookieConfig = new SessionCookieConfigImpl(this);
        }
        return this.sessionCookieConfig;
    }

    void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        this.sessionCookieNameInitialized = true;
    }

    @Override
    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    @Override
    public String getSessionParameterName() {
        if (this.sessionCookieNameInitialized && this.sessionCookieName != null && !this.sessionCookieName.isEmpty()) {
            return this.sessionCookieName;
        }
        return "jsessionid";
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes.contains((Object)SessionTrackingMode.SSL)) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00145"), new Object[]{SessionTrackingMode.SSL, this.getName()});
            throw new IllegalArgumentException(msg);
        }
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "setSessionTrackingModes", this.getName());
            throw new IllegalStateException(msg);
        }
        this.sessionTrackingModes = Collections.unmodifiableSet(sessionTrackingModes);
        if (sessionTrackingModes.contains((Object)SessionTrackingMode.COOKIE)) {
            this.setCookies(true);
        } else {
            this.setCookies(false);
        }
        if (sessionTrackingModes.contains((Object)SessionTrackingMode.URL)) {
            this.setEnableURLRewriting(true);
        } else {
            this.setEnableURLRewriting(false);
        }
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return EnumSet.copyOf(DEFAULT_SESSION_TRACKING_MODES);
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.sessionTrackingModes != null ? new HashSet<SessionTrackingMode>(this.sessionTrackingModes) : this.getDefaultSessionTrackingModes();
    }

    @Override
    public void addListener(String className) {
        this.addListener(className, true);
    }

    private void addListener(String className, boolean isProgrammatic) {
        EventListener listener = null;
        try {
            listener = this.loadListener(this.getClassLoader(), className);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
        this.addListener(listener, isProgrammatic);
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        this.addListener(t, true);
    }

    private <T extends EventListener> void addListener(T t, boolean isProgrammatic) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addListener", this.getName());
            throw new IllegalStateException(msg);
        }
        if (t instanceof ServletContextListener && isProgrammatic && !this.isProgrammaticServletContextListenerRegistrationAllowed) {
            throw new IllegalArgumentException("Not allowed to register ServletContextListener programmatically");
        }
        boolean added = false;
        if (t instanceof ServletContextAttributeListener || t instanceof ServletRequestAttributeListener || t instanceof ServletRequestListener || t instanceof HttpSessionAttributeListener || t instanceof HttpSessionIdListener) {
            this.eventListeners.add(t);
            added = true;
        }
        if (t instanceof HttpSessionListener) {
            this.sessionListeners.add((HttpSessionListener)t);
            if (!added) {
                added = true;
            }
        }
        if (t instanceof ServletContextListener) {
            boolean isFirst;
            ServletContextListener proxy = (ServletContextListener)t;
            if (isProgrammatic) {
                proxy = new RestrictedServletContextListener((ServletContextListener)t);
            }
            if (isFirst = "com.sun.faces.config.ConfigureListener".equals(t.getClass().getName())) {
                this.contextListeners.add(0, proxy);
            } else {
                this.contextListeners.add(proxy);
            }
            if (!added) {
                added = true;
            }
        }
        if (!added) {
            throw new IllegalArgumentException("Invalid listener type " + t.getClass().getName());
        }
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        EventListener listener = null;
        try {
            listener = this.createListenerInstance(listenerClass);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
        this.addListener(listener);
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (!(ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionIdListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz))) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00146"), clazz.getName());
            throw new IllegalArgumentException(msg);
        }
        try {
            return this.createListenerInstance(clazz);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void setJspConfigDescriptor(JspConfigDescriptor jspConfigDesc) {
        this.jspConfigDesc = jspConfigDesc;
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDesc;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader webappLoader;
        ClassLoader classLoader = webappLoader = this.getLoader() != null ? this.getLoader().getClassLoader() : null;
        if (webappLoader == null) {
            return null;
        }
        if (this.mySecurityManager != null) {
            this.mySecurityManager.checkGetClassLoaderPermission(webappLoader);
        }
        return webappLoader;
    }

    @Override
    public void declareRoles(String ... roleNames) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "declareRoles", this.getName());
            throw new IllegalStateException(msg);
        }
        for (String roleName : roleNames) {
            this.addSecurityRole(roleName);
        }
    }

    public void setEffectiveMajorVersion(int effectiveMajorVersion) {
        this.effectiveMajorVersion = effectiveMajorVersion;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.effectiveMajorVersion;
    }

    public void setEffectiveMinorVersion(int effectiveMinorVersion) {
        this.effectiveMinorVersion = effectiveMinorVersion;
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.effectiveMinorVersion;
    }

    @Override
    public String getVirtualServerName() {
        String virtualServerName = null;
        Container parent = this.getParent();
        if (parent != null) {
            virtualServerName = parent.getName();
        }
        return virtualServerName;
    }

    @Override
    public void addInstanceListener(String listener) {
        this.instanceListeners.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addInstanceListener", listener);
        }
    }

    public void addInstanceListener(InstanceListener listener) {
        this.instanceListenerInstances.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addInstanceListener", listener);
        }
    }

    @Override
    public void addJspMapping(String pattern) {
        String servletName = this.findServletMapping("*.jsp");
        if (servletName == null) {
            servletName = "jsp";
        }
        if (this.findChild(servletName) != null) {
            this.addServletMapping(pattern, servletName, true);
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Skipping {0} , no servlet {1}", new Object[]{pattern, servletName});
        }
    }

    @Override
    public void addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(locale, encoding);
    }

    @Override
    public void addLocalEjb(ContextLocalEjb ejb) {
        this.namingResources.addLocalEjb(ejb);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addLocalEjb", ejb.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestination(MessageDestination md) {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            this.messageDestinations.put(md.getName(), md);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMessageDestination", md.getName());
        }
    }

    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        this.namingResources.addMessageDestinationRef(mdr);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMessageDestinationRef", mdr.getName());
        }
    }

    @Override
    public void addMimeMapping(String extension, String mimeType) {
        this.mimeMappings.put(extension.toLowerCase(Locale.ENGLISH), mimeType);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMimeMapping", extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00147"), name);
            throw new IllegalArgumentException(msg);
        }
        if (this.parameters.get(name) != null) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00148"), name);
            throw new IllegalArgumentException(msg);
        }
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addParameter", name);
        }
    }

    @Override
    public void addResource(ContextResource resource) {
        this.namingResources.addResource(resource);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResource", resource.getName());
        }
    }

    @Override
    public void addResourceEnvRef(String name, String type) {
        this.namingResources.addResourceEnvRef(name, type);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceEnvRef", name);
        }
    }

    @Override
    public void addResourceLink(ContextResourceLink resourceLink) {
        this.namingResources.addResourceLink(resourceLink);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceLink", resourceLink.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoleMapping(String role, String link) {
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            this.roleMappings.put(role, link);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addRoleMapping", role);
        }
    }

    @Override
    public void addSecurityRole(String role) {
        this.securityRoles.add(role);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addSecurityRole", role);
        }
    }

    public Set<String> addServletMapping(ServletMap servletMap) {
        return this.addServletMapping(servletMap.getServletName(), servletMap.getURLPatterns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> addServletMapping(String name, String[] urlPatterns) {
        HashSet<String> conflicts = null;
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            for (String pattern : urlPatterns) {
                if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.urlDecode(pattern)))) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00149"), pattern);
                    throw new IllegalArgumentException(msg);
                }
                String existing = this.servletMappings.get(pattern);
                if (existing == null || existing.equals("default") || existing.equals("jsp") || name.equals("default") || name.equals("jsp")) continue;
                if (conflicts == null) {
                    conflicts = new HashSet<String>();
                }
                conflicts.add(pattern);
            }
            if (conflicts == null) {
                for (String urlPattern : urlPatterns) {
                    this.addServletMapping(urlPattern, name, false);
                }
                return Collections.emptySet();
            }
            return conflicts;
        }
    }

    @Override
    public void addServletMapping(String pattern, String name) {
        this.addServletMapping(pattern, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String pattern, String name, boolean jspWildCard) {
        ServletRegistrationImpl regis = (ServletRegistrationImpl)this.servletRegisMap.get(name);
        if (null == regis) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00150"), name);
            throw new IllegalArgumentException(msg);
        }
        if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.urlDecode(pattern)))) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00149"), pattern);
            throw new IllegalArgumentException(msg);
        }
        Map<String, String> msg = this.servletMappings;
        synchronized (msg) {
            String existing = this.servletMappings.get(pattern);
            if (existing != null) {
                if (!(existing.equals("default") || existing.equals("jsp") || name.equals("default") || name.equals("jsp"))) {
                    String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00151"), name, pattern, existing);
                    throw new IllegalArgumentException(msg2);
                }
                if (existing.equals("default") || existing.equals("jsp")) {
                    Wrapper wrapper = (Wrapper)this.findChild(existing);
                    this.removePatternFromServlet(wrapper, pattern);
                    this.mapper.removeWrapper(pattern);
                    this.servletMappings.put(pattern, name);
                }
            } else {
                this.servletMappings.put(pattern, name);
            }
        }
        StandardWrapper wrapper = regis.getWrapper();
        wrapper.addMapping(pattern);
        this.mapper.addWrapper(pattern, (Object)wrapper, jspWildCard, name, true);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addServletMapping", pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addServlet", this.getName());
            throw new IllegalStateException(msg);
        }
        if (servletName == null || servletName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00192"));
        }
        Map map = this.children;
        synchronized (map) {
            if (this.findChild(servletName) == null) {
                DynamicServletRegistrationImpl regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
                Wrapper wrapper = null;
                if (regis == null) {
                    wrapper = this.createWrapper();
                    wrapper.setServletClassName(className);
                } else {
                    wrapper = regis.getWrapper();
                    regis.setServletClassName(className);
                }
                wrapper.setName(servletName);
                this.addChild(wrapper, true, null == regis);
                if (null == regis) {
                    regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
                }
                return regis;
            }
            return null;
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.addServlet(servletName, servlet, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addServlet", this.getName());
            throw new IllegalStateException(msg);
        }
        if (servletName == null || servletName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00192"));
        }
        Map map = this.children;
        synchronized (map) {
            if (this.findChild(servletName) == null) {
                DynamicServletRegistrationImpl regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
                Wrapper wrapper = null;
                if (regis == null) {
                    wrapper = this.createWrapper();
                    wrapper.setServletClass(servletClass);
                } else {
                    wrapper = regis.getWrapper();
                    regis.setServletClass(servletClass);
                }
                wrapper.setName(servletName);
                this.addChild(wrapper, true, null == regis);
                if (null == regis) {
                    regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
                }
                return regis;
            }
            return null;
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet instance, Map<String, String> initParams) {
        return this.addServlet(servletName, instance, initParams, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet, Map<String, String> initParams, String ... urlPatterns) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addServlet", this.getName());
            throw new IllegalStateException(msg);
        }
        if (servletName == null || servletName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00192"));
        }
        if (servlet == null) {
            throw new NullPointerException(rb.getString("AS-WEB-CORE-00193"));
        }
        if (servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException("Servlet implements " + SingleThreadModel.class.getName());
        }
        Container host = this.getParent();
        if (host != null) {
            for (Container child : host.findChildren()) {
                if (child == this || !((StandardContext)child).hasServlet(servlet)) continue;
                return null;
            }
        }
        Map map = this.children;
        synchronized (map) {
            for (Map.Entry e : this.children.entrySet()) {
                if (!servletName.equals(e.getKey()) && servlet != ((StandardWrapper)e.getValue()).getServlet()) continue;
                return null;
            }
            DynamicServletRegistrationImpl regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
            StandardWrapper wrapper = null;
            wrapper = regis == null ? (StandardWrapper)this.createWrapper() : regis.getWrapper();
            wrapper.setName(servletName);
            wrapper.setServlet(servlet);
            if (initParams != null) {
                for (Map.Entry<String, String> e : initParams.entrySet()) {
                    wrapper.addInitParameter(e.getKey(), e.getValue());
                }
            }
            this.addChild(wrapper, true, null == regis);
            if (null == regis) {
                regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
            }
            if (urlPatterns != null) {
                for (String urlPattern : urlPatterns) {
                    this.addServletMapping(urlPattern, servletName, false);
                }
            }
            return regis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "addJspFile", this.getName());
            throw new IllegalStateException(msg);
        }
        if (servletName == null || servletName.length() == 0) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00192"));
        }
        Map map = this.children;
        synchronized (map) {
            if (this.findChild(servletName) == null) {
                DynamicServletRegistrationImpl regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
                Wrapper wrapper = null;
                wrapper = regis == null ? this.createWrapper() : regis.getWrapper();
                wrapper.setJspFile(jspFile);
                wrapper.setName(servletName);
                this.addChild(wrapper, true, null == regis);
                if (null == regis) {
                    regis = (DynamicServletRegistrationImpl)this.servletRegisMap.get(servletName);
                }
                return regis;
            }
            return null;
        }
    }

    protected void removePatternFromServlet(Wrapper wrapper, String pattern) {
        wrapper.removeMapping(pattern);
    }

    public boolean hasServlet(Servlet servlet) {
        for (Map.Entry e : this.children.entrySet()) {
            if (servlet != ((StandardWrapper)e.getValue()).getServlet()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return this.createServletInstance(clazz);
        }
        catch (Throwable t) {
            throw new ServletException("Unable to create Servlet from class " + clazz.getName(), t);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        return (ServletRegistration)this.servletRegisMap.get(servletName);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return Collections.unmodifiableMap(this.servletRegisMap);
    }

    @Override
    public void addWatchedResource(String name) {
        this.watchedResources.add(name);
        this.fireContainerEvent("addWatchedResource", name);
    }

    @Override
    public void addWelcomeFile(String name) {
        if (this.replaceWelcomeFiles) {
            this.welcomeFiles = new String[0];
            this.setReplaceWelcomeFiles(false);
        }
        String[] results = new String[this.welcomeFiles.length + 1];
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            results[i] = this.welcomeFiles[i];
        }
        results[this.welcomeFiles.length] = name;
        this.welcomeFiles = results;
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addWelcomeFile", name);
        }
    }

    @Override
    public void addWrapperLifecycle(String listener) {
        this.wrapperLifecycles.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addWrapperLifecycle", listener);
        }
    }

    @Override
    public void addWrapperListener(String listener) {
        this.wrapperListeners.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addWrapperListener", listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wrapper createWrapper() {
        String msg;
        Class<?> clazz;
        StandardWrapper wrapper = new StandardWrapper();
        List<Object> list = this.instanceListeners;
        synchronized (list) {
            for (String instanceListener : this.instanceListeners) {
                try {
                    Class<?> clazz2 = Class.forName(instanceListener);
                    wrapper.addInstanceListener((InstanceListener)clazz2.newInstance());
                }
                catch (Throwable t) {
                    String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00152"), instanceListener);
                    log.log(Level.SEVERE, msg2, t);
                    return null;
                }
            }
        }
        list = this.instanceListenerInstances;
        synchronized (list) {
            for (InstanceListener instanceListenerInstance : this.instanceListenerInstances) {
                wrapper.addInstanceListener(instanceListenerInstance);
            }
        }
        for (String wrapperLifecycle : this.wrapperLifecycles) {
            try {
                clazz = Class.forName(wrapperLifecycle);
                if (!(wrapper instanceof Lifecycle)) continue;
                ((Lifecycle)wrapper).addLifecycleListener((LifecycleListener)clazz.newInstance());
            }
            catch (Throwable t) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00153"), wrapperLifecycle);
                log.log(Level.SEVERE, msg, t);
                return null;
            }
        }
        for (String wrapperListener : this.wrapperListeners) {
            try {
                clazz = Class.forName(wrapperListener);
                wrapper.addContainerListener((ContainerListener)clazz.newInstance());
            }
            catch (Throwable t) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00154"), wrapperListener);
                log.log(Level.SEVERE, msg, t);
                return null;
            }
        }
        return wrapper;
    }

    @Override
    public List<ApplicationParameter> findApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public List<SecurityConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    @Override
    public ContextEjb findEjb(String name) {
        return this.namingResources.findEjb(name);
    }

    @Override
    public ContextEjb[] findEjbs() {
        return this.namingResources.findEjbs();
    }

    @Override
    public ContextEnvironment findEnvironment(String name) {
        return this.namingResources.findEnvironment(name);
    }

    @Override
    public ContextEnvironment[] findEnvironments() {
        return this.namingResources.findEnvironments();
    }

    @Override
    public ErrorPage findErrorPage(int errorCode) {
        if (errorCode >= 400 && errorCode < 600) {
            return this.statusPages.get(errorCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage findErrorPage(String exceptionType) {
        Map<String, ErrorPage> map = this.exceptionPages;
        synchronized (map) {
            return this.exceptionPages.get(exceptionType);
        }
    }

    @Override
    public ErrorPage getDefaultErrorPage() {
        return this.defaultErrorPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef findFilterDef(String filterName) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            return this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef[] findFilterDefs() {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    @Override
    public List<FilterMap> findFilterMaps() {
        return this.filterMaps;
    }

    @Override
    public List<String> findInstanceListeners() {
        return this.instanceListeners;
    }

    @Override
    public ContextLocalEjb findLocalEjb(String name) {
        return this.namingResources.findLocalEjb(name);
    }

    @Override
    public ContextLocalEjb[] findLocalEjbs() {
        return this.namingResources.findLocalEjbs();
    }

    public Context findMappingObject() {
        return (Context)this.getMappingObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination findMessageDestination(String name) {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            return this.messageDestinations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination[] findMessageDestinations() {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            return this.messageDestinations.values().toArray(new MessageDestination[this.messageDestinations.size()]);
        }
    }

    public MessageDestinationRef findMessageDestinationRef(String name) {
        return this.namingResources.findMessageDestinationRef(name);
    }

    public MessageDestinationRef[] findMessageDestinationRefs() {
        return this.namingResources.findMessageDestinationRefs();
    }

    @Override
    public String findMimeMapping(String extension) {
        return this.mimeMappings.get(extension.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String[] findMimeMappings() {
        return this.mimeMappings.keySet().toArray(new String[this.mimeMappings.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            return this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findParameters() {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            return this.parameters.keySet().toArray(new String[this.parameters.size()]);
        }
    }

    @Override
    public ContextResource findResource(String name) {
        return this.namingResources.findResource(name);
    }

    @Override
    public String findResourceEnvRef(String name) {
        return this.namingResources.findResourceEnvRef(name);
    }

    @Override
    public String[] findResourceEnvRefs() {
        return this.namingResources.findResourceEnvRefs();
    }

    @Override
    public ContextResourceLink findResourceLink(String name) {
        return this.namingResources.findResourceLink(name);
    }

    @Override
    public ContextResourceLink[] findResourceLinks() {
        return this.namingResources.findResourceLinks();
    }

    @Override
    public ContextResource[] findResources() {
        return this.namingResources.findResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findRoleMapping(String role) {
        String realRole = null;
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            realRole = this.roleMappings.get(role);
        }
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    @Override
    public boolean hasSecurityRole(String role) {
        return this.securityRoles.contains(role);
    }

    @Override
    public void removeSecurityRoles() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.securityRoles.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeSecurityRole", i.next());
            }
        }
        this.securityRoles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findServletMapping(String pattern) {
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            return this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findServletMappings() {
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            String[] results = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(results);
        }
    }

    @Override
    public ErrorPage findStatusPage(int status) {
        return this.statusPages.get(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] findStatusPages() {
        Map<Integer, ErrorPage> map = this.statusPages;
        synchronized (map) {
            int[] results = new int[this.statusPages.size()];
            Iterator<Integer> elements = this.statusPages.keySet().iterator();
            int i = 0;
            while (elements.hasNext()) {
                results[i++] = elements.next();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            for (String welcomeFile : this.welcomeFiles) {
                if (!name.equals(welcomeFile)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public List<String> getWatchedResources() {
        return this.watchedResources;
    }

    @Override
    public String[] findWelcomeFiles() {
        return this.welcomeFiles;
    }

    @Override
    public List<String> findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    @Override
    public List<String> findWrapperListeners() {
        return this.wrapperListeners;
    }

    @Override
    public Authenticator getAuthenticator() {
        Pipeline p = this.getPipeline();
        if (p != null) {
            for (GlassFishValve valve : p.getValves()) {
                if (!(valve instanceof Authenticator)) continue;
                return (Authenticator)((Object)valve);
            }
        }
        return null;
    }

    @Override
    public synchronized void reload() {
        String msg;
        if (!this.started) {
            String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00111"), this.logName());
            throw new IllegalStateException(msg2);
        }
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00155");
        }
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00156"), this);
            log.log(Level.SEVERE, msg, e);
        }
        try {
            this.start();
        }
        catch (LifecycleException e) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00157"), this);
            log.log(Level.SEVERE, msg, e);
        }
        this.setPaused(false);
    }

    @Override
    public void removeApplicationParameter(String name) {
        ApplicationParameter match = null;
        for (ApplicationParameter applicationParameter : this.applicationParameters) {
            if (!name.equals(applicationParameter.getName())) continue;
            match = applicationParameter;
            break;
        }
        if (match != null) {
            this.applicationParameters.remove(match);
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeApplicationParameter", name);
            }
        }
    }

    @Override
    public void removeChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00134"));
        }
        super.removeChild(child);
    }

    @Override
    public void removeConstraints() {
        if (this.notifyContainerListeners) {
            Iterator<SecurityConstraint> i = this.constraints.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeConstraint", i.next());
            }
        }
        this.constraints.clear();
    }

    @Override
    public void removeEjb(String name) {
        this.namingResources.removeEjb(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeEjb", name);
        }
    }

    @Override
    public void removeEnvironment(String name) {
        if (this.namingResources == null) {
            return;
        }
        ContextEnvironment env = this.namingResources.findEnvironment(name);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + name + "'");
        }
        this.namingResources.removeEnvironment(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeEnvironment", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeErrorPages() {
        Map<Object, ErrorPage> map = this.exceptionPages;
        synchronized (map) {
            if (this.notifyContainerListeners) {
                for (ErrorPage errorPage : this.exceptionPages.values()) {
                    this.fireContainerEvent("removeErrorPage", errorPage);
                }
            }
            this.exceptionPages.clear();
        }
        map = this.statusPages;
        synchronized (map) {
            if (this.notifyContainerListeners) {
                for (ErrorPage statusPage : this.statusPages.values()) {
                    this.fireContainerEvent("removeErrorPage", statusPage);
                }
            }
            this.statusPages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterDef(FilterDef filterDef) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeFilterDef", filterDef);
        }
    }

    @Override
    public void removeFilterMaps() {
        if (this.notifyContainerListeners) {
            Iterator<FilterMap> i = this.filterMaps.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeFilterMap", i.next());
            }
        }
        this.filterMaps.clear();
    }

    @Override
    public void removeInstanceListener(String listener) {
        this.instanceListeners.remove(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeInstanceListener", listener);
        }
    }

    @Override
    public void removeLocalEjb(String name) {
        this.namingResources.removeLocalEjb(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeLocalEjb", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestination(String name) {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            this.messageDestinations.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMessageDestination", name);
        }
    }

    public void removeMessageDestinationRef(String name) {
        this.namingResources.removeMessageDestinationRef(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMessageDestinationRef", name);
        }
    }

    @Override
    public void removeMimeMapping(String extension) {
        this.mimeMappings.remove(extension.toLowerCase(Locale.ENGLISH));
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMimeMapping", extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeParameter", name);
        }
    }

    @Override
    public void removeResource(String resourceName) {
        String decoded = URLDecoder.decode(resourceName);
        if (this.namingResources == null) {
            return;
        }
        ContextResource resource = this.namingResources.findResource(decoded);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + decoded + "'");
        }
        this.namingResources.removeResource(decoded);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResource", decoded);
        }
    }

    @Override
    public void removeResourceEnvRef(String name) {
        this.namingResources.removeResourceEnvRef(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResourceEnvRef", name);
        }
    }

    @Override
    public void removeResourceLink(String link) {
        String decoded = URLDecoder.decode(link);
        if (this.namingResources == null) {
            return;
        }
        ContextResourceLink resource = this.namingResources.findResourceLink(decoded);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + decoded + "'");
        }
        this.namingResources.removeResourceLink(decoded);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResourceLink", decoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoleMapping(String role) {
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            this.roleMappings.remove(role);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeRoleMapping", role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServletMapping(String pattern) {
        String name = null;
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            name = this.servletMappings.remove(pattern);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper != null) {
            wrapper.removeMapping(pattern);
        }
        this.mapper.removeWrapper(pattern);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeServletMapping", pattern);
        }
    }

    @Override
    public boolean hasWatchedResources() {
        return !this.watchedResources.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWatchedResources() {
        List<String> list = this.watchedResources;
        synchronized (list) {
            if (this.notifyContainerListeners) {
                Iterator<String> i = this.watchedResources.iterator();
                while (i.hasNext()) {
                    this.fireContainerEvent("removeWatchedResource", i.next());
                }
            }
            this.watchedResources.clear();
        }
    }

    @Override
    public void removeWelcomeFiles() {
        if (this.notifyContainerListeners) {
            for (String welcomeFile : this.welcomeFiles) {
                this.fireContainerEvent("removeWelcomeFile", welcomeFile);
            }
        }
        this.welcomeFiles = new String[0];
    }

    @Override
    public void removeWrapperLifecycles() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.wrapperLifecycles.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeWrapperLifecycle", i.next());
            }
        }
        this.wrapperLifecycles.clear();
    }

    @Override
    public void removeWrapperListeners() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.wrapperListeners.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeWrapperListener", i.next());
            }
        }
        this.wrapperListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireRequestInitializedEvent(ServletRequest request) {
        List<EventListener> listeners = this.getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (!listeners.isEmpty()) {
            event = new ServletRequestEvent(this.getServletContext(), request);
            for (EventListener eventListener : listeners) {
                if (!(eventListener instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)eventListener;
                this.fireContainerEvent("beforeRequestInitialized", listener);
                try {
                    listener.requestInitialized(event);
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00158"), listener.getClass().getName());
                    log.log(Level.WARNING, msg, t);
                    request.setAttribute("javax.servlet.error.exception", t);
                }
                finally {
                    this.fireContainerEvent("afterRequestInitialized", listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireRequestDestroyedEvent(ServletRequest request) {
        List<EventListener> listeners = this.getApplicationEventListeners();
        if (!listeners.isEmpty()) {
            ServletRequestEvent event = new ServletRequestEvent(this.getServletContext(), request);
            int len = listeners.size();
            for (int i = 0; i < len; ++i) {
                EventListener eventListener = listeners.get(len - 1 - i);
                if (!(eventListener instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)eventListener;
                this.fireContainerEvent("beforeRequestDestroyed", listener);
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00159"), listener.getClass().getName());
                    log.log(Level.WARNING, msg, t);
                    request.setAttribute("javax.servlet.error.exception", t);
                    continue;
                }
                finally {
                    this.fireContainerEvent("afterRequestDestroyed", listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting filters");
        }
        boolean ok = true;
        Map<String, FilterConfig> map = this.filterConfigs;
        synchronized (map) {
            this.filterConfigs.clear();
            for (Map.Entry<String, FilterDef> entry : this.filterDefs.entrySet()) {
                String name = entry.getKey();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, " Starting filter ''{0}''", name);
                }
                try {
                    this.filterConfigs.put(name, new ApplicationFilterConfig(this, entry.getValue()));
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00160"), name);
                    this.getServletContext().log(msg, t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Stopping filters");
        }
        Map<String, FilterConfig> map = this.filterConfigs;
        synchronized (map) {
            for (Map.Entry<String, FilterConfig> entry : this.filterConfigs.entrySet()) {
                String filterName = entry.getKey();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, " Stopping filter ''{0}''", filterName);
                }
                ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)entry.getValue();
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return this.filterConfigs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void contextListenerStart() {
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (ServletContextListener servletContextListener : this.contextListeners) {
            void var3_3;
            if (servletContextListener instanceof RestrictedServletContextListener) {
                ServletContextListener servletContextListener2 = ((RestrictedServletContextListener)servletContextListener).getNestedListener();
                this.context.setRestricted(true);
            }
            try {
                this.fireContainerEvent("beforeContextInitialized", var3_3);
                var3_3.contextInitialized(event);
            }
            finally {
                this.context.setRestricted(false);
                this.fireContainerEvent("afterContextInitialized", var3_3);
            }
        }
        Collection servletRegistrations = this.servletRegisMap.values();
        for (ServletRegistrationImpl regis : servletRegistrations) {
            if (null != regis.getClassName() || null != regis.getJspFile()) continue;
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00161"), regis.getName());
            throw new IllegalStateException(msg);
        }
        Collection collection = this.filterRegisMap.values();
        for (FilterRegistrationImpl regis : collection) {
            if (null != regis.getClassName()) continue;
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00162"), regis.getName());
            throw new IllegalStateException(msg);
        }
        this.isContextInitializedCalled = true;
    }

    protected EventListener loadListener(ClassLoader loader, String listenerClassName) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Configuring event listener class ''{0}''", listenerClassName);
        }
        return this.createListener(loader.loadClass(listenerClassName));
    }

    private boolean contextListenerStop() {
        boolean ok = true;
        if (this.contextListeners.isEmpty()) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        int len = this.contextListeners.size();
        for (int i = 0; i < len; ++i) {
            ServletContextListener listener = this.contextListeners.get(len - 1 - i);
            if (listener instanceof RestrictedServletContextListener) {
                listener = ((RestrictedServletContextListener)listener).getNestedListener();
                this.context.setRestricted(true);
            }
            try {
                this.fireContainerEvent("beforeContextDestroyed", listener);
                listener.contextDestroyed(event);
                this.fireContainerEvent("afterContextDestroyed", listener);
                continue;
            }
            catch (Throwable t) {
                this.context.setRestricted(false);
                this.fireContainerEvent("afterContextDestroyed", listener);
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00163"), listener.getClass().getName());
                this.getServletContext().log(msg, t);
                ok = false;
            }
        }
        this.contextListeners.clear();
        return ok;
    }

    private void sessionListenerStop() {
        for (HttpSessionListener listener : this.sessionListeners) {
            if (listener instanceof ServletContextListener) continue;
            this.fireContainerEvent("predestroy", listener);
        }
        this.sessionListeners.clear();
    }

    private boolean eventListenerStop() {
        if (this.eventListeners.isEmpty()) {
            return true;
        }
        for (EventListener listener : this.eventListeners) {
            if (listener instanceof ServletContextListener || listener instanceof HttpSessionListener) continue;
            this.fireContainerEvent("predestroy", listener);
        }
        this.eventListeners.clear();
        return true;
    }

    private void mergeParameters() {
        HashMap<String, String> mergedParams = new HashMap<String, String>();
        for (String name : this.findParameters()) {
            mergedParams.put(name, this.findParameter(name));
        }
        for (ApplicationParameter param : this.findApplicationParameters()) {
            if (param.getOverride()) {
                if (mergedParams.get(param.getName()) != null) continue;
                mergedParams.put(param.getName(), param.getValue());
                continue;
            }
            mergedParams.put(param.getName(), param.getValue());
        }
        ServletContext sc = this.getServletContext();
        for (Map.Entry entry : mergedParams.entrySet()) {
            sc.setInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean resourcesStart() {
        boolean ok = true;
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        try {
            ProxyDirContext proxyDirContext = new ProxyDirContext(env, this.webappResources);
            if (this.webappResources instanceof BaseDirContext) {
                ((BaseDirContext)this.webappResources).setDocBase(this.getBasePath(this.getDocBase()));
                ((BaseDirContext)this.webappResources).allocate();
            }
            this.resources = proxyDirContext;
        }
        catch (Throwable t) {
            if (log.isLoggable(Level.FINE)) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00164"), this.getName());
                log.log(Level.SEVERE, msg, t);
            } else {
                log.log(Level.SEVERE, "AS-WEB-CORE-00167", new Object[]{this.getName(), t.getMessage()});
            }
            ok = false;
        }
        return ok;
    }

    public void alternateResourcesStart() throws LifecycleException {
        if (this.alternateDocBases == null || this.alternateDocBases.isEmpty()) {
            return;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        for (AlternateDocBase alternateDocBase : this.alternateDocBases) {
            String basePath = alternateDocBase.getBasePath();
            DirContext alternateWebappResources = ContextsAdapterUtility.unwrap(alternateDocBase.getWebappResources());
            try {
                ProxyDirContext proxyDirContext = new ProxyDirContext(env, alternateWebappResources);
                if (alternateWebappResources instanceof BaseDirContext) {
                    ((BaseDirContext)alternateWebappResources).setDocBase(basePath);
                    ((BaseDirContext)alternateWebappResources).allocate();
                }
                alternateDocBase.setResources(ContextsAdapterUtility.wrap((DirContext)proxyDirContext));
            }
            catch (Throwable t) {
                if (log.isLoggable(Level.FINE)) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00164"), this.getName());
                    throw new LifecycleException(msg, t);
                }
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00167"), this.getName(), t.getMessage());
                throw new LifecycleException(msg);
            }
        }
    }

    public boolean resourcesStop() {
        boolean ok = true;
        try {
            if (this.resources != null) {
                if (this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).stop();
                }
                if (this.webappResources instanceof BaseDirContext) {
                    ((BaseDirContext)this.webappResources).release();
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00165", t);
            ok = false;
        }
        this.resources = null;
        this.webappResources = null;
        this.servletRegisMap.clear();
        this.filterRegisMap.clear();
        return ok;
    }

    public boolean alternateResourcesStop() {
        boolean ok = true;
        if (this.alternateDocBases == null || this.alternateDocBases.isEmpty()) {
            return ok;
        }
        for (AlternateDocBase alternateDocBase : this.alternateDocBases) {
            DirContext alternateWebappResources;
            DirContext alternateResources = ContextsAdapterUtility.unwrap(alternateDocBase.getResources());
            if (alternateResources instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)alternateResources)).stop();
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00165", t);
                    ok = false;
                }
            }
            if (!((alternateWebappResources = ContextsAdapterUtility.unwrap(alternateDocBase.getWebappResources())) instanceof BaseDirContext)) continue;
            try {
                ((BaseDirContext)alternateWebappResources).release();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00165", t);
                ok = false;
            }
        }
        this.alternateDocBases = null;
        return ok;
    }

    public void loadOnStartup(Container[] children) throws LifecycleException {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (Container aChildren : children) {
            Wrapper wrapper = (Wrapper)aChildren;
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            Integer key = loadOnStartup;
            ArrayList<Wrapper> list = (ArrayList<Wrapper>)map.get(key);
            if (list == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (List list : map.values()) {
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00188"), this.getName());
                    this.getServletContext().log(msg, StandardWrapper.getRootCause(e));
                    throw new LifecycleException(StandardWrapper.getRootCause(e));
                }
            }
        }
    }

    protected void managerStart() throws LifecycleException {
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getManager())).start();
        }
    }

    protected void managerStop() throws LifecycleException {
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "AS-WEB-CORE-00171", this.logName());
            }
            return;
        }
        long startupTimeStart = System.currentTimeMillis();
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (Exception ex) {
                throw new LifecycleException("Error initializaing ", ex);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting {0}", "".equals(this.getName()) ? "ROOT" : this.getName());
        }
        this.preRegisterJMX();
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.setAvailable(false);
        this.setConfigured(false);
        if (this.webappResources == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Configuring default Resources");
            }
            try {
                if (this.docBase != null && this.docBase.endsWith(".war") && !new File(this.docBase).isDirectory()) {
                    this.setResources((DirContext)new WARDirContext());
                } else {
                    this.setResources((DirContext)new WebDirContext());
                }
            }
            catch (IllegalArgumentException e) {
                throw new LifecycleException(rb.getString("AS-WEB-CORE-00172"), e);
            }
        }
        this.resourcesStart();
        if (this.alternateDocBases != null && !this.alternateDocBases.isEmpty()) {
            for (AlternateDocBase alternateDocBase : this.alternateDocBases) {
                Container[] docBase = alternateDocBase.getDocBase();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Configuring alternate resources");
                }
                try {
                    if (docBase != null && docBase.endsWith(".war") && !new File((String)docBase).isDirectory()) {
                        this.setAlternateResources(alternateDocBase, (DirContext)new WARDirContext());
                        continue;
                    }
                    this.setAlternateResources(alternateDocBase, (DirContext)new FileDirContext());
                }
                catch (IllegalArgumentException e) {
                    throw new LifecycleException(rb.getString("AS-WEB-CORE-00172"), e);
                }
            }
            this.alternateResourcesStart();
        }
        if (this.getLoader() == null) {
            this.createLoader();
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        try {
            ExtensionValidator.validateApplication(this.getResources(), this);
        }
        catch (IOException ioe) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00173"), this);
            throw new LifecycleException(msg, ioe);
        }
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && "false".equals(useNamingProperty)) {
            this.useNaming = false;
        }
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.namingContextListener.setName(this.getNamingContextName());
            this.addLifecycleListener(this.namingContextListener);
        }
        ClassLoader oldCCL = null;
        try {
            this.started = true;
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).start();
            }
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)((Object)this.logger)).start();
            }
            oldCCL = this.bindThread();
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)((Object)this.realm)).start();
            }
            if (this.resources != null && this.resources instanceof Lifecycle) {
                ((Lifecycle)((Object)this.resources)).start();
            }
            for (Container child : this.findChildren()) {
                if (!(child instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)child)).start();
            }
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)((Object)this.pipeline)).start();
            }
            this.lifecycle.fireLifecycleEvent("start", null);
            this.unbindThread(oldCCL);
        }
        catch (Throwable t) {
            try {
                throw new LifecycleException(t);
            }
            catch (Throwable throwable) {
                this.unbindThread(oldCCL);
                throw throwable;
            }
        }
        if (!this.getConfigured()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00174"), this.getName());
            throw new LifecycleException(msg);
        }
        this.postResources();
        if (this.orderedLibs != null && !this.orderedLibs.isEmpty()) {
            this.getServletContext().setAttribute("javax.servlet.context.orderedLibs", this.orderedLibs);
            this.context.setAttributeReadOnly("javax.servlet.context.orderedLibs");
        }
        this.mapper.setContext(this.getPath(), this.welcomeFiles, (NamingContext)ContextsAdapterUtility.wrap(this.resources));
        oldCCL = this.bindThread();
        try {
            this.mergeParameters();
            this.lifecycle.fireLifecycleEvent("after_start", null);
            this.callServletContainerInitializers();
            this.contextListenerStart();
            if (this.manager != null && this.manager instanceof Lifecycle) {
                ((Lifecycle)((Object)this.getManager())).start();
            }
            super.threadStart();
            this.filterStart();
            this.loadOnStartup(this.findChildren());
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00174", this.getName());
            try {
                this.stop();
            }
            catch (Throwable tt) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00175", tt);
            }
            throw new LifecycleException(t);
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Startup successfully completed");
        }
        this.setAvailable(true);
        this.registerJMX();
        this.startTimeMillis = System.currentTimeMillis();
        this.startupTime = this.startTimeMillis - startupTimeStart;
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.running", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
        if (this.getLoader() instanceof WebappLoader) {
            ((WebappLoader)this.getLoader()).closeJARs(true);
        }
    }

    protected Types getTypes() {
        return null;
    }

    protected boolean isStandalone() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void callServletContainerInitializers() throws LifecycleException {
        Map interestList = ServletContainerInitializerUtil.getInterestList(this.servletContainerInitializers);
        Map initializerList = ServletContainerInitializerUtil.getInitializerList(this.servletContainerInitializers, (Map)interestList, (Types)this.getTypes(), (ClassLoader)this.getClassLoader(), (boolean)this.isStandalone());
        if (initializerList == null) {
            return;
        }
        this.isProgrammaticServletContextListenerRegistrationAllowed = true;
        ServletContext ctxt = this.getServletContext();
        try {
            for (Map.Entry e : initializerList.entrySet()) {
                Class initializer = (Class)e.getKey();
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Calling ServletContainerInitializer [{0}] onStartup with classes {1}", new Object[]{initializer, e.getValue()});
                    }
                    ServletContainerInitializer iniInstance = (ServletContainerInitializer)initializer.newInstance();
                    this.fireContainerEvent("beforeContextInitializerOnStartup", iniInstance);
                    iniInstance.onStartup((Set)initializerList.get(initializer), ctxt);
                    this.fireContainerEvent("afterContextInitializerOnStartup", iniInstance);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, MessageFormat.format(rb.getString("AS-WEB-CORE-00176"), initializer.getCanonicalName()), t);
                    throw new LifecycleException(t);
                    return;
                }
            }
        }
        finally {
            this.isProgrammaticServletContextListenerRegistrationAllowed = false;
        }
    }

    public void setServletContainerInitializerInterestList(Iterable<ServletContainerInitializer> initializers) {
        this.servletContainerInitializers = initializers;
    }

    public void createLoader() {
        ClassLoader parent = null;
        if (this.getPrivileged()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Configuring privileged default Loader");
            }
            parent = this.getClass().getClassLoader();
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Configuring non-privileged default Loader");
            }
            parent = this.getParentClassLoader();
        }
        WebappLoader webappLoader = new WebappLoader(parent);
        webappLoader.setDelegate(this.getDelegate());
        webappLoader.setUseMyFaces(this.useMyFaces);
        this.setLoader(webappLoader);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        this.stop(false);
    }

    public synchronized void stop(boolean isShutdown) throws LifecycleException {
        Notification notification;
        if (!this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "AS-WEB-CORE-00111", this.logName());
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        if (this.getObjectName() != null) {
            Notification notification2 = new Notification("j2ee.state.stopping", this, this.sequenceNumber++);
            this.sendNotification(notification2);
        }
        this.setAvailable(false);
        ClassLoader oldCCL = this.bindThread();
        try {
            for (Container child : this.findChildren()) {
                if (!(child instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)child)).stop();
            }
            this.filterStop();
            super.threadStop();
            if (this.manager != null && this.manager instanceof Lifecycle) {
                if (this.manager instanceof StandardManager) {
                    ((StandardManager)this.manager).stop(isShutdown);
                } else {
                    ((Lifecycle)((Object)this.manager)).stop();
                }
            }
            this.contextListenerStop();
            this.sessionListenerStop();
            if (this.context != null) {
                this.context.clearAttributes();
            }
            this.eventListenerStop();
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            this.setCharsetMapper(null);
            this.resourcesStop();
            this.alternateResourcesStop();
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)((Object)this.realm)).stop();
            }
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)((Object)this.logger)).stop();
            }
        }
        catch (Throwable t) {
            if (this.started) {
                this.lifecycle.fireLifecycleEvent("stop", null);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException(t);
        }
        finally {
            this.unbindThread(oldCCL);
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).stop();
            }
        }
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00177"), this);
            log.log(Level.SEVERE, msg, ex);
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Stopping complete");
        }
        if (this.oname != null) {
            notification = new Notification("j2ee.object.deleted", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
        this.isContextInitializedCalled = false;
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        if (this.getManager() instanceof ManagerBase) {
            ((ManagerBase)this.getManager()).release();
        }
        this.instanceListeners.clear();
        this.instanceListenerInstances.clear();
    }

    private void resetContext() throws Exception, MBeanRegistrationException {
        this.children = new HashMap();
        this.startupTime = 0L;
        this.startTimeMillis = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.eventListeners.clear();
        this.contextListeners.clear();
        this.sessionListeners.clear();
        this.requestCharacterEncoding = null;
        this.responseCharacterEncoding = DEFAULT_RESPONSE_CHARACTER_ENCODING;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "resetContext {0}", this.oname);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void backgroundProcess() {
        if (!this.started) {
            return;
        }
        this.count = (this.count + 1) % this.managerChecksFrequency;
        if (this.getManager() != null && this.count == 0) {
            if (this.getManager() instanceof StandardManager) {
                ((StandardManager)this.getManager()).processExpires();
            } else if (this.getManager() instanceof PersistentManagerBase) {
                PersistentManagerBase pManager = (PersistentManagerBase)this.getManager();
                pManager.backgroundProcess();
            }
        }
        if (this.isReload() && this.getLoader() != null) {
            if (this.reloadable && this.getLoader().modified()) {
                try {
                    Thread.currentThread().setContextClassLoader(standardContextClassLoader);
                    this.reload();
                }
                finally {
                    if (this.getLoader() != null) {
                        Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    }
                }
            }
            if (this.getLoader() instanceof WebappLoader) {
                ((WebappLoader)this.getLoader()).closeJARs(false);
            }
        }
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "AS-WEB-CORE-00178", urlPattern);
        }
        return "/" + urlPattern;
    }

    protected boolean isServlet22() {
        return this.publicId != null && this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)this.getParent().getParent();
            base = eng.getBaseDir();
        }
        return new File(base);
    }

    private ClassLoader bindThread() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread((Object)this, (Object)this);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "AS-WEB-CORE-00187", e);
            }
        }
        return oldContextClassLoader;
    }

    private void unbindThread(ClassLoader oldContextClassLoader) {
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        if (this.isUseNaming()) {
            ContextBindings.unbindThread((Object)this, (Object)this);
        }
    }

    private String getBasePath(String docBase) {
        Container container;
        String basePath = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(docBase);
        if (!file.isAbsolute()) {
            if (container == null) {
                basePath = new File(this.engineBase(), docBase).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                basePath = new File(file, docBase).getPath();
            }
        } else {
            basePath = file.getPath();
        }
        return basePath;
    }

    protected String getDefaultConfigFile() {
        String basename = null;
        String path = this.getPath();
        basename = "".equals(path) ? "ROOT" : path.substring(1).replace('/', '_');
        return basename + ".xml";
    }

    public String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuilder buff = new StringBuilder();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/").append((String)stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
            this.namingContextName = this.namingContextName + instanceIDCounter.getAndIncrement();
        }
        return this.namingContextName;
    }

    public boolean getPaused() {
        return this.paused;
    }

    private void postResources() {
        this.getServletContext().setAttribute("org.apache.catalina.resources", this.getResources());
        this.context.setAttributeReadOnly("org.apache.catalina.resources");
        this.getServletContext().setAttribute("org.apache.catalina.alternateResources", this.getAlternateDocBases());
        this.context.setAttributeReadOnly("org.apache.catalina.alternateResources");
    }

    public String getHostname() {
        Container parentHost = this.getParent();
        if (parentHost != null) {
            this.hostName = parentHost.getName();
        }
        if (this.hostName == null || this.hostName.length() < 1) {
            this.hostName = "_";
        }
        return this.hostName;
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null || workDir.length() == 0) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00179", dir.getAbsolutePath());
        }
        this.getServletContext().setAttribute("javax.servlet.context.tempdir", dir);
        this.context.setAttributeReadOnly("javax.servlet.context.tempdir");
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    protected boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.isEmpty()) {
            return true;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            log.log(Level.WARNING, "AS-WEB-CORE-00180", urlPattern);
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf(47) < 0) {
                this.checkUnusualURLPattern(urlPattern);
                return true;
            }
            return false;
        }
        if (urlPattern.startsWith("/") && !urlPattern.contains("*.")) {
            this.checkUnusualURLPattern(urlPattern);
            return true;
        }
        return false;
    }

    private void checkUnusualURLPattern(String urlPattern) {
        if (log.isLoggable(Level.INFO) && urlPattern.endsWith("*") && (urlPattern.length() < 2 || urlPattern.charAt(urlPattern.length() - 2) != '/')) {
            String msg = "Suspicious url pattern: \"" + urlPattern + "\" in context [" + this.getName() + "] - see section SRV.11.2 of the Servlet specification";
            log.log(Level.INFO, msg);
        }
    }

    public String[] getEnvironments() {
        ContextEnvironment[] envs = this.getNamingResources().findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        for (ContextEnvironment env : envs) {
            try {
                ObjectName oname = this.createObjectName(env);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot create object name for environment " + env, e);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceNames() {
        ContextResource[] resources = this.getNamingResources().findResources();
        ArrayList<String> results = new ArrayList<String>();
        for (ContextResource resource : resources) {
            try {
                ObjectName oname = this.createObjectName(resource);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot create object name for resource " + resource, e);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] links = this.getNamingResources().findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        for (ContextResourceLink link : links) {
            try {
                ObjectName oname = this.createObjectName(link);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot create object name for resource " + link, e);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type);
        nresources.addEnvironment(env);
        return this.createObjectName(env).toString();
    }

    public String addResource(String resourceName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type);
        nresources.addResource(resource);
        return this.createObjectName(resource).toString();
    }

    public String addResourceLink(String resourceLinkName, String global, String name, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setGlobal(global);
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type);
        nresources.addResourceLink(resourceLink);
        return this.createObjectName(resourceLink).toString();
    }

    @Override
    public ObjectName createObjectName(String hostDomain, ObjectName parentName) throws MalformedObjectNameException {
        StandardHost hst = (StandardHost)this.getParent();
        String hostName = this.getParent().getName();
        String name = "//" + (hostName == null ? "DEFAULT" : hostName) + ("".equals(this.encodedPath) ? "/" : this.encodedPath);
        String suffix = ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer();
        String onameStr = "j2eeType=WebModule,name=" + name + suffix;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Registering {0} for {1}", new Object[]{onameStr, this.oname});
        }
        if (this.getDomain() == null) {
            this.domain = hst.getDomain();
        }
        return new ObjectName(this.getDomain() + ":" + onameStr);
    }

    private void preRegisterJMX() {
        block3: {
            try {
                StandardHost host = (StandardHost)this.getParent();
                if (this.oname == null || this.oname.getKeyProperty("j2eeType") == null) {
                    this.controller = this.oname = this.createObjectName(host.getDomain(), host.getJmxName());
                }
            }
            catch (Exception ex) {
                if (!log.isLoggable(Level.INFO)) break block3;
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00189"), this, this.oname, ex.toString());
                log.log(Level.INFO, msg, ex);
            }
        }
    }

    private void registerJMX() {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Checking for {0}", this.oname);
            }
            this.controller = this.oname;
            if (this.getObjectName() != null) {
                Notification notification = new Notification("j2ee.object.created", this, this.sequenceNumber++);
                this.sendNotification(notification);
            }
            for (Container child : this.findChildren()) {
                ((StandardWrapper)child).registerJMX(this);
            }
        }
        catch (Exception exception) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00190"), this, this.oname, exception.toString());
            log.log(Level.INFO, msg, exception);
        }
    }

    public void sendNotification(Notification notification) {
        if (this.broadcaster == null) {
            this.broadcaster = ((StandardEngine)this.getParent().getParent()).getService().getBroadcaster();
        }
        if (this.broadcaster != null) {
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public void init() throws Exception {
        if (this.getParent() == null) {
            ContextConfig config = new ContextConfig();
            this.addLifecycleListener(config);
        }
        if (this.initialized) {
            return;
        }
        super.init();
        this.lifecycle.fireLifecycleEvent("init", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this, this.sequenceNumber++);
            this.sendNotification(notification);
        }
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        String path = this.oname.getKeyProperty("name");
        if (path == null) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00181", this.getName());
            return null;
        }
        if (!path.startsWith("//")) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00182", this.getName());
        }
        path = path.substring(2);
        int delim = path.indexOf(47);
        this.hostName = "localhost";
        if (delim > 0) {
            this.hostName = path.substring(0, delim);
            if ("/".equals(path = path.substring(delim))) {
                this.setName("");
            } else {
                this.setName(path);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Setting path " + path);
            }
            this.setName(path);
        }
        String parentDomain = this.getEngineName();
        if (parentDomain == null) {
            parentDomain = this.domain;
        }
        return new ObjectName(parentDomain + ":type=Host,host=" + this.hostName);
    }

    public void create() throws Exception {
        this.init();
    }

    public ObjectName createObjectName(ContextEnvironment environment) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = environment.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(this.domain + ":type=Environment,resourcetype=Global,name=" + environment.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(this.domain + ":type=Environment,resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + environment.getName());
        }
        return name;
    }

    public ObjectName createObjectName(ContextResource resource) throws MalformedObjectNameException {
        ObjectName name = null;
        String encodedResourceName = urlEncoder.encode(resource.getName());
        Object container = resource.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(this.domain + ":type=Resource,resourcetype=Global,class=" + resource.getType() + ",name=" + encodedResourceName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(this.domain + ":type=Resource,resourcetype=Context,path=" + path + ",host=" + host.getName() + ",class=" + resource.getType() + ",name=" + encodedResourceName);
        }
        return name;
    }

    public ObjectName createObjectName(ContextResourceLink resourceLink) throws MalformedObjectNameException {
        ObjectName name = null;
        String encodedResourceLinkName = urlEncoder.encode(resourceLink.getName());
        Object container = resourceLink.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(this.domain + ":type=ResourceLink,resourcetype=Global,name=" + encodedResourceLinkName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(this.domain + ":type=ResourceLink,resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + encodedResourceLinkName);
        }
        return name;
    }

    @Override
    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.context.getAttributeNames();
    }

    @Override
    public String getContextPath() {
        return this.getPath();
    }

    @Override
    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        Context child = null;
        try {
            int slash;
            Host host = (Host)this.getParent();
            String mapuri = uri;
            while ((child = (Context)host.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
                mapuri = mapuri.substring(0, slash);
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (child == null) {
            return null;
        }
        if (this.getCrossContext()) {
            return child.getServletContext();
        }
        if (child == this) {
            return this.getServletContext();
        }
        return null;
    }

    @Override
    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.isContextInitializedCalled) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00143"), "setInitParameter", this.getName());
            throw new IllegalStateException(msg);
        }
        return this.context.setInitParameter(name, value);
    }

    @Override
    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.findMimeMapping(extension);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationDispatcher(wrapper, null, null, null, null, null, name);
    }

    @Override
    public String getServletContextName() {
        return this.getDisplayName();
    }

    @Override
    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.context.setAttribute(name, value);
    }

    @Override
    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    @Override
    public String getRealPath(String path) {
        AlternateDocBase match;
        if (!this.showArchivedRealPathEnabled && !this.directoryDeployed) {
            return null;
        }
        if (!this.isFilesystemBased()) {
            return null;
        }
        if (path == null) {
            return null;
        }
        File file = null;
        file = this.alternateDocBases == null || this.alternateDocBases.isEmpty() ? new File(this.getBasePath(this.getDocBase()), path) : ((match = AlternateDocBase.findMatch((String)path, this.alternateDocBases)) != null ? new File(match.getBasePath(), path) : new File(this.getBasePath(this.getDocBase()), path));
        if (!file.exists()) {
            try {
                File f = this.getExtractedMetaInfResourcePath(path);
                if (f != null && f.exists()) {
                    file = f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!file.exists()) {
            return null;
        }
        return file.getAbsolutePath();
    }

    @Override
    public void log(String message) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + " ServletContext.log():" + message, 3);
        }
    }

    @Override
    public void log(Exception exception, String message) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(exception, this.logName() + message);
        }
    }

    @Override
    public void log(String message, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + message, throwable);
        }
    }

    @Override
    @Deprecated
    public Servlet getServlet(String name) {
        return this.context.getServlet(name);
    }

    @Override
    @Deprecated
    public Enumeration<String> getServletNames() {
        return this.context.getServletNames();
    }

    @Override
    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return this.context.getServlets();
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        AlternateDocBase match;
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        DirContext resources = null;
        resources = this.alternateDocBases == null || this.alternateDocBases.isEmpty() ? this.getResources() : ((match = AlternateDocBase.findMatch((String)path, this.alternateDocBases)) != null ? ContextsAdapterUtility.unwrap(match.getResources()) : this.getResources());
        if (resources != null) {
            try {
                Object resource = resources.lookup(path);
                if (resource instanceof Resource) {
                    return ((Resource)resource).streamContent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        AlternateDocBase match;
        if (path == null || !path.startsWith("/")) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00183"), path);
            throw new MalformedURLException(msg);
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        String libPath = "/WEB-INF/lib/";
        if (path.startsWith(libPath) && path.endsWith(".jar")) {
            File jarFile = null;
            jarFile = this.isFilesystemBased() ? new File(this.getBasePath(this.docBase), path) : new File(this.getWorkPath(), path);
            if (jarFile.exists()) {
                return jarFile.toURL();
            }
            return null;
        }
        DirContext resources = null;
        resources = this.alternateDocBases == null || this.alternateDocBases.isEmpty() ? this.context.getResources() : ((match = AlternateDocBase.findMatch((String)path, this.alternateDocBases)) != null ? ContextsAdapterUtility.unwrap(match.getResources()) : this.getResources());
        if (resources != null) {
            String fullPath = this.getName() + path;
            String hostName = this.getParent().getName();
            try {
                resources.lookup(path);
                return new URL("jndi", "", 0, StandardContext.getJNDIUri(hostName, fullPath), (URLStreamHandler)new DirContextURLStreamHandler(resources));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        AlternateDocBase match;
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00183"), path);
            throw new IllegalArgumentException(msg);
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        DirContext resources = null;
        resources = this.alternateDocBases == null || this.alternateDocBases.isEmpty() ? this.getResources() : ((match = AlternateDocBase.findMatch((String)path, this.alternateDocBases)) != null ? ContextsAdapterUtility.unwrap(match.getResources()) : this.getResources());
        if (resources != null) {
            return this.getResourcePathsInternal(resources, path);
        }
        return null;
    }

    private Set<String> getResourcePathsInternal(DirContext resources, String path) {
        HashSet<String> set = new HashSet<String>();
        try {
            StandardContext.listCollectionPaths(set, resources, path);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        try {
            File file = this.getExtractedMetaInfResourcePath(path);
            if (file != null) {
                File[] children = file.listFiles();
                StringBuilder sb = null;
                for (File child : children) {
                    sb = new StringBuilder(path);
                    if (!path.endsWith("/")) {
                        sb.append("/");
                    }
                    sb.append(child.getName());
                    if (child.isDirectory()) {
                        sb.append("/");
                    }
                    set.add(sb.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/") && !path.isEmpty()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00184"), path);
            throw new IllegalArgumentException(msg);
        }
        String queryString = null;
        int pos = path.indexOf(63);
        if (pos >= 0) {
            queryString = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        pos = path.length();
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        }
        MessageBytes uriMB = dd.uriMB;
        uriMB.recycle();
        MappingData mappingData = dd.mappingData;
        CharChunk uriCC = uriMB.getCharChunk();
        try {
            uriCC.append(this.getPath(), 0, this.getPath().length());
            int semicolon = path.indexOf(59);
            if (pos >= 0 && semicolon > pos) {
                semicolon = -1;
            }
            uriCC.append(path, 0, semicolon > 0 ? semicolon : pos);
            this.getMapper().map(uriMB, mappingData);
            if (mappingData.wrapper == null) {
                return null;
            }
            if (semicolon > 0) {
                uriCC.append(path, semicolon, pos - semicolon);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "AS-WEB-CORE-00185", e);
            return null;
        }
        Wrapper wrapper = (Wrapper)mappingData.wrapper;
        String wrapperPath = mappingData.wrapperPath.toString();
        String pathInfo = mappingData.pathInfo.toString();
        MappingImpl mappingForDispatch = new MappingImpl(mappingData);
        mappingData.recycle();
        return new ApplicationDispatcher(wrapper, mappingForDispatch, uriCC.toString(), wrapperPath, pathInfo, queryString, null);
    }

    public DirContext getStaticResources() {
        return this.getResources();
    }

    public DirContext findStaticResources() {
        return this.getResources();
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    @Override
    public void setXmlValidation(boolean webXmlValidation) {
        this.webXmlValidation = webXmlValidation;
    }

    @Override
    public boolean getXmlValidation() {
        return this.webXmlValidation;
    }

    @Override
    public boolean getXmlNamespaceAware() {
        return this.webXmlNamespaceAware;
    }

    @Override
    public void setXmlNamespaceAware(boolean webXmlNamespaceAware) {
        this.webXmlNamespaceAware = webXmlNamespaceAware;
    }

    @Override
    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    @Override
    public boolean getTldValidation() {
        return this.tldValidation;
    }

    @Override
    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    @Override
    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public void setOrderedLibs(List<String> orderedLibs) {
        this.orderedLibs = orderedLibs;
    }

    public void startRecursive() throws LifecycleException {
        this.start();
    }

    public int getState() {
        if (this.started) {
            return 1;
        }
        if (this.initialized) {
            return 0;
        }
        if (!this.available) {
            return 4;
        }
        return 3;
    }

    boolean isContextInitializedCalled() {
        return this.isContextInitializedCalled;
    }

    public ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        ClassLoader classLoader;
        ObjectInputStream ois = null;
        Loader loader = this.getLoader();
        if (loader != null && (classLoader = loader.getClassLoader()) != null) {
            try {
                ois = new CustomObjectInputStream(is, classLoader);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00186", ioe);
            }
        }
        if (ois == null) {
            ois = new ObjectInputStream(is);
        }
        return ois;
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public void sessionCreatedEvent(HttpSession session) {
    }

    public void sessionDestroyedEvent(HttpSession session) {
    }

    public void sessionRejectedEvent(int maxSessions) {
    }

    public void sessionExpiredEvent(HttpSession session) {
    }

    public void sessionPersistedStartEvent(HttpSession session) {
    }

    public void sessionPersistedEndEvent(HttpSession session) {
    }

    public void sessionActivatedStartEvent(HttpSession session) {
    }

    public void sessionActivatedEndEvent(HttpSession session) {
    }

    public void sessionPassivatedStartEvent(HttpSession session) {
    }

    public void sessionPassivatedEndEvent(HttpSession session) {
    }

    public long getUniqueId() {
        return 0L;
    }

    protected <T extends Servlet> T createServletInstance(Class<T> clazz) throws Exception {
        return (T)((Servlet)clazz.newInstance());
    }

    protected <T extends Filter> T createFilterInstance(Class<T> clazz) throws Exception {
        return (T)((Filter)clazz.newInstance());
    }

    public <T extends EventListener> T createListenerInstance(Class<T> clazz) throws Exception {
        return (T)((EventListener)clazz.newInstance());
    }

    public <T extends HttpUpgradeHandler> T createHttpUpgradeHandlerInstance(Class<T> clazz) throws Exception {
        return (T)((HttpUpgradeHandler)clazz.newInstance());
    }

    private static void listCollectionPaths(Set<String> set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            StringBuilder childPath = new StringBuilder(path);
            if (!"/".equals(path) && !path.endsWith("/")) {
                childPath.append("/");
            }
            childPath.append(name);
            Object object = binding.getObject();
            if (object instanceof DirContext && childPath.charAt(childPath.length() - 1) != '/') {
                childPath.append("/");
            }
            set.add(childPath.toString());
        }
    }

    private static String getJNDIUri(String hostName, String path) {
        if (!path.startsWith("/")) {
            return "/" + hostName + "/" + path;
        }
        return "/" + hostName + path;
    }

    private File getExtractedMetaInfResourcePath(String path) {
        path = "META-INF/resources" + path;
        ClassLoader cl = this.getLoader().getClassLoader();
        if (cl instanceof WebappClassLoader) {
            return ((WebappClassLoader)cl).getExtractedResourcePath(path);
        }
        return null;
    }

    static {
        GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        instanceIDCounter = new AtomicInteger(1);
    }

    private static final class DispatchData {
        public MessageBytes uriMB = MessageBytes.newInstance();
        public MappingData mappingData;

        public DispatchData() {
            CharChunk uriCC = this.uriMB.getCharChunk();
            uriCC.setLimit(-1);
            this.mappingData = new MappingData();
        }
    }

    private static class PrivilegedCreateSecurityManager
    implements PrivilegedAction<MySecurityManager> {
        private PrivilegedCreateSecurityManager() {
        }

        @Override
        public MySecurityManager run() {
            return new MySecurityManager();
        }
    }

    private static class MySecurityManager
    extends SecurityManager {
        private MySecurityManager() {
        }

        boolean isAncestor(ClassLoader start, ClassLoader cl) {
            ClassLoader acl = start;
            do {
                if (cl != (acl = acl.getParent())) continue;
                return true;
            } while (acl != null);
            return false;
        }

        void checkGetClassLoaderPermission(ClassLoader webappLoader) {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                return;
            }
            Class<?>[] classContext = this.getClassContext();
            ClassLoader ccl = classContext[5].getClassLoader();
            if (ccl != null && ccl != webappLoader && !this.isAncestor(webappLoader, ccl)) {
                sm.checkPermission(GET_CLASSLOADER_PERMISSION);
            }
        }
    }

    public static class RestrictedServletContextListener
    implements ServletContextListener {
        private final ServletContextListener delegate;

        public RestrictedServletContextListener(ServletContextListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void contextInitialized(ServletContextEvent sce) {
            this.delegate.contextInitialized(sce);
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            this.delegate.contextDestroyed(sce);
        }

        public ServletContextListener getNestedListener() {
            return this.delegate;
        }
    }
}

