/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.web.util.HtmlEntityEncoder;

public class ErrorReportValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.ErrorReportValve/1.0";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    private final int debug = 0;

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        return 1;
    }

    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        ServletRequest sreq = (ServletRequest)((Object)request);
        Throwable throwable = (Throwable)sreq.getAttribute("javax.servlet.error.exception");
        ServletResponse sresp = (ServletResponse)((Object)response);
        if (sresp.isCommitted()) {
            return;
        }
        if (throwable != null) {
            response.setError();
            String responseCharEnc = sresp.getCharacterEncoding();
            HttpServletResponse sresponse = (HttpServletResponse)((Object)response);
            Collection<String> cookieHeaders = sresponse.getHeaders("Set-Cookie");
            try {
                sresp.reset();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (responseCharEnc != null && !responseCharEnc.equals(Constants.DEFAULT_HTTP_CHARACTER_ENCODING)) {
                sresp.setCharacterEncoding(responseCharEnc);
            }
            for (String cookieHeader : cookieHeaders) {
                sresponse.addHeader("Set-Cookie", cookieHeader);
            }
            sresponse.sendError(500);
        }
        response.setSuspended(false);
        sresp.setContentType("text/html");
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ErrorReportValve[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void report(Request request, Response response, Throwable throwable) throws IOException {
        String message;
        HttpResponse hresponse = (HttpResponse)response;
        HttpServletResponse hres = (HttpServletResponse)((Object)response);
        int statusCode = hresponse.getStatus();
        if (statusCode < 400 || response.getContentCount() > 0) {
            return;
        }
        Throwable rootCause = null;
        if (throwable != null && throwable instanceof ServletException) {
            rootCause = ((ServletException)throwable).getRootCause();
        }
        if ((message = hresponse.getMessage()) == null) {
            message = hresponse.getDetailMessage();
        }
        message = message == null ? "" : HtmlEntityEncoder.encodeXSS((String)message);
        String report = null;
        try {
            report = sm.getString("http." + statusCode, hres.getLocale());
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (report == null) {
            return;
        }
        String errorPage = ErrorReportValve.makeErrorPage(statusCode, message, throwable, rootCause, report, hres);
        hres.setLocale(sm.getResourceBundleLocale(hres.getLocale()));
        try {
            hres.setContentType("text/html");
        }
        catch (Throwable throwable3) {
            // empty catch block
        }
        try {
            PrintWriter writer = response.getReporter();
            if (writer != null) {
                ((Writer)writer).write(errorPage);
            }
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            log.log(Level.INFO, "{0}: {1}", new Object[]{this.toString(), message});
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.toString() + ": " + message, t);
        }
    }

    public static String makeErrorPage(int statusCode, String message, Throwable throwable, Throwable rootCause, String report, HttpServletResponse response) {
        Locale responseLocale = response.getLocale();
        String serverInfo = ServerInfo.getPublicServerInfo();
        StringBuilder sb = new StringBuilder();
        MessageFormat mf = new MessageFormat("");
        mf.setLocale(responseLocale);
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
        sb.append(" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title>");
        if (serverInfo != null && !serverInfo.isEmpty()) {
            sb.append(serverInfo).append(" - ");
        }
        sb.append(sm.getString("errorReportValve.errorReport", responseLocale));
        sb.append("</title>");
        sb.append("<style type=\"text/css\"><!--");
        sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}");
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("<h1>");
        sb.append(sm.getString("errorReportValve.statusHeader", (Object)String.valueOf(statusCode), (Object)message, responseLocale)).append("</h1>");
        sb.append("<hr/>");
        sb.append("<p><b>type</b> ");
        if (throwable != null) {
            sb.append(sm.getString("errorReportValve.exceptionReport", responseLocale));
        } else {
            sb.append(sm.getString("errorReportValve.statusReport", responseLocale));
        }
        sb.append("</p>");
        sb.append("<p><b>");
        sb.append(sm.getString("errorReportValve.message", responseLocale));
        sb.append("</b>");
        sb.append(message).append("</p>");
        sb.append("<p><b>");
        sb.append(sm.getString("errorReportValve.description", responseLocale));
        sb.append("</b>");
        sb.append(report);
        sb.append("</p>");
        if (throwable != null && serverInfo != null && !serverInfo.isEmpty()) {
            sb.append("<p><b>");
            sb.append(sm.getString("errorReportValve.exception", responseLocale));
            sb.append("</b> <pre>");
            sb.append(HtmlEntityEncoder.encodeXSS((String)String.valueOf(throwable)));
            sb.append("</pre></p>");
            while (rootCause != null) {
                sb.append("<p><b>");
                sb.append(sm.getString("errorReportValve.rootCause", responseLocale));
                sb.append("</b> <pre>");
                sb.append(HtmlEntityEncoder.encodeXSS((String)String.valueOf(rootCause)));
                sb.append("</pre></p>");
                rootCause = rootCause.getCause();
            }
            sb.append("<p><b>");
            sb.append(sm.getString("errorReportValve.note", responseLocale));
            sb.append("</b> <u>");
            sb.append(sm.getString("errorReportValve.rootCauseInLogs", (Object)serverInfo, responseLocale));
            sb.append("</u></p>");
        }
        sb.append("<hr/>");
        if (serverInfo != null && !serverInfo.isEmpty()) {
            sb.append("<h3>").append(serverInfo).append("</h3>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }
}

