/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.logging.Level;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.glassfish.web.util.IntrospectionUtils;

public class SetRootRule
extends Rule {
    protected String methodName = null;
    protected String paramType = null;
    protected boolean useExactMatch = false;

    public SetRootRule(Digester digester, String methodName) {
        this(methodName);
    }

    public SetRootRule(Digester digester, String methodName, String paramType) {
        this(methodName, paramType);
    }

    public SetRootRule(String methodName) {
        this(methodName, null);
    }

    public SetRootRule(String methodName, String paramType) {
        this.methodName = methodName;
        this.paramType = paramType;
    }

    public boolean isExactMatch() {
        return this.useExactMatch;
    }

    public void setExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    @Override
    public void end() throws Exception {
        Object child = this.digester.peek(0);
        Object parent = this.digester.root;
        if (this.digester.log.isLoggable(Level.FINE)) {
            if (parent == null) {
                this.digester.log.log(Level.FINE, "[SetRootRule]'{'{0}'}' Call [NULL ROOT].{1}({2})", new Object[]{this.digester.match, this.methodName, child});
            } else {
                this.digester.log.log(Level.FINE, "[SetRootRule]'{'{0}'}' Call {1}.{2}({3})", new Object[]{this.digester.match, parent.getClass().getName(), this.methodName, child});
            }
        }
        IntrospectionUtils.callMethod1((Object)parent, (String)this.methodName, (Object)child, (String)this.paramType, (ClassLoader)this.digester.getClassLoader());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetRootRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramType=");
        sb.append(this.paramType);
        sb.append("]");
        return sb.toString();
    }
}

