/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherConstants;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class GFLauncherNativeHelper {
    private final GFLauncherInfo info;
    private final JvmOptions jvmOptions;
    private final Profiler profiler;
    private final File installDir;
    private final File libDir;
    private final JavaConfig javaConfig;

    GFLauncherNativeHelper(GFLauncherInfo info, JavaConfig javaConfig, JvmOptions jvmOptions, Profiler profiler) {
        this.info = info;
        this.javaConfig = javaConfig;
        this.jvmOptions = jvmOptions;
        this.profiler = profiler;
        if (info == null || jvmOptions == null || profiler == null) {
            throw new NullPointerException("Null argument(s) to GFLauncherNativeHelper.GFLauncherNativeHelper");
        }
        this.installDir = SmartFile.sanitize(info.getInstallDir());
        this.libDir = new File(this.installDir, "lib");
    }

    List<String> getCommands() {
        ArrayList<String> list = new ArrayList<String>();
        String stockNativePathsString = this.getStockNativePathString();
        String prefixFileString = this.getPrefixString();
        String suffixFileString = this.getSuffixString();
        String profilerFileString = this.getProfilerString();
        String libFileString = this.libDir.getPath();
        String lib64FileString = this.getLib64String();
        StringBuilder sb = new StringBuilder();
        sb.append(prefixFileString).append(GFLauncherConstants.PS);
        sb.append(libFileString).append(GFLauncherConstants.PS);
        sb.append(lib64FileString).append(GFLauncherConstants.PS);
        sb.append(stockNativePathsString).append(GFLauncherConstants.PS);
        sb.append(profilerFileString).append(GFLauncherConstants.PS);
        sb.append(suffixFileString);
        String finalPathString = GFLauncherUtils.fileListToPathString(GFLauncherUtils.stringToFiles(sb.toString()));
        String nativeCommand = "-Djava.library.path=" + finalPathString;
        list.add(nativeCommand);
        return list;
    }

    private String getStockNativePathString() {
        String s = System.getProperty("java.library.path");
        if (!GFLauncherUtils.ok(s)) {
            s = "";
        }
        return s;
    }

    private String getPrefixString() {
        return this.javaConfig.getNativeLibraryPrefix();
    }

    private String getSuffixString() {
        return this.javaConfig.getNativeLibrarySuffix();
    }

    private String getProfilerString() {
        if (!this.profiler.isEnabled()) {
            return "";
        }
        List<File> ff = this.profiler.getNativePath();
        return GFLauncherUtils.fileListToPathString(ff);
    }

    private String getLib64String() {
        String osArch = System.getProperty("os.arch");
        File f64 = null;
        if (osArch.equals("sparc")) {
            f64 = new File(this.libDir, "sparcv9");
        } else if (osArch.equals("x86")) {
            f64 = new File(this.libDir, "amd64");
        }
        if (f64 != null && f64.isDirectory()) {
            return f64.getPath();
        }
        return "";
    }
}

