/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.glassfish.admin.rest.model.Message;
import org.glassfish.admin.rest.model.ResourceLink;

public class ResponseBody {
    public static final String EVENT_NAME = "response/body";
    private List<Message> messages = new ArrayList<Message>();
    private boolean includeResourceLinks = true;
    private List<ResourceLink> links = new ArrayList<ResourceLink>();

    public ResponseBody() {
    }

    public ResponseBody(boolean includeResourceLinks) {
        this.setIncludeResourceLinks(includeResourceLinks);
    }

    public ResponseBody(URI parentUri) {
        this.addParentResourceLink(parentUri);
    }

    public ResponseBody(boolean includeResourceLinks, URI parentUri) {
        this.setIncludeResourceLinks(includeResourceLinks);
        this.addParentResourceLink(parentUri);
    }

    public void setIncludeResourceLinks(boolean includeResourceLinks) {
        this.includeResourceLinks = includeResourceLinks;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> val) {
        this.messages = val;
    }

    public ResponseBody addSuccess(String message) {
        return this.addMessage(Message.Severity.SUCCESS, message);
    }

    public ResponseBody addWarning(String message) {
        return this.addMessage(Message.Severity.WARNING, message);
    }

    public ResponseBody addFailure(Throwable t) {
        while (t != null) {
            this.addFailure(t.getLocalizedMessage());
            t = t.getCause();
        }
        return this;
    }

    public ResponseBody addFailure(String message) {
        return this.addMessage(Message.Severity.FAILURE, message);
    }

    public ResponseBody addFailure(String field, String message) {
        return this.addMessage(Message.Severity.FAILURE, field, message);
    }

    public ResponseBody addMessage(Message.Severity severity, String field, String message) {
        return this.add(new Message(severity, field, message));
    }

    public ResponseBody addMessage(Message.Severity severity, String message) {
        return this.add(new Message(severity, message));
    }

    public ResponseBody add(Message message) {
        this.getMessages().add(message);
        return this;
    }

    public List<ResourceLink> getResourceLinks() {
        return this.links;
    }

    public void setResourceLinks(List<ResourceLink> val) {
        this.links = val;
    }

    public ResponseBody addParentResourceLink(URI uri) {
        if (uri == null) {
            return this;
        }
        return this.addResourceLink("parent", uri);
    }

    public void addActionResourceLink(String action, URI uri) {
        this.addResourceLink("action", action, uri);
    }

    public ResponseBody addResourceLink(String rel, URI uri) {
        return this.add(new ResourceLink(rel, uri));
    }

    public ResponseBody addResourceLink(String rel, String title, URI uri) {
        return this.add(new ResourceLink(rel, title, uri));
    }

    public ResponseBody add(ResourceLink link) {
        this.getResourceLinks().add(link);
        return this;
    }

    public JsonObject toJson() throws JsonException {
        JsonObject jsonobject = JsonObject.EMPTY_JSON_OBJECT;
        this.populateJson(jsonobject);
        return jsonobject;
    }

    protected void populateJson(JsonObject object) throws JsonException {
        JsonArrayBuilder array;
        if (!this.getMessages().isEmpty()) {
            array = Json.createArrayBuilder();
            for (Message message : this.getMessages()) {
                array.add((JsonValue)message.toJson());
            }
            object.put((Object)"messages", (Object)array.build());
        }
        if (this.includeResourceLinks && !this.getResourceLinks().isEmpty()) {
            array = Json.createArrayBuilder();
            for (ResourceLink link : this.getResourceLinks()) {
                array.add((JsonValue)link.toJson());
            }
            object.put((Object)"resources", (Object)array.build());
        }
    }
}

