/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.Produces;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Constants;
import org.glassfish.admin.rest.composite.RestCollection;
import org.glassfish.admin.rest.composite.metadata.RestModelMetadata;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.JsonUtil;

@Provider
@Produces(value={"application/vnd.oracle.glassfish+json"})
public class RestCollectionProvider
extends BaseProvider<RestCollection> {
    public RestCollectionProvider() {
        super(RestCollection.class, Constants.MEDIA_TYPE_JSON_TYPE);
    }

    @Override
    public String getContent(RestCollection proxy) {
        StringBuilder sb = new StringBuilder();
        List<String> wrapObjectHeader = ((HttpHeaders)this.requestHeaders.get()).getRequestHeader("X-Wrap-Object");
        List<String> skipMetadataHeader = ((HttpHeaders)this.requestHeaders.get()).getRequestHeader("X-Skip-Metadata");
        boolean wrapObject = wrapObjectHeader != null && !wrapObjectHeader.isEmpty();
        boolean skipMetadata = skipMetadataHeader != null && skipMetadataHeader.get(0).equalsIgnoreCase("true");
        JsonArrayBuilder models = Json.createArrayBuilder();
        JsonArrayBuilder metadata = Json.createArrayBuilder();
        for (Map.Entry entry : proxy.entrySet()) {
            try {
                models.add(JsonUtil.getJsonValue(entry.getValue()));
                RestModelMetadata md = entry.getKey();
                JsonObjectBuilder mdo = Json.createObjectBuilder();
                mdo.add("id", md.getId());
                metadata.add((JsonValue)mdo.build());
            }
            catch (JsonException e) {
                Logger.getLogger(RestCollectionProvider.class.getName()).log(Level.SEVERE, "Unable to parse create Json", e);
            }
        }
        JsonObjectBuilder response = Json.createObjectBuilder();
        try {
            response.add("items", (JsonValue)models.build());
            if (!skipMetadata) {
                response.add("metadata", (JsonValue)metadata.build());
            }
            sb.append(response.toString());
        }
        catch (JsonException e) {
            Logger.getLogger(RestCollectionProvider.class.getName()).log(Level.SEVERE, "Unable to parse create Json", e);
        }
        return (wrapObject ? " { items : " : "") + sb.toString() + (wrapObject ? "}" : "");
    }
}

