/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Consumes(value={"application/json"})
@Provider
public class JsonHashMapProvider
implements MessageBodyReader<HashMap<String, String>> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(HashMap.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap<String, String> readFrom(Class<HashMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (JsonParser parser = Json.createParser((InputStream)in);){
            JsonObject obj;
            if (parser.hasNext()) {
                parser.next();
                obj = parser.getObject();
            } else {
                obj = JsonValue.EMPTY_JSON_OBJECT;
            }
            for (Map.Entry entry : obj.entrySet()) {
                JsonValue value = (JsonValue)entry.getValue();
                if (value.getValueType() == JsonValue.ValueType.STRING) {
                    map.put((String)entry.getKey(), ((JsonString)value).getString());
                    continue;
                }
                map.put((String)entry.getKey(), value.toString());
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (JsonException ex) {
            Logger.getLogger("org.glassfish.admin.rest.readers").log(Level.FINER, null, ex);
            return map;
        }
    }

    public static String inputStreamAsString(InputStream stream) throws IOException {
        StringBuilder sb;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }
}

