/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.json.JsonException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.resources.CommandResult;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Produces(value={"text/html", "application/json", "application/xml"})
public class TemplateCommandPostResource
extends TemplateExecCommand {
    public TemplateCommandPostResource(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        super(resourceName, commandName, commandMethod, commandAction, commandDisplayName, isLinkedToParent);
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response processPostLegacyFormat(ParameterMap data) {
        if (data == null) {
            data = new ParameterMap();
        }
        if (data.containsKey((Object)"error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        return super.executeCommandLegacyFormat(this.preprocessData(data));
    }

    @POST
    @Consumes(value={"application/vnd.oracle.glassfish+json"})
    @Produces(value={"application/vnd.oracle.glassfish+json"})
    public CommandResult processPost(ParameterMap data) {
        if (data == null) {
            data = new ParameterMap();
        }
        if (data.containsKey((Object)"error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        return super.executeCommand(this.preprocessData(data));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        return this.processPostLegacyFormat(TemplateCommandPostResource.createDataBasedOnForm(formData));
    }

    @POST
    public Response processPost() {
        try {
            return this.processPostLegacyFormat(new ParameterMap());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/event-stream"})
    public Response processSsePost(ParameterMap data) {
        if (data == null) {
            data = new ParameterMap();
        }
        if (data.containsKey((Object)"error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        return super.executeCommandAsSse(this.preprocessData(data));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/event-stream"})
    public Response ssePost(FormDataMultiPart formData) {
        return this.processSsePost(TemplateCommandPostResource.createDataBasedOnForm(formData));
    }

    @POST
    @Produces(value={"text/event-stream"})
    public Response processSsePost() {
        try {
            return this.processSsePost(new ParameterMap());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    public ActionReportResult getLegacyFormat() {
        return this.optionsLegacyFormat();
    }

    @GET
    @Produces(value={"application/vnd.oracle.glassfish+json"})
    public String get() {
        try {
            return this.options();
        }
        catch (JsonException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private ParameterMap preprocessData(ParameterMap data) {
        this.processCommandParams(data);
        this.adjustParameters(data);
        this.purgeEmptyEntries(data);
        return data;
    }

    private static ParameterMap createDataBasedOnForm(FormDataMultiPart paramForm) {
        ParameterMap data = new ParameterMap();
        try (FormDataMultiPart formData = TemplateCommandPostResource.assureExistence(paramForm);){
            Map m1 = formData.getFields();
            Set ss = m1.keySet();
            for (String fieldName : ss) {
                for (FormDataBodyPart bodyPart : formData.getFields(fieldName)) {
                    if (bodyPart.getContentDisposition().getFileName() != null) {
                        InputStream fileStream = (InputStream)bodyPart.getValueAs(InputStream.class);
                        String mimeType = bodyPart.getMediaType().toString();
                        String fileName = bodyPart.getContentDisposition().getFileName();
                        if (fileName.contains("/")) {
                            fileName = Util.getName(fileName, '/');
                        } else if (fileName.contains("\\")) {
                            fileName = Util.getName(fileName, '\\');
                        }
                        File f = Util.saveFile(fileName, mimeType, fileStream);
                        FileUtils.deleteOnExit((File)f);
                        data.add((Object)fieldName, (Object)f.getAbsolutePath());
                        continue;
                    }
                    data.add((Object)fieldName, (Object)bodyPart.getValue());
                }
            }
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return data;
    }

    private static FormDataMultiPart assureExistence(FormDataMultiPart formData) {
        if (formData == null) {
            return new FormDataMultiPart();
        }
        return formData;
    }
}

