/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.composite;

import com.sun.enterprise.admin.report.ActionReporter;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.glassfish.admin.rest.composite.CompositeResource;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.model.RestCollectionResponseBody;
import org.glassfish.admin.rest.resources.composite.Job;
import org.glassfish.admin.rest.resources.composite.JobResource;
import org.glassfish.admin.rest.utils.StringUtil;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.annotations.Service;

@Service
@Path(value="/jobs")
public class JobsResource
extends CompositeResource {
    @GET
    public RestCollectionResponseBody<Job> getItems(@QueryParam(value="currentUser") @DefaultValue(value="false") boolean currentUser, @QueryParam(value="__includeFields") String include, @QueryParam(value="__excludeFields") String exclude) throws Exception {
        RestCollectionResponseBody<Job> rb = this.restCollectionResponseBody(Job.class, "job", null);
        ActionReporter ar = this.executeReadCommand(this.getCommandName(), this.getParameters());
        List jobMaps = (List)ar.getExtraProperties().get("jobs");
        if (jobMaps != null) {
            for (Map jobMap : jobMaps) {
                if (currentUser && !StringUtil.compareStrings((String)jobMap.get("user"), this.getAuthenticatedUser()) || jobMap == null) continue;
                Job model = JobsResource.constructJobModel(jobMap);
                rb.addItem(this.filterModel(Job.class, model, include, exclude, "jobId"), model.getJobId());
            }
        }
        return rb;
    }

    @Path(value="id/{jobId}")
    public JobResource getJobResource() {
        return this.getSubResource(JobResource.class);
    }

    protected String getCommandName() {
        return "list-jobs";
    }

    protected ParameterMap getParameters() {
        return new ParameterMap();
    }

    static Job constructJobModel(Map<String, Object> jobMap) {
        Job model = CompositeUtil.instance().getModel(Job.class);
        model.setJobId((String)jobMap.get("jobId"));
        model.setJobName((String)jobMap.get("jobName"));
        model.setExecutionDate(jobMap.get("executionDate").toString());
        model.setCompletionDate(jobMap.get("completionDate").toString());
        model.setJobState(jobMap.get("jobState").toString());
        model.setExitCode((String)jobMap.get("exitCode"));
        model.setMessage((String)jobMap.get("message"));
        model.setUser((String)jobMap.get("user"));
        return model;
    }
}

