/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ProxyImpl;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

@Produces(value={"text/html", "application/json", "application/xml"})
@Path(value="domain/proxy/{path:.*}")
public class ManagementProxyResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ServiceLocator habitat;

    @GET
    public ActionReportResult proxyRequest() {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Proxied Data");
        ar.setSuccess();
        ActionReportResult result = new ActionReportResult(ar);
        Properties proxiedResponse = new ManagementProxyImpl().proxyRequest(this.uriInfo, Util.getJerseyClient(), this.habitat);
        ar.setExtraProperties(proxiedResponse);
        return result;
    }

    public void setEntity(Dom p) {
    }

    private static class ManagementProxyImpl
    extends ProxyImpl {
        private static final int TARGET_INSTANCE_NAME_PATH_INDEX = 2;

        private ManagementProxyImpl() {
        }

        @Override
        public UriBuilder constructTargetURLPath(UriInfo sourceUriInfo, URL responseURLReceivedFromTarget) {
            return sourceUriInfo.getBaseUriBuilder().replacePath(responseURLReceivedFromTarget.getFile());
        }

        @Override
        public UriBuilder constructForwardURLPath(UriInfo sourceUriInfo) {
            List<PathSegment> sourcePathSegments = sourceUriInfo.getPathSegments();
            List<PathSegment> forwardPathSegmentsHead = sourcePathSegments.subList(0, 1);
            List<PathSegment> forwardPathSegmentsTail = sourcePathSegments.subList(3, sourcePathSegments.size());
            UriBuilder forwardUriBuilder = sourceUriInfo.getBaseUriBuilder();
            for (PathSegment pathSegment : forwardPathSegmentsHead) {
                forwardUriBuilder.segment(pathSegment.getPath());
            }
            for (PathSegment pathSegment : forwardPathSegmentsTail) {
                forwardUriBuilder.segment(pathSegment.getPath());
            }
            return forwardUriBuilder;
        }

        @Override
        public String extractTargetInstanceName(UriInfo uriInfo) {
            return uriInfo.getPathSegments().get(2).getPath();
        }
    }
}

