/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.admin.report.ActionReporter;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

@Produces(value={"text/html", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
public class SystemPropertiesCliResource
extends TemplateExecCommand {
    protected static final String TAG_SYSTEM_PROPERTY = "system-property";
    private static final String VALUE = "value";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String DESCRIPTION = "description";
    @Context
    protected ServiceLocator injector;
    protected Dom entity;
    protected Domain domain;

    public SystemPropertiesCliResource() {
        super(SystemPropertiesCliResource.class.getSimpleName(), "", "", "", "", true);
    }

    public void setEntity(Dom p) {
        this.entity = p;
    }

    public Dom getEntity() {
        return this.entity;
    }

    @GET
    public ActionReportResult get() {
        this.domain = (Domain)this.locatorBridge.getRemoteLocator().getService(Domain.class, new Annotation[0]);
        ParameterMap data = new ParameterMap();
        this.processCommandParams(data);
        this.addQueryString(this.uriInfo.getQueryParameters(), data);
        this.adjustParameters(data);
        TreeMap<String, Map<String, String>> properties = new TreeMap<String, Map<String, String>>();
        RestActionReporter actionReport = new RestActionReporter();
        this.getSystemProperties(properties, this.getEntity(), false);
        actionReport.getExtraProperties().put("systemProperties", new ArrayList(properties.values()));
        if (properties.isEmpty()) {
            actionReport.getTopMessagePart().setMessage("Nothing to list.");
        }
        return new ActionReportResult(this.commandName, actionReport, new OptionsResult());
    }

    @POST
    public Response create(Map<String, String> data) {
        return this.saveProperties(data);
    }

    @PUT
    public Response update(Map<String, String> data) {
        data.entrySet().removeIf(entry -> entry.getValue() == null || ((String)entry.getValue()).isEmpty());
        Response resp = this.deleteRemovedProperties(data.keySet());
        return resp == null ? this.saveProperties(data) : resp;
    }

    @Path(value="{Name}/")
    @POST
    public Response getSystemPropertyResource(@PathParam(value="Name") String id, Map<String, String> data) {
        data.put(id, data.get(VALUE));
        data.remove(VALUE);
        List<PathSegment> segments = this.uriInfo.getPathSegments(true);
        String grandParent = segments.get(segments.size() - 3).getPath();
        return this.saveProperties(grandParent, data);
    }

    @Path(value="{Name}/")
    @DELETE
    public Response deleteSystemProperty(@PathParam(value="Name") String id, HashMap<String, String> data) {
        List<PathSegment> segments = this.uriInfo.getPathSegments(true);
        String grandParent = segments.get(segments.size() - 3).getPath();
        return this.deleteProperty(grandParent, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSystemProperties(Map<String, Map<String, String>> properties, Dom dom, boolean getDefaults) {
        List sysprops;
        Dom dom2 = dom;
        synchronized (dom2) {
            sysprops = dom.nodeElements(TAG_SYSTEM_PROPERTY);
        }
        if (sysprops != null && !sysprops.isEmpty()) {
            for (Dom sysprop : sysprops) {
                String name = sysprop.attribute("name");
                Map<String, String> currValue = properties.get(name);
                if (currValue == null) {
                    currValue = new HashMap<String, String>();
                    currValue.put("name", name);
                    currValue.put(getDefaults ? DEFAULT_VALUE : VALUE, sysprop.attribute(VALUE));
                    if (sysprop.attribute(DESCRIPTION) != null) {
                        currValue.put(DESCRIPTION, sysprop.attribute(DESCRIPTION));
                    }
                    properties.put(name, currValue);
                    continue;
                }
                if (currValue.get(DEFAULT_VALUE) != null) continue;
                currValue.put(DEFAULT_VALUE, sysprop.attribute(VALUE));
            }
        }
        if (dom.getProxyType().equals(Server.class)) {
            if (((Server)dom.createProxy()).getCluster() != null) {
                this.getSystemProperties(properties, this.getCluster(dom.parent().parent(), ((Server)dom.createProxy()).getCluster().getName()), true);
            } else {
                this.getSystemProperties(properties, this.getConfig(dom.parent().parent(), dom.attribute("config-ref")), true);
            }
        } else if (dom.getProxyType().equals(Cluster.class)) {
            this.getSystemProperties(properties, this.getConfig(dom.parent().parent(), dom.attribute("config-ref")), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dom getCluster(Dom domain, String clusterName) {
        List configs;
        Dom clusterElements;
        Object object = domain;
        synchronized (object) {
            clusterElements = (Dom)domain.nodeElements("clusters").get(0);
        }
        object = clusterElements;
        synchronized (object) {
            configs = clusterElements.nodeElements("cluster");
        }
        for (Dom config : configs) {
            if (!config.attribute("name").equals(clusterName)) continue;
            return config;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dom getConfig(Dom domain, String configName) {
        List configs;
        Dom rootConfig;
        Object object = domain;
        synchronized (object) {
            rootConfig = (Dom)domain.nodeElements("configs").get(0);
        }
        object = rootConfig;
        synchronized (object) {
            configs = rootConfig.nodeElements("config");
        }
        for (Dom config : configs) {
            if (!config.attribute("name").equals(configName)) continue;
            return config;
        }
        return null;
    }

    protected Response saveProperties(Map<String, String> data) {
        return this.saveProperties(null, data);
    }

    protected Response saveProperties(String parent, Map<String, String> data) {
        HashSet<String> emptyProps = new HashSet<String>();
        Iterator<Map.Entry<String, String>> dataIterator = data.entrySet().iterator();
        while (dataIterator.hasNext()) {
            Map.Entry<String, String> dataEntry = dataIterator.next();
            String value = dataEntry.getValue();
            if (value != null && !value.isEmpty()) continue;
            dataIterator.remove();
            emptyProps.add(dataEntry.getKey());
        }
        if (!emptyProps.isEmpty()) {
            Response response = this.deleteProperties(parent, emptyProps);
            if (data.isEmpty() || response.getStatus() != 200) {
                return response;
            }
        }
        return this.createProperties(null, data);
    }

    protected Response createProperties(String parent, Map<String, String> data) {
        String propertiesString = this.convertPropertyMapToString(data);
        data = new HashMap<String, String>();
        data.put("DEFAULT", propertiesString);
        data.put("target", parent == null ? this.getParent(this.uriInfo) : parent);
        RestActionReporter actionReport = ResourceUtil.runCommand("create-system-properties", data, this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        return Response.status(status).entity(results).build();
    }

    protected Response deleteProperties(String parent, Collection<String> propNames) {
        int status = 200;
        RestActionReporter report = new RestActionReporter();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage("");
        for (String propName : propNames) {
            Response response = this.deleteProperty(null, propName);
            ActionReportResult result = (ActionReportResult)response.getEntity();
            ActionReporter resultReport = result.getActionReport();
            ActionReport.ExitCode responseExitCode = resultReport.getActionExitCode();
            if (!responseExitCode.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                report.setActionExitCode(responseExitCode);
                if (responseExitCode.equals((Object)ActionReport.ExitCode.FAILURE)) {
                    status = 500;
                }
            }
            report.getExtraProperties().putAll((Map<?, ?>)resultReport.getExtraProperties());
            report.setMessage((report.getMessage() + "\n" + resultReport.getMessage()).trim());
            if (response.getStatus() == 200) continue;
            return response;
        }
        return Response.status(status).entity((Object)report).build();
    }

    protected Response deleteProperty(String parent, String propName) {
        ParameterMap pm = new ParameterMap();
        pm.add((Object)"DEFAULT", (Object)propName);
        pm.add((Object)"target", (Object)(parent == null ? this.getParent(this.uriInfo) : parent));
        RestActionReporter actionReport = ResourceUtil.runCommand("delete-system-property", pm, this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        return Response.status(status).entity(results).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response deleteRemovedProperties(Collection<String> newProps) {
        List existingProps;
        ArrayList<String> existingList = new ArrayList<String>();
        Dom parent = this.getEntity();
        Dom dom = parent;
        synchronized (dom) {
            existingProps = parent.nodeElements(TAG_SYSTEM_PROPERTY);
        }
        for (Dom existingProp : existingProps) {
            existingList.add(existingProp.attribute("name"));
        }
        if (existingList.isEmpty()) {
            return null;
        }
        for (String onePropName : existingList) {
            Response resp;
            if (newProps.contains(onePropName) || (resp = this.deleteProperty(null, onePropName)).getStatus() == 200) continue;
            return resp;
        }
        return null;
    }

    protected String convertPropertyMapToString(Map<String, String> data) {
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            options.append(sep).append(entry.getKey()).append("=").append(value.replaceAll(":", "\\\\:").replaceAll("=", "\\\\="));
            sep = ":";
        }
        return options.toString();
    }
}

