/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.DEPLOYMENT_GROUP})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-connector-resources")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.connector.resources")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-connector-resources", description="List Connector Resources")})
public class ListConnectorResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorResources.class);
    @Inject
    private Domain domain;
    @Param(primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Collection connectorResources = this.domain.getResources().getResources(ConnectorResource.class);
            for (ConnectorResource resource : connectorResources) {
                if (!this.bindableResourcesHelper.resourceExists(resource.getJndiName(), this.target)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(resource.getJndiName());
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.connector.resources.fail", "List connector resources failed") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

