/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.TypedProperties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigInstaller
implements ArtifactInstaller,
ConfigurationListener {
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;
    private final FileInstall fileInstall;
    private final Map<String, String> pidToFile = new HashMap<String, String>();
    private ServiceRegistration registration;

    ConfigInstaller(BundleContext context, ConfigurationAdmin configAdmin, FileInstall fileInstall) {
        this.context = context;
        this.configAdmin = configAdmin;
        this.fileInstall = fileInstall;
    }

    public void init() {
        this.registration = this.context.registerService(new String[]{ConfigurationListener.class.getName(), ArtifactListener.class.getName(), ArtifactInstaller.class.getName()}, (Object)this, null);
        try {
            Configuration[] configs = this.configAdmin.listConfigurations(null);
            if (configs != null) {
                for (Configuration config : configs) {
                    String fileName;
                    Dictionary dict = config.getProperties();
                    String string = fileName = dict != null ? (String)dict.get("felix.fileinstall.filename") : null;
                    if (fileName == null) continue;
                    this.pidToFile.put(config.getPid(), fileName);
                }
            }
        }
        catch (Exception e) {
            Util.log(this.context, 3, "Unable to initialize configurations list", e);
        }
    }

    public void destroy() {
        this.registration.unregister();
    }

    @Override
    public boolean canHandle(File artifact) {
        return artifact.getName().endsWith(".cfg") || artifact.getName().endsWith(".config");
    }

    @Override
    public void install(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    @Override
    public void update(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    @Override
    public void uninstall(File artifact) throws Exception {
        this.deleteConfig(artifact);
    }

    public void configurationEvent(final ConfigurationEvent configurationEvent) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ConfigInstaller.this.doConfigurationEvent(configurationEvent);
                    return null;
                }
            });
        } else {
            this.doConfigurationEvent(configurationEvent);
        }
    }

    public void doConfigurationEvent(ConfigurationEvent configurationEvent) {
        block35: {
            if (!this.shouldSaveConfig()) {
                return;
            }
            if (configurationEvent.getType() == 1) {
                try {
                    File file;
                    Configuration config = this.getConfigurationAdmin().getConfiguration(configurationEvent.getPid(), "?");
                    Dictionary dict = config.getProperties();
                    String fileName = dict != null ? (String)dict.get("felix.fileinstall.filename") : null;
                    File file2 = file = fileName != null ? this.fromConfigKey(fileName) : null;
                    if (file == null || !file.isFile() || !this.canHandle(file)) break block35;
                    this.pidToFile.put(config.getPid(), fileName);
                    TypedProperties props = new TypedProperties(this.bundleSubstitution());
                    InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), this.encoding());
                    Object object = null;
                    try {
                        props.load(r);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (r != null) {
                            if (object != null) {
                                try {
                                    ((Reader)r).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((Reader)r).close();
                            }
                        }
                    }
                    ArrayList<String> propertiesToRemove = new ArrayList<String>();
                    for (String key : props.keySet()) {
                        if (dict.get(key) != null || "service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                        propertiesToRemove.add(key);
                    }
                    Enumeration e = dict.keys();
                    while (e.hasMoreElements()) {
                        String key;
                        key = e.nextElement().toString();
                        if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                        Object val = dict.get(key);
                        props.put(key, val);
                    }
                    for (String key : propertiesToRemove) {
                        props.remove(key);
                    }
                    try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding());){
                        props.save(fw);
                    }
                    this.fileInstall.updateChecksum(file);
                }
                catch (Exception e) {
                    Util.log(this.context, 3, "Unable to save configuration", e);
                }
            }
        }
        if (configurationEvent.getType() == 2) {
            try {
                File file;
                String fileName = this.pidToFile.remove(configurationEvent.getPid());
                File file3 = file = fileName != null ? this.fromConfigKey(fileName) : null;
                if (file != null && file.isFile() && !file.delete()) {
                    throw new IOException("Unable to delete file: " + file);
                }
            }
            catch (Exception e) {
                Util.log(this.context, 3, "Unable to delete configuration file", e);
            }
        }
    }

    boolean shouldSaveConfig() {
        String str = this.context.getProperty("felix.fileinstall.enableConfigSave");
        if (str == null) {
            str = this.context.getProperty("felix.fileinstall.disableConfigSave");
        }
        if (str != null) {
            return Boolean.valueOf(str);
        }
        return true;
    }

    String encoding() {
        String str = this.context.getProperty("felix.fileinstall.configEncoding");
        return str != null ? str : "ISO-8859-1";
    }

    ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setConfig(File f) throws Exception {
        Hashtable old;
        Hashtable<String, Object> ht;
        block22: {
            ht = new Hashtable<String, Object>();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
                Map<Object, Object> p;
                ((InputStream)in).mark(1);
                boolean isXml = ((InputStream)in).read() == 60;
                ((InputStream)in).reset();
                if (isXml) {
                    p = new Properties();
                    ((Properties)p).loadFromXML(in);
                    HashMap<String, String> strMap = new HashMap<String, String>();
                    for (Object k : ((Properties)p).keySet()) {
                        strMap.put(k.toString(), ((Properties)p).getProperty(k.toString()));
                    }
                    InterpolationHelper.performSubstitution(strMap, this.context);
                    ht.putAll(strMap);
                    break block22;
                }
                p = new TypedProperties(this.bundleSubstitution());
                InputStreamReader r = new InputStreamReader((InputStream)in, this.encoding());
                Object object = null;
                try {
                    ((TypedProperties)p).load(r);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (object != null) {
                            try {
                                ((Reader)r).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((Reader)r).close();
                        }
                    }
                }
                for (String k : ((AbstractMap)p).keySet()) {
                    ht.put(k, ((TypedProperties)p).get(k));
                }
            }
        }
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        Dictionary props = config.getProperties();
        Hashtable hashtable = old = props != null ? new Hashtable(new DictionaryAsMap(props)) : null;
        if (old != null) {
            old.remove("felix.fileinstall.filename");
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        if (!ht.equals(old)) {
            ht.put("felix.fileinstall.filename", this.toConfigKey(f));
            if (old == null) {
                Util.log(this.context, 3, "Creating configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".cfg", null);
            } else {
                Util.log(this.context, 3, "Updating configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".cfg", null);
            }
            config.update(ht);
            return true;
        }
        return false;
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        Util.log(this.context, 3, "Deleting configuration from " + pid[0] + (pid[1] == null ? "" : "-" + pid[1]) + ".cfg", null);
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        config.delete();
        return true;
    }

    String toConfigKey(File f) {
        return f.getAbsoluteFile().toURI().toString();
    }

    File fromConfigKey(String key) {
        return new File(URI.create(key));
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String fileName, String pid, String factoryPid) throws Exception {
        Configuration oldConfiguration = this.findExistingConfiguration(fileName);
        if (oldConfiguration != null) {
            return oldConfiguration;
        }
        Configuration newConfiguration = factoryPid != null ? this.getConfigurationAdmin().createFactoryConfiguration(pid, "?") : this.getConfigurationAdmin().getConfiguration(pid, "?");
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String fileName) throws Exception {
        String filter = "(felix.fileinstall.filename=" + this.escapeFilterValue(fileName) + ")";
        Configuration[] configurations = this.getConfigurationAdmin().listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    TypedProperties.SubstitutionCallback bundleSubstitution() {
        final InterpolationHelper.BundleContextSubstitutionCallback cb = new InterpolationHelper.BundleContextSubstitutionCallback(this.context);
        return new TypedProperties.SubstitutionCallback(){

            @Override
            public String getValue(String name, String key, String value) {
                return cb.getValue(value);
            }
        };
    }

    private String escapeFilterValue(String s) {
        return s.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)").replaceAll("[=]", "\\\\=").replaceAll("[\\*]", "\\\\*");
    }
}

