/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.concurrent.monitoring;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;

public class ConcurrentMonitoringUtils {
    private static final Logger _logger = LogFacade.getLogger();
    static final String NODE = "/";
    static final String SEP = "-";
    static final String APPLICATION_NODE = "applications/";
    static final String CONCURRENT_MONITORING_NODE = "thread-pool";
    static final String METHOD_NODE = "/bean-methods/";

    static String registerSingleComponent(String nodeItemName, Object listener) {
        String beanTreeNode = "executorService/" + nodeItemName;
        try {
            StatsProviderManager.register((String)CONCURRENT_MONITORING_NODE, (PluginPoint)PluginPoint.APPLICATIONS, (String)beanTreeNode, (Object)listener);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "[**ConcurrentMonitoringUtils**] Could not register listener for " + nodeItemName, ex);
            return null;
        }
        return beanTreeNode;
    }

    public static String stringify(Method m) {
        Class<?>[] args;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("==> Converting method to String: " + m);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        for (Class<?> c : args = m.getParameterTypes()) {
            sb.append(SEP).append(c.getName().replaceAll("_", "\\."));
        }
        String result = sb.toString().replaceAll("\\.", "\\\\.");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("==> Converted method String: " + result);
        }
        return result;
    }

    static String getBeanNode(String appName, String moduleName, String beanName) {
        StringBuilder sb = new StringBuilder();
        if (appName != null) {
            sb.append(appName).append(NODE);
        }
        sb.append(moduleName).append(NODE).append(beanName);
        String beanSubTreeNode = sb.toString().replaceAll("\\.", "\\\\.").replaceAll("_jar", "\\\\.jar").replaceAll("_war", "\\\\.war");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("BEAN NODE NAME: " + beanSubTreeNode);
        }
        return beanSubTreeNode;
    }

    public static String getInvokerId(String appName, String modName, String beanName) {
        if (appName == null) {
            return "_" + modName + "_" + beanName;
        }
        return "_" + appName + "_" + modName + "_" + beanName;
    }

    public static String getDetailedLoggingName(String appName, String modName, String beanName) {
        if (appName == null) {
            return "modName=" + modName + "; beanName=" + beanName;
        }
        return "appName=" + appName + "; modName=" + modName + "; beanName=" + beanName;
    }

    public static String getLoggingName(String appName, String modName, String beanName) {
        if (appName == null) {
            return modName + ":" + beanName;
        }
        return appName + ":" + modName + ":" + beanName;
    }
}

