/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.concurrent.monitoring;

import fish.payara.concurrent.monitoring.ConcurrentMonitoringUtils;
import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ManagedScheduledExecutorServiceConfig;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="managed-scheduled-executor-service-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="ManagedScheduledExecutorService Statistics")
public class ManagedScheduledExecutorServiceStatsProvider {
    private final String name;
    private boolean registered = false;
    private final ManagedScheduledExecutorServiceImpl managedScheduledExecutorServiceImpl;
    private CountStatisticImpl completedTaskCount = new CountStatisticImpl("CompletedTaskCount", "count", "Number of tasks completed");
    private CountStatisticImpl taskCount = new CountStatisticImpl("TaskCount", "count", "Total number of tasks ever scheduled");
    private CountStatisticImpl activeCount = new CountStatisticImpl("ActiveCount", "count", "The approximate number of active threads");
    private CountStatisticImpl largestPoolSize = new CountStatisticImpl("LargestPoolSize", "count", "The largest number of threads that have ever simultaneously been in the pool.");
    private CountStatisticImpl poolSize = new CountStatisticImpl("PoolSize", "count", "The current number of threads in the pool.");

    public ManagedScheduledExecutorServiceStatsProvider(ManagedScheduledExecutorService managedScheduledExecutorService) {
        ManagedScheduledExecutorServiceConfig managedScheduledExecutorServiceConfig = new ManagedScheduledExecutorServiceConfig(managedScheduledExecutorService);
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.managedScheduledExecutorServiceImpl = concurrentRuntime.getManagedScheduledExecutorService(null, managedScheduledExecutorServiceConfig);
        this.name = this.managedScheduledExecutorServiceImpl.getName();
    }

    public void register() {
        String node = ConcurrentMonitoringUtils.registerSingleComponent(this.name, this);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
        }
    }

    @ManagedAttribute(id="CompletedTaskCount")
    @Description(value="Number of tasks completed")
    public CountStatistic getCompletedTaskCount() {
        this.completedTaskCount.setCount(this.managedScheduledExecutorServiceImpl.getCompletedTaskCount());
        return this.completedTaskCount;
    }

    @ManagedAttribute(id="TaskCount")
    @Description(value="Total number of tasks ever scheduled")
    public CountStatistic getTaskCount() {
        this.taskCount.setCount(this.managedScheduledExecutorServiceImpl.getTaskCount());
        return this.taskCount;
    }

    @ManagedAttribute(id="ActiveCount")
    @Description(value="The approximate number of active threads")
    public CountStatistic getActiveCount() {
        this.activeCount.setCount((long)this.managedScheduledExecutorServiceImpl.getActiveCount());
        return this.activeCount;
    }

    @ManagedAttribute(id="LargestPoolSize")
    @Description(value="The largest number of threads that have ever simultaneously been in the pool")
    public CountStatistic getLargestPoolSize() {
        this.largestPoolSize.setCount((long)this.managedScheduledExecutorServiceImpl.getLargestPoolSize());
        return this.largestPoolSize;
    }

    @ManagedAttribute(id="PoolSize")
    @Description(value="The current number of threads in the pool")
    public CountStatistic getPoolSize() {
        this.poolSize.setCount((long)this.managedScheduledExecutorServiceImpl.getPoolSize());
        return this.poolSize;
    }
}

