/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.commands;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.login.LDAPLoginModule;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.InitialContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.security.services.config.AuthenticationService;
import org.glassfish.security.services.config.LoginModuleConfig;
import org.glassfish.security.services.config.SecurityConfigurations;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.config.SecurityProviderConfig;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="configure-ldap-for-admin")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="configure-ldap-for-admin", description="configure-ldap-for-admin")})
public class LDAPAdminAccessConfigurator
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(name="basedn", shortName="b", optional=false)
    public volatile String basedn;
    @Param(name="url", optional=true)
    public volatile String url = "ldap://localhost:389";
    @Param(name="ldap-group", shortName="g", optional=true)
    public volatile String ldapGroupName;
    @Inject
    Target targetService;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    private static final String ADMIN_SERVER = "server";
    private static final StringManager lsm = StringManager.getManager(LDAPAdminAccessConfigurator.class);
    private static final String DIR_P = "directory";
    private static final String BASEDN_P = "base-dn";
    private static final String JAAS_P = "jaas-context";
    private static final String JAAS_V = "ldapRealm";
    public static final String LDAP_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String DEFAULT_SSL_LDAP_SOCKET_FACTORY = "com.sun.enterprise.security.auth.realm.ldap.CustomSocketFactory";
    public static final String LDAPS_URL = "ldaps://";
    private static final Logger logger = Logger.getLogger("javax.enterprise.security.services.commands", "org.glassfish.security.services.LogMessages");
    private static final String AUTHENTICATION_SERVICE_PROVIDER_NAME = "adminAuth";
    private static final String FILE_REALM_SECURITY_PROVIDER_NAME = "adminFile";
    private static final String ADMIN_FILE_LM_NAME = "adminFileLM";
    private Config asc;
    @AccessRequired.To(value={"update"})
    private AuthRealm adminAuthRealm;
    @AccessRequired.To(value={"update"})
    private AdminService adminService;
    @AccessRequired.To(value={"update"})
    private SecurityProvider fileRealmProvider;
    @Inject
    private SecurityConfigurations securityConfigs;
    public static final String FIXED_ADMIN_REALM_NAME = "admin-realm";
    public static final String ORIG_ADMIN_REALM_NAME = "admin-realm-original";

    public boolean preAuthorization(AdminCommandContext context) {
        this.asc = this.chooseConfig();
        SecurityService ss = this.asc.getSecurityService();
        this.adminAuthRealm = this.getAdminRealm(ss);
        this.adminService = this.asc.getAdminService();
        AuthenticationService adminAuthService = (AuthenticationService)this.securityConfigs.getSecurityServiceByName(AUTHENTICATION_SERVICE_PROVIDER_NAME);
        ActionReport report = context.getActionReport();
        if (adminAuthService == null) {
            report.setMessage(lsm.getString("ldap.noExistingAtnService", (Object)AUTHENTICATION_SERVICE_PROVIDER_NAME));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.fileRealmProvider = adminAuthService.getSecurityProviderByName(FILE_REALM_SECURITY_PROVIDER_NAME);
        if (this.fileRealmProvider == null) {
            report.setMessage(lsm.getString("ldap.noExistingAtnProvider", (Object)FILE_REALM_SECURITY_PROVIDER_NAME));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (!"LoginModule".equals(this.fileRealmProvider.getType())) {
            report.setMessage(lsm.getString("ldap.fileRealmProviderNotLoginModuleType", (Object)FILE_REALM_SECURITY_PROVIDER_NAME, (Object)adminAuthService.getName(), (Object)this.fileRealmProvider.getType()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport rep = context.getActionReport();
        StringBuilder sb = new StringBuilder();
        if (this.url != null && !this.url.startsWith("ldap://") && !this.url.startsWith(LDAPS_URL)) {
            this.url = "ldap://" + this.url;
        }
        if (!this.pingLDAP(sb)) {
            rep.setMessage(sb.toString());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.configure(sb);
            rep.setMessage(sb.toString());
            rep.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tf) {
            rep.setMessage(tf.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (PropertyVetoException e) {
            rep.setMessage(e.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (RetryableException re) {
            rep.setMessage(re.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void configure(StringBuilder sb) throws TransactionFailure, PropertyVetoException, RetryableException {
        Transaction t = new Transaction();
        SecurityService w_asc = (SecurityService)t.enroll((ConfigBeanProxy)this.asc.getSecurityService());
        AdminService w_adminSvc = (AdminService)t.enroll((ConfigBeanProxy)this.asc.getAdminService());
        this.deleteRealm(w_asc, sb);
        this.createRealm(w_asc, sb);
        this.configureAdminService(w_adminSvc);
        this.updateSecurityProvider(t, this.fileRealmProvider, sb);
        t.commit();
    }

    private void updateSecurityProvider(Transaction t, SecurityProvider w_sp, StringBuilder sb) throws TransactionFailure, PropertyVetoException {
        for (SecurityProviderConfig spc : w_sp.getSecurityProviderConfig()) {
            if (!(spc instanceof LoginModuleConfig) || !spc.getName().equals(ADMIN_FILE_LM_NAME)) continue;
            LoginModuleConfig w_lmConfig = (LoginModuleConfig)t.enroll((ConfigBeanProxy)((LoginModuleConfig)spc));
            w_lmConfig.setModuleClass(LDAPLoginModule.class.getName());
            sb.append(lsm.getString("ldap.authProviderConfigOK", (Object)w_sp.getName()));
            return;
        }
        throw new TransactionFailure(lsm.getString("ldap.noAuthProviderConfig", (Object)w_sp.getName(), (Object)ADMIN_FILE_LM_NAME));
    }

    private AuthRealm getAdminRealm(SecurityService ss) {
        List realms = ss.getAuthRealm();
        for (AuthRealm realm : realms) {
            if (!FIXED_ADMIN_REALM_NAME.equals(realm.getName())) continue;
            return realm;
        }
        return null;
    }

    private void configureAdminService(AdminService as) {
        as.setAuthRealmName(FIXED_ADMIN_REALM_NAME);
    }

    private void createRealm(SecurityService w_ss, StringBuilder sb) throws TransactionFailure, PropertyVetoException {
        AuthRealm ldapr = this.createLDAPRealm(w_ss);
        w_ss.getAuthRealm().add(ldapr);
        LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.realm.setup", (Object)FIXED_ADMIN_REALM_NAME));
    }

    private void deleteRealm(SecurityService w_ss, StringBuilder sb) {
        AuthRealm oldAdminRealm = this.getAdminRealm(w_ss);
        w_ss.getAuthRealm().remove(oldAdminRealm);
        LDAPAdminAccessConfigurator.appendNL(sb, "...");
    }

    private AuthRealm createLDAPRealm(SecurityService ss) throws TransactionFailure, PropertyVetoException {
        AuthRealm ar = (AuthRealm)ss.createChild(AuthRealm.class);
        ar.setClassname(LDAPRealm.class.getName());
        ar.setName(FIXED_ADMIN_REALM_NAME);
        List props = ar.getProperty();
        Property p = (Property)ar.createChild(Property.class);
        p.setName(DIR_P);
        p.setValue(this.url);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName(BASEDN_P);
        p.setValue(this.basedn);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName(JAAS_P);
        p.setValue(JAAS_V);
        props.add(p);
        if (this.ldapGroupName != null) {
            p = (Property)ar.createChild(Property.class);
            p.setName("group-mapping");
            p.setValue(this.ldapGroupName + "->asadmin");
            props.add(p);
        }
        return ar;
    }

    private boolean pingLDAP(StringBuilder sb) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        if (this.url != null && this.url.startsWith(LDAPS_URL)) {
            env.put(LDAP_SOCKET_FACTORY, DEFAULT_SSL_LDAP_SOCKET_FACTORY);
        }
        try {
            new InitialContext(env);
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.ok", (Object)this.url));
            return true;
        }
        catch (AuthenticationNotSupportedException anse) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.ok", (Object)this.url));
            return true;
        }
        catch (Exception e) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.na", (Object)this.url, (Object)e.getClass().getName(), (Object)e.getMessage()));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, StringUtils.getStackTrace((Throwable)e));
            }
            return false;
        }
    }

    private static void appendNL(StringBuilder sb, String s) {
        sb.append(s).append("%%%EOL%%%");
    }

    private Config chooseConfig() {
        Server s = this.configBeansUtilities.getServerNamed(ADMIN_SERVER);
        String ac = s.getConfigRef();
        return this.targetService.getConfig(ac);
    }
}

