/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.requesttracing.jaxrs.client;

import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import fish.payara.requesttracing.jaxrs.client.SpanPropagator;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class JaxrsClientRequestTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String REQUEST_CONTEXT_TRACING_PREDICATE = "fish.payara.requesttracing.jaxrs.client.TracingPredicate";

    public void filter(ClientRequestContext requestContext) throws IOException {
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        RequestTracingService requestTracing = payaraTracingServices.getRequestTracingService();
        if (requestTracing != null && requestTracing.isRequestTracingEnabled()) {
            if (requestTracing.isTraceInProgress()) {
                if (!requestContext.getHeaders().containsKey((Object)"Payara-Tracing-TraceId")) {
                    requestContext.getHeaders().add((Object)"Payara-Tracing-TraceId", (Object)requestTracing.getConversationID());
                }
                if (!requestContext.getHeaders().containsKey((Object)"Payara-Tracing-ParentId")) {
                    requestContext.getHeaders().add((Object)"Payara-Tracing-ParentId", (Object)requestTracing.getStartingTraceID());
                }
                if (!requestContext.getHeaders().containsKey((Object)"Payara-Tracing-RelationshipType")) {
                    if (requestContext.getMethod().equals("POST")) {
                        requestContext.getHeaders().add((Object)"Payara-Tracing-RelationshipType", (Object)RequestTraceSpan.SpanContextRelationshipType.FollowsFrom);
                    } else {
                        requestContext.getHeaders().add((Object)"Payara-Tracing-RelationshipType", (Object)RequestTraceSpan.SpanContextRelationshipType.ChildOf);
                    }
                }
            }
            if (this.shouldTrace(requestContext)) {
                Tracer tracer = payaraTracingServices.getActiveTracer();
                Tracer.SpanBuilder spanBuilder = tracer.buildSpan(requestContext.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.HTTP_METHOD.getKey(), requestContext.getMethod()).withTag(Tags.HTTP_URL.getKey(), requestContext.getUri().toURL().toString()).withTag(Tags.COMPONENT.getKey(), "jaxrs");
                SpanContext parentSpanContext = (SpanContext)requestContext.getProperty("Payara-Tracing-OpenTracing-SpanContext");
                if (parentSpanContext != null) {
                    spanBuilder.asChildOf(parentSpanContext);
                } else {
                    parentSpanContext = SpanPropagator.propagatedContext();
                    if (parentSpanContext != null) {
                        spanBuilder.asChildOf(parentSpanContext);
                    }
                }
                parentSpanContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)requestContext.getHeaders()));
                if (parentSpanContext != null) {
                    spanBuilder.asChildOf(parentSpanContext);
                }
                Span activeSpan = spanBuilder.startActive(true).span();
                tracer.inject(activeSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)requestContext.getHeaders()));
            }
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        RequestTracingService requestTracing = payaraTracingServices.getRequestTracingService();
        if (requestTracing != null && requestTracing.isRequestTracingEnabled() && this.shouldTrace(requestContext)) {
            try (Scope activeScope = payaraTracingServices.getActiveTracer().scopeManager().active();){
                if (activeScope == null) {
                    Logger.getLogger(JaxrsClientRequestTracingFilter.class.getName()).log(Level.FINE, "activeScope in  opentracing request tracing filter was null for {0}", responseContext);
                    return;
                }
                Span activeSpan = activeScope.span();
                Response.StatusType statusInfo = responseContext.getStatusInfo();
                activeSpan.setTag(Tags.HTTP_STATUS.getKey(), (Number)statusInfo.getStatusCode());
                if (statusInfo.getFamily() == Response.Status.Family.CLIENT_ERROR || statusInfo.getFamily() == Response.Status.Family.SERVER_ERROR) {
                    activeSpan.setTag(Tags.ERROR.getKey(), true);
                    activeSpan.log(Collections.singletonMap("event", "error"));
                    activeSpan.log(Collections.singletonMap("error.object", statusInfo.getFamily()));
                }
            }
        }
    }

    private boolean shouldTrace(ClientRequestContext requestContext) {
        Object traceFilter = requestContext.getConfiguration().getProperty(REQUEST_CONTEXT_TRACING_PREDICATE);
        if (traceFilter instanceof Predicate) {
            return ((Predicate)traceFilter).test(requestContext);
        }
        return true;
    }

    private class MultiValuedMapStringIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<String, List<Object>>> mapIterator;
        private Map.Entry<String, List<Object>> mapEntry;
        private Iterator<Object> mapEntryIterator;

        public MultiValuedMapStringIterator(Set<Map.Entry<String, List<Object>>> entrySet) {
            this.mapIterator = entrySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mapEntryIterator != null && this.mapEntryIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<String, String> next() {
            if (this.mapEntry == null || !this.mapEntryIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.mapEntryIterator = this.mapEntry.getValue().iterator();
            }
            if (this.mapEntryIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<String, String>(this.mapEntry.getKey(), this.mapEntryIterator.next().toString());
            }
            return new AbstractMap.SimpleImmutableEntry<String, Object>(this.mapEntry.getKey(), null);
        }
    }

    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, Object> map;

        public MultivaluedMapToTextMap(MultivaluedMap<String, Object> map) {
            this.map = map;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultiValuedMapStringIterator(this.map.entrySet());
        }

        public void put(String key, String value) {
            this.map.add((Object)key, (Object)value);
        }
    }
}

