/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import javax.annotation.PostConstruct;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.server.validation.internal.HibernateInjectingConstraintValidatorFactory;
import org.glassfish.jersey.server.validation.internal.InjectingConstraintValidatorFactory;

public class CompositeInjectingConstraintValidatorFactory
implements ConstraintValidatorFactory {
    @Context
    private ResourceContext resourceContext;
    private InjectingConstraintValidatorFactory jerseyVF;
    private HibernateInjectingConstraintValidatorFactory hibernateVF;

    @PostConstruct
    void postConstruct() {
        this.jerseyVF = (InjectingConstraintValidatorFactory)this.resourceContext.getResource(InjectingConstraintValidatorFactory.class);
        this.hibernateVF = (HibernateInjectingConstraintValidatorFactory)this.resourceContext.getResource(HibernateInjectingConstraintValidatorFactory.class);
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        T jerseyInstance = this.jerseyVF.getInstance(key);
        if (jerseyInstance == null) {
            return this.hibernateVF.getInstance(key);
        }
        return jerseyInstance;
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
    }
}

