/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.common.util.logging.BooleanLatch;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.Syslog;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ContractsProvided(value={SyslogHandler.class, Handler.class})
public class SyslogHandler
extends Handler
implements PostConstruct,
PreDestroy {
    @Inject
    ServerEnvironmentImpl env;
    private Syslog sysLogger;
    private Thread pump = null;
    private BooleanLatch done = new BooleanLatch();
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private SimpleFormatter simpleFormatter = new SimpleFormatter();

    public void postConstruct() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String systemLogging = TranslatedConfigView.expandValue((String)manager.getProperty((cname = this.getClass().getName()) + ".useSystemLogging"));
        if (systemLogging == null || systemLogging.equals("false")) {
            return;
        }
        this.setupConnection();
        this.initializePump();
    }

    private void initializePump() {
        this.pump = new Thread(){

            @Override
            public void run() {
                try {
                    while (!SyslogHandler.this.done.isSignalled() && !SyslogHandler.this.pump.isInterrupted()) {
                        SyslogHandler.this.log();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.pump.start();
    }

    private void setupConnection() {
        try {
            this.sysLogger = new Syslog("localhost");
        }
        catch (UnknownHostException e) {
            LogFacade.LOGGING_LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00006", e);
            return;
        }
    }

    public void preDestroy() {
        if (LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
            LogFacade.LOGGING_LOGGER.fine("SysLog Logger handler killed");
        }
    }

    public void log() {
        LogRecord record;
        try {
            record = this.pendingRecords.take();
        }
        catch (InterruptedException e) {
            return;
        }
        Level level = record.getLevel();
        long millisec = record.getMillis();
        int syslogLevel = 6;
        String logLevel = "INFO";
        if (level.equals(Level.SEVERE)) {
            syslogLevel = 2;
            logLevel = "CRIT";
        } else if (level.equals(Level.WARNING)) {
            syslogLevel = 4;
            logLevel = "WARNING";
        } else if (level.intValue() <= Level.FINE.intValue()) {
            syslogLevel = 7;
            logLevel = "DEBUG";
        }
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd HH:mm:ss");
        sb.append(formatter.format(millisec));
        sb.append(" [ ");
        sb.append(logLevel);
        sb.append(" glassfish ] ");
        String formattedMsg = this.simpleFormatter.formatMessage(record);
        sb.append(formattedMsg);
        if (this.sysLogger != null) {
            this.sysLogger.log(24, syslogLevel, sb.toString());
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.pump == null) {
            return;
        }
        try {
            this.pendingRecords.add(record);
        }
        catch (IllegalStateException e) {
            try {
                this.pendingRecords.put(record);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public void setSystemLogging(boolean systemLogging) {
        if (systemLogging) {
            this.setupConnection();
            this.initializePump();
        } else if (this.pump.isAlive()) {
            this.pump.interrupt();
        }
    }
}

