/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.LogFormatHelper;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserFactory;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;

public class LogFile
implements Serializable {
    private static final long serialVersionUID = -2960142541274652618L;
    private final long _indexSize = 10L;
    private final String _logFileName;
    private final List<Long> _recordIdx = new ArrayList<Long>();

    public LogFile(String name) {
        this._logFileName = name;
        this._recordIdx.add(0L);
    }

    public List getLogEntries(long startingRecord) {
        return this.getLogEntries(startingRecord, this.getIndexSize());
    }

    public List getLogEntries(final long startingRecord, final long maxRecords) {
        if (startingRecord < 0L) {
            return null;
        }
        final long recordsToIgnore = startingRecord % this.getIndexSize();
        return this.getFilePosition(startingRecord - recordsToIgnore).map(rdr -> {
            try (BufferedReader reader = rdr;){
                final ArrayList results = new ArrayList();
                File logFile = new File(this.getLogFileName());
                LogParser logParser = LogParserFactory.getInstance().createLogParser(logFile);
                logParser.parseLog(reader, new LogParserListener(){
                    long counter = 0L;

                    @Override
                    public void outputSummary(BufferedWriter writer, Object ... objects) throws IOException {
                    }

                    @Override
                    public void foundLogRecord(long position, ParsedLogRecord logRecord) {
                        ++this.counter;
                        if (this.counter <= recordsToIgnore) {
                            return;
                        }
                        if ((long)results.size() < maxRecords) {
                            LogEntry entry = new LogEntry(logRecord.getFormattedLogRecord(), startingRecord + (long)results.size());
                            entry.setLoggedDateTime(new Date(logRecord.getTimeMillis()));
                            entry.setLoggedLevel(logRecord.getLevel());
                            entry.setLoggedLoggerName(logRecord.getLogger());
                            entry.setLoggedMessage(logRecord.getMessage());
                            entry.setLoggedNameValuePairs(logRecord.getSupplementalAttributes().toString());
                            entry.setLoggedProduct(logRecord.getComponentId());
                            entry.setMessageId(logRecord.getMessageId());
                            results.add(entry);
                        }
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
                ArrayList arrayList = results;
                return arrayList;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).orElse(Collections.emptyList());
    }

    private synchronized void buildLogFileIndex() {
        final long startPos = this._recordIdx.get(this._recordIdx.size() - 1);
        final long localIndexSize = this.getIndexSize();
        this.getLogFileReader(startPos).ifPresent(rdr -> {
            try (BufferedReader reader = rdr;){
                File logFile = new File(this.getLogFileName());
                LogParser logParser = LogParserFactory.getInstance().createLogParser(logFile);
                if (logParser != null) {
                    logParser.parseLog(reader, new LogParserListener(){
                        long recordNumber;
                        {
                            this.recordNumber = (long)(LogFile.this._recordIdx.size() - 1) * localIndexSize;
                        }

                        @Override
                        public void outputSummary(BufferedWriter writer, Object ... objects) throws IOException {
                        }

                        @Override
                        public void foundLogRecord(long position, ParsedLogRecord object) {
                            long modIndex = this.recordNumber % localIndexSize;
                            if (modIndex == 0L) {
                                LogFile.this._recordIdx.add(startPos + position);
                            }
                            ++this.recordNumber;
                        }

                        @Override
                        public void close() throws IOException {
                        }
                    });
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private Optional<BufferedReader> getFilePosition(long recordNumber) {
        int index = (int)(recordNumber / this.getIndexSize());
        if (index > this._recordIdx.size() - 1) {
            return Optional.empty();
        }
        Long filePosition = this._recordIdx.get(index);
        return this.getLogFileReader(filePosition);
    }

    private Optional<BufferedReader> getLogFileReader(long fromFilePosition) {
        InputStream file = null;
        try {
            long bytesSkipped;
            file = LogFormatHelper.isCompressedFile(this.getLogFileName()) ? new GZIPInputStream(new FileInputStream(this.getLogFileName())) : new FileInputStream(this.getLogFileName());
            long bytesToSkip = fromFilePosition - 1L;
            if (bytesToSkip > 0L && (bytesSkipped = file.skip(bytesToSkip)) != fromFilePosition && LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
                LogFacade.LOGGING_LOGGER.log(Level.FINE, "Did not skip exact bytes while positioning reader in " + this.getLogFileName());
            }
            return Optional.of(new BufferedReader(new InputStreamReader(file)));
        }
        catch (Exception ex) {
            block7: {
                if (LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
                    LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error reading from file: " + this.getLogFileName(), ex);
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception ex2) {
                        if (!LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) break block7;
                        LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error closing file: " + this.getLogFileName(), ex2);
                    }
                }
            }
            return Optional.empty();
        }
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public long getLastIndexNumber() {
        this.buildLogFileIndex();
        return this._recordIdx.size() - 1;
    }

    public long getIndexSize() {
        return 10L;
    }

    public static class LogEntry
    implements Serializable {
        private static final long serialVersionUID = -8597022493595023899L;
        private long recordNumber = -1L;
        private Date loggedDateTime = null;
        private String loggedLevel = null;
        private String loggedProduct = null;
        private String loggedLoggerName = null;
        private String loggedNameValuePairs = null;
        private String loggedMessage = null;
        private String messageId = "";

        public LogEntry(String line, long recordNumber) {
            this.setRecordNumber(recordNumber);
        }

        public Date getLoggedDateTime() {
            return this.loggedDateTime;
        }

        public void setLoggedDateTime(Date loggedDateTime) {
            this.loggedDateTime = loggedDateTime;
        }

        public String getLoggedLevel() {
            return this.loggedLevel;
        }

        public void setLoggedLevel(String loggedLevel) {
            this.loggedLevel = loggedLevel;
        }

        public String getLoggedProduct() {
            return this.loggedProduct;
        }

        public void setLoggedProduct(String loggedProduct) {
            this.loggedProduct = loggedProduct;
        }

        public String getLoggedLoggerName() {
            return this.loggedLoggerName;
        }

        public void setLoggedLoggerName(String loggedLoggerName) {
            this.loggedLoggerName = loggedLoggerName;
        }

        public String getLoggedNameValuePairs() {
            return this.loggedNameValuePairs;
        }

        public void setLoggedNameValuePairs(String loggedNameValuePairs) {
            this.loggedNameValuePairs = loggedNameValuePairs;
        }

        public void setLoggedMessage(String message) {
            this.loggedMessage = message;
        }

        public void appendLoggedMessage(String message) {
            this.loggedMessage = this.loggedMessage + message;
        }

        public String getLoggedMessage() {
            return this.loggedMessage;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public long getRecordNumber() {
            return this.recordNumber;
        }

        public void setRecordNumber(long recordNumber) {
            this.recordNumber = recordNumber;
        }

        public String toString() {
            return this.getRecordNumber() + ":" + this.getLoggedMessage();
        }
    }
}

