/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.LogFormatHelper;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.ODLLogParser;
import com.sun.enterprise.server.logging.parser.RawLogParser;
import com.sun.enterprise.server.logging.parser.UniformLogParser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class LogParserFactory {
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(LogParserFactory.class);
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String ODL_LINE_HEADER_REGEX = "\\[(\\d){4}\\-(\\d){2}\\-(\\d){2}T(\\d){2}\\:(\\d){2}\\:(\\d){2}\\.(\\d){3}[\\+|\\-](\\d){4}\\].*";
    private static final boolean DEBUG = false;
    private Pattern odlDateFormatPattern = Pattern.compile("\\[(\\d){4}\\-(\\d){2}\\-(\\d){2}T(\\d){2}\\:(\\d){2}\\:(\\d){2}\\.(\\d){3}[\\+|\\-](\\d){4}\\].*");

    public static LogParserFactory getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private LogParserFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogParser createLogParser(File logFile) throws LogParserException, IOException {
        try (BufferedReader reader = null;){
            reader = LogFormatHelper.isCompressedFile(logFile.getName()) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(logFile)))) : new BufferedReader(new FileReader(logFile));
            String line = reader.readLine();
            LogFormat format = this.detectLogFormat(line);
            switch (format) {
                case UNIFORM_LOG_FORMAT: {
                    UniformLogParser uniformLogParser = new UniformLogParser(logFile.getName());
                    return uniformLogParser;
                }
                case ODL_LOG_FORMAT: {
                    ODLLogParser oDLLogParser = new ODLLogParser(logFile.getName());
                    return oDLLogParser;
                }
            }
            RawLogParser rawLogParser = new RawLogParser(logFile.getName());
            return rawLogParser;
        }
    }

    Pattern getODLDateFormatPattern() {
        return this.odlDateFormatPattern;
    }

    private LogFormat detectLogFormat(String line) {
        if (line != null) {
            Matcher m = this.odlDateFormatPattern.matcher(line);
            if (m.matches()) {
                return LogFormat.ODL_LOG_FORMAT;
            }
            if (LogFormatHelper.isUniformFormatLogHeader(line)) {
                return LogFormat.UNIFORM_LOG_FORMAT;
            }
        }
        return LogFormat.UNKNOWN_LOG_FORMAT;
    }

    private static class SingletonHolder {
        private static final LogParserFactory SINGLETON = new LogParserFactory();

        private SingletonHolder() {
        }
    }

    private static enum LogFormat {
        UNIFORM_LOG_FORMAT,
        ODL_LOG_FORMAT,
        UNKNOWN_LOG_FORMAT;

    }
}

