/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.cdi;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.cdi.FaultTolerance;
import fish.payara.microprofile.faulttolerance.cdi.FaultToleranceInterceptor;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceUtils;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceExtension
implements Extension {
    private static final Annotation MARKER = () -> FaultTolerance.class;
    private static final String INTERCEPTOR_PRIORITY_PROPERTY = "mp.fault.tolerance.interceptor.priority";

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(FaultToleranceInterceptor.class), "MP-FT");
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={Asynchronous.class, Bulkhead.class, CircuitBreaker.class, Fallback.class, Retry.class, Timeout.class}) ProcessAnnotatedType<T> processAnnotatedType) throws Exception {
        Class<? extends Annotation>[] alternativeAsynchronousAnnotations = FaultToleranceExtension.getAlternativeAsynchronousAnnotations();
        AnnotatedType type = processAnnotatedType.getAnnotatedType();
        boolean markAllMethods = FaultToleranceUtils.isAnnotatedWithFaultToleranceAnnotations((Annotated)type) || FaultToleranceExtension.isAnyAnnotationPresent((Annotated)type, alternativeAsynchronousAnnotations);
        Class targetClass = type.getJavaClass();
        for (AnnotatedMethodConfigurator methodConfigurator : processAnnotatedType.configureAnnotatedType().methods()) {
            AnnotatedMethod method = methodConfigurator.getAnnotated();
            if (!markAllMethods && !FaultToleranceUtils.isAnnotatedWithFaultToleranceAnnotations((Annotated)method) && !FaultToleranceExtension.isAnyAnnotationPresent((Annotated)method, alternativeAsynchronousAnnotations)) continue;
            FaultTolerancePolicy.asAnnotated(targetClass, method.getJavaMember());
            methodConfigurator.add(MARKER);
        }
    }

    private static boolean isAnyAnnotationPresent(Annotated element, Class<? extends Annotation>[] annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!element.isAnnotationPresent(annotationType)) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends Annotation>[] getAlternativeAsynchronousAnnotations() {
        Optional alternativeAsynchronousAnnotationNames = ConfigProvider.getConfig().getOptionalValue("MP_Fault_Tolerance_Alternative_Asynchronous_Annotations", String.class);
        return alternativeAsynchronousAnnotationNames.isPresent() ? FaultToleranceUtils.toClassArray((String)alternativeAsynchronousAnnotationNames.get(), "MP_Fault_Tolerance_Alternative_Asynchronous_Annotations", FaultToleranceConfig.NO_ALTERNATIVE_ANNOTATIONS) : FaultToleranceConfig.NO_ALTERNATIVE_ANNOTATIONS;
    }

    void changeInterceptorPriority(@Observes ProcessAnnotatedType<FaultToleranceInterceptor> interceptorType) {
        Optional priorityOverride = ConfigProvider.getConfig().getOptionalValue(INTERCEPTOR_PRIORITY_PROPERTY, Integer.class);
        if (priorityOverride.isPresent()) {
            interceptorType.configureAnnotatedType().remove(annotation -> annotation instanceof Priority).add((Annotation)((Object)new PriorityLiteral((Integer)priorityOverride.get())));
        }
    }

    public static final class PriorityLiteral
    extends AnnotationLiteral<Priority>
    implements Priority {
        private static final long serialVersionUID = 1L;
        private final int value;

        public PriorityLiteral(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

