/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.policy.Policy;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ThreadLocalRandom;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.Retry;

public final class RetryPolicy
extends Policy {
    private static final RetryPolicy NONE = new RetryPolicy(null, 0, 0L, ChronoUnit.SECONDS, 0L, ChronoUnit.SECONDS, 0L, ChronoUnit.SECONDS, new Class[0], new Class[0]);
    public final int maxRetries;
    public final long delay;
    public final ChronoUnit delayUnit;
    public final long maxDuration;
    public final ChronoUnit durationUnit;
    public final long jitter;
    public final ChronoUnit jitterDelayUnit;
    public final Class<? extends Throwable>[] retryOn;
    public final Class<? extends Throwable>[] abortOn;

    public RetryPolicy(Method annotatedMethod, int maxRetries, long delay, ChronoUnit delayUnit, long maxDuration, ChronoUnit durationUnit, long jitter, ChronoUnit jitterDelayUnit, Class<? extends Throwable>[] retryOn, Class<? extends Throwable>[] abortOn) {
        if (annotatedMethod != null) {
            RetryPolicy.checkAtLeast(-1L, annotatedMethod, Retry.class, "maxRetries", maxRetries);
            RetryPolicy.checkAtLeast(0L, annotatedMethod, Retry.class, "delay", delay);
            RetryPolicy.checkAtLeast(0L, annotatedMethod, Retry.class, "maxDuration", maxDuration);
            RetryPolicy.checkAtLeast("delay", delay + 1L, annotatedMethod, Retry.class, "maxDuration", maxDuration);
            RetryPolicy.checkAtLeast(0L, annotatedMethod, Retry.class, "jitter", jitter);
        }
        this.maxRetries = maxRetries;
        this.delay = delay;
        this.delayUnit = delayUnit;
        this.maxDuration = maxDuration;
        this.durationUnit = durationUnit;
        this.jitter = jitter;
        this.jitterDelayUnit = jitterDelayUnit;
        this.retryOn = retryOn;
        this.abortOn = abortOn;
    }

    public static RetryPolicy create(InvocationContext context, FaultToleranceConfig config) {
        if (config.isAnnotationPresent(Retry.class) && config.isEnabled(Retry.class)) {
            Retry annotation = config.getAnnotation(Retry.class);
            return new RetryPolicy(context.getMethod(), config.maxRetries(annotation), config.delay(annotation), config.delayUnit(annotation), config.maxDuration(annotation), config.durationUnit(annotation), config.jitter(annotation), config.jitterDelayUnit(annotation), config.retryOn(annotation), config.abortOn(annotation));
        }
        return NONE;
    }

    public boolean isNone() {
        return this != NONE;
    }

    public boolean retryOn(Throwable ex) {
        return !RetryPolicy.isCaught(ex, this.abortOn) && RetryPolicy.isCaught(ex, this.retryOn);
    }

    public Long timeoutTimeNow() {
        return this.maxDuration == 0L ? null : Long.valueOf(System.currentTimeMillis() + Duration.of(this.maxDuration, this.durationUnit).toMillis());
    }

    public boolean isDelayed() {
        return this.delay > 0L || this.jitter > 0L;
    }

    public long jitteredDelay() {
        long duration = Duration.of(this.delay, this.delayUnit).toMillis();
        return this.jitter == 0L ? duration : duration + ThreadLocalRandom.current().nextLong(0L, Duration.of(this.jitter, this.jitterDelayUnit).toMillis());
    }

    public int totalAttempts() {
        return this.maxRetries < 0 ? Integer.MAX_VALUE : this.maxRetries + 1;
    }
}

