/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.state;

import fish.payara.microprofile.faulttolerance.state.StateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CircuitBreakerState {
    private static final Logger logger = Logger.getLogger(CircuitBreakerState.class.getName());
    private final BlockingQueue<Boolean> closedResultsQueue;
    private final AtomicInteger halfOpenSuccessfulResultsCounter = new AtomicInteger(0);
    private final Map<CircuitState, StateTime> allStateTimes = new HashMap<CircuitState, StateTime>();
    private volatile StateTime currentStateTime;

    public CircuitBreakerState(int requestVolumeThreshold) {
        this.closedResultsQueue = new LinkedBlockingQueue<Boolean>(requestVolumeThreshold);
        for (CircuitState state : CircuitState.values()) {
            this.allStateTimes.put(state, new StateTime(state));
        }
        this.currentStateTime = this.allStateTimes.get((Object)CircuitState.CLOSED);
    }

    public CircuitState getCircuitState() {
        return this.currentStateTime.state();
    }

    public void setCircuitState(CircuitState circuitState) {
        this.currentStateTime.update();
        if (!this.currentStateTime.is(circuitState)) {
            StateTime nextStateTime = this.allStateTimes.get((Object)circuitState);
            nextStateTime.reset();
            this.currentStateTime = nextStateTime;
        }
    }

    public void recordClosedOutcome(boolean success) {
        if (!this.closedResultsQueue.offer(success)) {
            this.closedResultsQueue.poll();
            this.closedResultsQueue.offer(success);
        }
    }

    public boolean isClosedOutcomeSuccessOnly() {
        for (Boolean outcome : this.closedResultsQueue) {
            if (outcome.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void resetResults() {
        this.closedResultsQueue.clear();
    }

    public void incrementHalfOpenSuccessfulResultCounter() {
        this.halfOpenSuccessfulResultsCounter.incrementAndGet();
    }

    public void resetHalfOpenSuccessfulResultCounter() {
        this.halfOpenSuccessfulResultsCounter.set(0);
    }

    public int getHalfOpenSuccessfulResultCounter() {
        return this.halfOpenSuccessfulResultsCounter.get();
    }

    public boolean isOverFailureThreshold(int requestVolumeThreshold, double failureRatio) {
        boolean over = false;
        int failures = 0;
        int failureThreshold = (int)Math.round((double)requestVolumeThreshold * failureRatio);
        if (this.closedResultsQueue.remainingCapacity() == 0) {
            for (Boolean success : this.closedResultsQueue) {
                if (success.booleanValue() || ++failures != failureThreshold) continue;
                over = true;
                break;
            }
        } else {
            logger.log(Level.FINE, "CircuitBreaker results queue isn't full yet.");
        }
        return over;
    }

    public long updateAndGet(CircuitState circuitState) {
        return this.currentStateTime.is(circuitState) ? this.currentStateTime.update() : this.allStateTimes.get((Object)circuitState).nanos();
    }

    public long nanosOpen() {
        return this.updateAndGet(CircuitState.OPEN);
    }

    public long nanosHalfOpen() {
        return this.updateAndGet(CircuitState.HALF_OPEN);
    }

    public long nanosClosed() {
        return this.updateAndGet(CircuitState.CLOSED);
    }

    public void close() {
        this.setCircuitState(CircuitState.CLOSED);
        this.resetHalfOpenSuccessfulResultCounter();
        this.resetResults();
    }

    public void open() {
        this.setCircuitState(CircuitState.OPEN);
        this.resetHalfOpenSuccessfulResultCounter();
    }

    public void halfOpen() {
        logger.log(Level.FINE, "Setting CircuitBreaker state to half open");
        this.setCircuitState(CircuitState.HALF_OPEN);
    }

    public boolean halfOpenSuccessfulClosedCircuit(int successThreshold) {
        this.incrementHalfOpenSuccessfulResultCounter();
        if (this.getHalfOpenSuccessfulResultCounter() == successThreshold) {
            this.close();
            return true;
        }
        return false;
    }

    public static enum CircuitState {
        OPEN,
        CLOSED,
        HALF_OPEN;

    }
}

