/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.context;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.util.Utility;
import fish.payara.appserver.context.ContextImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.spi.CDI;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.internal.api.ServerContext;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class JavaEEContextUtilImpl
implements JavaEEContextUtil,
Serializable {
    private transient ServerContext serverContext;
    private transient ComponentEnvManager compEnvMgr;
    private transient ComponentInvocation capturedInvocation;
    private String instanceComponentId;
    private static final String EMPTY_COMPONENT = "___EMPTY___";
    private static final long serialVersionUID = 1L;

    @PostConstruct
    void init() {
        this.serverContext = (ServerContext)Globals.getDefaultHabitat().getService(ServerContext.class, new Annotation[0]);
        this.compEnvMgr = (ComponentEnvManager)Globals.getDefaultHabitat().getService(ComponentEnvManager.class, new Annotation[0]);
        this.doSetInstanceContext();
    }

    protected ServerContext getServerContext() {
        return this.serverContext;
    }

    public String getInstanceComponentId() {
        return this.instanceComponentId;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public JavaEEContextUtil.Context pushContext() {
        InvocationManager invMgr = this.serverContext.getInvocationManager();
        boolean invocationCreated = false;
        if (invMgr.getCurrentInvocation() == null && this.capturedInvocation != null) {
            ComponentInvocation newInvocation = this.capturedInvocation.clone();
            newInvocation.clearRegistry();
            invMgr.preInvoke(newInvocation);
            invocationCreated = true;
        }
        ClassLoader oldClassLoader = null;
        if (invocationCreated) {
            oldClassLoader = EMPTY_COMPONENT.equals(this.getInstanceComponentId()) ? Utility.getClassLoader() : Utility.setContextClassLoader((ClassLoader)this.getInvocationClassLoader());
        }
        return new ContextImpl.Context(invocationCreated ? invMgr.getCurrentInvocation() : null, invMgr, oldClassLoader);
    }

    public JavaEEContextUtil.Context pushRequestContext() {
        JavaEEContextUtil.Context rootCtx = this.pushContext();
        BoundRequestContext brc = (BoundRequestContext)CDI.current().select(BoundRequestContext.class, new Annotation[0]).get();
        ContextImpl.RequestContext context = new ContextImpl.RequestContext(rootCtx, brc.isActive() ? null : brc, new HashMap<String, Object>());
        if (context.ctx != null) {
            context.ctx.associate(context.storage);
            context.ctx.activate();
        }
        return context;
    }

    public JavaEEContextUtil.Context setApplicationClassLoader() {
        ClassLoader cl = null;
        if (this.capturedInvocation != null && this.capturedInvocation.getJNDIEnvironment() != null) {
            cl = this.getClassLoaderForEnvironment((JndiNameEnvironment)this.capturedInvocation.getJNDIEnvironment());
        } else if (this.instanceComponentId != null) {
            cl = this.getClassLoaderForEnvironment(this.compEnvMgr.getJndiNameEnvironment(this.instanceComponentId));
        }
        if (cl != null) {
            return new ContextImpl.ClassLoaderContext(Utility.setContextClassLoader(cl), true);
        }
        return new ContextImpl.ClassLoaderContext(null, false);
    }

    public ClassLoader getInvocationClassLoader() {
        JndiNameEnvironment componentEnv = this.compEnvMgr.getCurrentJndiNameEnvironment();
        return this.getClassLoaderForEnvironment(componentEnv);
    }

    public void setInstanceContext() {
        this.instanceComponentId = null;
        this.doSetInstanceContext();
    }

    public void setEmptyInvocation() {
        this.instanceComponentId = EMPTY_COMPONENT;
        this.capturedInvocation = this.createInvocation(null);
    }

    public String getInvocationComponentId() {
        ComponentInvocation inv = this.serverContext.getInvocationManager().getCurrentInvocation();
        return inv != null ? inv.getComponentId() : null;
    }

    public JavaEEContextUtil setInstanceComponentId(String componentId) {
        this.instanceComponentId = componentId;
        if (componentId != null) {
            this.createInvocationContext();
        } else {
            this.capturedInvocation = null;
        }
        return this;
    }

    private void doSetInstanceContext() {
        this.capturedInvocation = this.serverContext.getInvocationManager().getCurrentInvocation();
        if (this.capturedInvocation != null) {
            this.capturedInvocation = this.capturedInvocation.clone();
            this.instanceComponentId = this.capturedInvocation.getComponentId();
        } else if (this.instanceComponentId != null) {
            this.createInvocationContext();
        }
    }

    private ClassLoader getClassLoaderForEnvironment(JndiNameEnvironment componentEnv) {
        if (componentEnv instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)componentEnv;
            return bd.getClassLoader();
        }
        if (componentEnv instanceof EjbDescriptor) {
            EjbDescriptor ed = (EjbDescriptor)componentEnv;
            return ed.getEjbBundleDescriptor().getClassLoader();
        }
        return null;
    }

    private void createInvocationContext() {
        JndiNameEnvironment jndiEnv = this.compEnvMgr.getJndiNameEnvironment(this.instanceComponentId);
        this.capturedInvocation = jndiEnv != null ? this.createInvocation(jndiEnv) : null;
    }

    private ComponentInvocation createInvocation(JndiNameEnvironment jndiEnv) {
        ComponentInvocation newInvocation = new ComponentInvocation();
        newInvocation.componentId = this.instanceComponentId;
        newInvocation.setJNDIEnvironment((Object)jndiEnv);
        newInvocation.setComponentInvocationType(ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION);
        return newInvocation;
    }
}

