/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.web.LogFacade;

public class LoginConfigurationImpl
extends Descriptor
implements LoginConfiguration {
    static final Logger _logger = LogFacade.getLogger();
    public static final String AUTHENTICATION_METHOD_BASIC = "BASIC";
    public static final String AUTHENTICATION_METHOD_DIGEST = "DIGEST";
    public static final String AUTHENTICATION_METHOD_FORM = "FORM";
    public static final String AUTHENTICATION_METHOD_CLIENT_CERTIFICATE = "CLIENT-CERT";
    private String authenticationMethod;
    private String realmName = "";
    private String formLoginPage = "";
    private String formErrorPage = "";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoginConfigurationImpl.class);

    public String getAuthenticationMethod() {
        if (this.authenticationMethod == null) {
            _logger.log(Level.WARNING, "AS-WEB-GLUE-00277");
            this.authenticationMethod = AUTHENTICATION_METHOD_BASIC;
        }
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        if (!(!this.isBoundsChecking() || AUTHENTICATION_METHOD_BASIC.equals(authenticationMethod) || AUTHENTICATION_METHOD_DIGEST.equals(authenticationMethod) || AUTHENTICATION_METHOD_FORM.equals(authenticationMethod) || AUTHENTICATION_METHOD_CLIENT_CERTIFICATE.equals(authenticationMethod))) {
            throw new IllegalArgumentException(MessageFormat.format(_logger.getResourceBundle().getString("AS-WEB-GLUE-00278"), authenticationMethod));
        }
        this.authenticationMethod = authenticationMethod;
    }

    public String getRealmName() {
        if (this.realmName == null) {
            this.realmName = "";
        }
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getFormLoginPage() {
        if (this.formLoginPage == null) {
            this.formLoginPage = "";
        }
        return this.formLoginPage;
    }

    public void setFormLoginPage(String formLoginPage) {
        this.formLoginPage = formLoginPage;
    }

    public String getFormErrorPage() {
        if (this.formErrorPage == null) {
            this.formErrorPage = "";
        }
        return this.formErrorPage;
    }

    public void setFormErrorPage(String formErrorPage) {
        this.formErrorPage = formErrorPage;
    }

    public void print(StringBuilder toStringBuilder) {
        toStringBuilder.append("LoginConfig:(").append(this.authenticationMethod).append(" ").append(this.realmName).append(" ").append(this.formLoginPage).append(" ").append(this.formErrorPage).append(")");
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof LoginConfigurationImpl) {
            LoginConfigurationImpl other = (LoginConfigurationImpl)((Object)obj);
            result = this.getAuthenticationMethod().equals(other.getAuthenticationMethod()) && this.getRealmName().equals(other.getRealmName()) && this.getFormLoginPage().equals(other.getFormLoginPage()) && this.getFormErrorPage().equals(other.getFormErrorPage());
        }
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.getAuthenticationMethod().hashCode();
        if (this.getRealmName().length() > 0) {
            hashCode = 31 * hashCode + this.getRealmName().hashCode();
        }
        if (this.getFormLoginPage().length() > 0) {
            hashCode = 31 * hashCode + this.getFormLoginPage().hashCode();
        }
        if (this.getFormErrorPage().length() > 0) {
            hashCode = 31 * hashCode + this.getFormErrorPage().hashCode();
        }
        return hashCode;
    }
}

