/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandLockException;
import org.glassfish.api.admin.AdminCommandLockTimeoutException;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AdminCommandLock {
    @Inject
    Logger logger;
    private static final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private String lockOwner = null;
    private Date lockTimeOfAcquisition = null;

    public Lock getLock(CommandLock.LockType type) {
        if (type == CommandLock.LockType.SHARED) {
            return rwlock.readLock();
        }
        if (type == CommandLock.LockType.EXCLUSIVE) {
            return rwlock.writeLock();
        }
        return null;
    }

    public void dumpState(Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            logger.log(level, "Current locking conditions are " + rwlock.getReadLockCount() + "/" + rwlock.getReadHoldCount() + " shared locksand " + rwlock.getWriteHoldCount() + " write lock");
        }
    }

    public Lock getLock(AdminCommand command) {
        CommandLock alock = command.getClass().getAnnotation(CommandLock.class);
        if (alock == null || alock.value() == CommandLock.LockType.SHARED) {
            return rwlock.readLock();
        }
        if (alock.value() == CommandLock.LockType.EXCLUSIVE) {
            return rwlock.writeLock();
        }
        return null;
    }

    public Lock getLock(AdminCommand command, String owner) throws AdminCommandLockTimeoutException, AdminCommandLockException {
        Lock lock = null;
        boolean exclusive = false;
        int timeout = 30;
        CommandLock alock = command.getClass().getAnnotation(CommandLock.class);
        if (alock == null || alock.value() == CommandLock.LockType.SHARED) {
            lock = rwlock.readLock();
        } else if (alock.value() == CommandLock.LockType.EXCLUSIVE) {
            lock = rwlock.writeLock();
            exclusive = true;
        }
        if (lock == null) {
            return null;
        }
        boolean badTimeOutValue = false;
        String timeout_s = System.getProperty("com.sun.aas.commandLockTimeOut", "30");
        try {
            timeout = Integer.parseInt(timeout_s);
            if (timeout < 0) {
                badTimeOutValue = true;
            }
        }
        catch (NumberFormatException e) {
            badTimeOutValue = true;
        }
        if (badTimeOutValue) {
            this.logger.log(Level.INFO, "Bad value com.sun.aas.commandLockTimeOut: " + timeout_s + ". Using 30 seconds.");
            timeout = 30;
        }
        boolean lockAcquired = false;
        while (!lockAcquired) {
            try {
                if (lock.tryLock(timeout, TimeUnit.SECONDS)) {
                    lockAcquired = true;
                    continue;
                }
                throw new AdminCommandLockTimeoutException("timeout acquiring lock", this.getLockTimeOfAcquisition(), this.getLockOwner());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted acquiring command lock. ", e);
            }
        }
        if (lockAcquired && exclusive) {
            this.setLockOwner(owner);
            this.setLockTimeOfAcquisition(new Date());
        }
        return lock;
    }

    private void setLockOwner(String owner) {
        this.lockOwner = owner;
    }

    public synchronized String getLockOwner() {
        return this.lockOwner;
    }

    private void setLockTimeOfAcquisition(Date time) {
        this.lockTimeOfAcquisition = time;
    }

    public synchronized Date getLockTimeOfAcquisition() {
        return this.lockTimeOfAcquisition;
    }
}

