/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.event;

import org.glassfish.api.event.EventTypes;

public interface EventListener {
    public void event(Event<?> var1);

    public static class Event<T> {
        final long inception;
        final EventTypes<T> type;
        final T hook;

        public Event(EventTypes<T> type) {
            if (type.getHookType() != null) {
                throw new IllegalArgumentException("Null event hook [" + type.getHookType() + "]");
            }
            this.inception = System.currentTimeMillis();
            this.type = type;
            this.hook = null;
        }

        public Event(EventTypes<T> type, T hook) {
            this.inception = System.currentTimeMillis();
            this.type = type;
            this.hook = hook;
        }

        public long inception() {
            return this.inception;
        }

        public String name() {
            return this.type.type();
        }

        public boolean is(EventTypes<?> type) {
            return type == this.type;
        }

        public T hook() {
            return this.type.getHookType().cast(this.hook);
        }

        public EventTypes<T> type() {
            return this.type;
        }
    }
}

