/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.invocation;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.invocation.ResourceHandler;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@PerLookup
@Service
public class ComponentInvocation
implements Cloneable {
    private ComponentInvocationType invocationType = ComponentInvocationType.UN_INITIALIZED;
    private boolean preInvokeDoneStatus;
    private Boolean auth;
    public Object instance;
    private String instanceName;
    public Object container;
    public Object jndiEnvironment;
    public String componentId;
    public Object transaction;
    private boolean transactionCompleting;
    private Object transactionOperationsManager;
    public Object oldSecurityContext;
    private Object resourceTableKey;
    private ResourceHandler resourceHandler;
    private Map<Class<?>, Object> registry;
    protected String appName;
    protected String moduleName;
    protected String registrationName;

    public ComponentInvocation() {
    }

    public ComponentInvocation(String componentId, ComponentInvocationType invocationType, Object container, String appName, String moduleName, String registrationName) {
        this.componentId = componentId;
        this.invocationType = invocationType;
        this.container = container;
        this.appName = appName;
        this.moduleName = moduleName;
        this.registrationName = registrationName;
    }

    public ComponentInvocation(String componentId, ComponentInvocationType invocationType, Object instance, Object container, Object transaction) {
        this.componentId = componentId;
        this.invocationType = invocationType;
        this.instance = instance;
        this.container = container;
        this.transaction = transaction;
    }

    public ComponentInvocationType getInvocationType() {
        return this.invocationType;
    }

    public void setInvocationType(ComponentInvocationType invocationType) {
        this.invocationType = invocationType;
    }

    public void setComponentInvocationType(ComponentInvocationType t) {
        this.invocationType = t;
    }

    public boolean isPreInvokeDone() {
        return this.preInvokeDoneStatus;
    }

    public void setPreInvokeDone(boolean value) {
        this.preInvokeDoneStatus = value;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public void setAuth(boolean value) {
        this.auth = value;
    }

    public boolean isPreInvokeDoneStatus() {
        return this.preInvokeDoneStatus;
    }

    public void setPreInvokeDoneStatus(boolean preInvokeDoneStatus) {
        this.preInvokeDoneStatus = preInvokeDoneStatus;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public Object getJndiEnvironment() {
        return this.jndiEnvironment;
    }

    public void setJndiEnvironment(Object jndiEnvironment) {
        this.jndiEnvironment = jndiEnvironment;
    }

    public void setJNDIEnvironment(Object val) {
        this.jndiEnvironment = val;
    }

    public Object getJNDIEnvironment() {
        return this.jndiEnvironment;
    }

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public Object getContainerContext() {
        return this.container;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Object t) {
        this.transaction = t;
    }

    public void setTransactionCompleting(boolean transactionCompleting) {
        this.transactionCompleting = transactionCompleting;
    }

    public Map<Class<?>, Object> getRegistry() {
        return this.registry;
    }

    public void setRegistry(Map<Class<?>, Object> registry) {
        this.registry = registry;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getRegistrationName() {
        return this.registrationName;
    }

    public void setRegistrationName(String registrationName) {
        this.registrationName = registrationName;
    }

    public void setTransactionOperationsManager(Object transactionOperationsManager) {
        this.transactionOperationsManager = transactionOperationsManager;
    }

    public Object getTransactionOperationsManager() {
        return this.transactionOperationsManager;
    }

    public void setOldSecurityContext(Object sc) {
        this.oldSecurityContext = sc;
    }

    public Object getOldSecurityContext() {
        return this.oldSecurityContext;
    }

    public boolean isTransactionCompleting() {
        return this.transactionCompleting;
    }

    public void setTransactionCompeting(boolean value) {
        this.transactionCompleting = value;
    }

    public void setResourceTableKey(Object key) {
        this.resourceTableKey = key;
    }

    public Object getResourceTableKey() {
        return this.resourceTableKey;
    }

    public void setResourceHandler(ResourceHandler h) {
        this.resourceHandler = h;
    }

    public ResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public Object getRegistryFor(Class key) {
        if (this.registry == null) {
            return null;
        }
        return this.registry.get(key);
    }

    public void setRegistryFor(Class key, Object payLoad) {
        if (this.registry == null) {
            this.registry = new HashMap();
        }
        this.registry.put(key, payLoad);
    }

    public void clearRegistry() {
        if (this.registry != null) {
            this.registry.clear();
        }
    }

    public ComponentInvocation clone() {
        ComponentInvocation newInv = null;
        try {
            newInv = (ComponentInvocation)super.clone();
        }
        catch (CloneNotSupportedException cnsEx) {
            throw new Error(cnsEx);
        }
        newInv.auth = null;
        newInv.preInvokeDoneStatus = false;
        newInv.instance = null;
        newInv.transaction = null;
        newInv.transactionCompleting = false;
        return newInv;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(Integer.toHexString(System.identityHashCode(this))).append('@').append(this.getClass().getName()).append('\n');
        str.append("\tcomponentId=").append(this.componentId).append('\n');
        str.append("\ttype=").append((Object)this.invocationType).append('\n');
        str.append("\tinstance=").append(this.instanceName != null ? this.instanceName : String.valueOf(this.instance)).append('\n');
        str.append("\tcontainer=").append(this.container).append('\n');
        str.append("\tappName=").append(this.appName).append('\n');
        return str.toString();
    }

    public static enum ComponentInvocationType {
        SERVLET_INVOCATION,
        EJB_INVOCATION,
        APP_CLIENT_INVOCATION,
        UN_INITIALIZED,
        SERVICE_STARTUP;

    }
}

