/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics;

import fish.payara.microprofile.metrics.MetricUnitsUtils;
import fish.payara.microprofile.metrics.admin.MetricsServiceConfiguration;
import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import fish.payara.microprofile.metrics.impl.MetricRegistrationListener;
import fish.payara.microprofile.metrics.impl.MetricRegistryImpl;
import fish.payara.microprofile.metrics.jmx.MBeanMetadata;
import fish.payara.microprofile.metrics.jmx.MBeanMetadataConfig;
import fish.payara.microprofile.metrics.jmx.MBeanMetadataHelper;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.JAXB;
import org.eclipse.microprofile.metrics.Counting;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="microprofile-metrics-service")
@RunLevel(value=10)
public class MetricsService
implements ConfigListener,
MonitoringDataSource {
    private static final Logger LOGGER = Logger.getLogger(MetricsService.class.getName());
    @Inject
    MetricsServiceConfiguration configuration;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    private MBeanMetadataHelper helper;
    private MetricsServiceConfiguration metricsServiceConfiguration;
    private Boolean metricsEnabled;
    private Boolean metricsSecure;
    private List<MBeanMetadata> unresolvedBaseMetadataList;
    private List<MBeanMetadata> unresolvedVendorMetadataList;
    private final Map<String, MetricRegistryState> registriesByName = new ConcurrentHashMap<String, MetricRegistryState>();

    @PostConstruct
    public void init() {
        this.metricsServiceConfiguration = (MetricsServiceConfiguration)this.serviceLocator.getService(MetricsServiceConfiguration.class, new Annotation[0]);
        if (this.isEnabled().booleanValue()) {
            PayaraExecutorService payaraExecutor = (PayaraExecutorService)this.serviceLocator.getService(PayaraExecutorService.class, new Annotation[0]);
            payaraExecutor.submit(() -> this.bootstrap());
        }
    }

    public void collect(MonitoringDataCollector rootCollector) {
        if (!this.isEnabled().booleanValue()) {
            return;
        }
        MonitoringDataCollector metricsCollector = rootCollector.in((CharSequence)"metric");
        for (MetricRegistryState state : this.registriesByName.values()) {
            MetricsService.collectRegistry(state, metricsCollector);
        }
    }

    private static void collectRegistry(MetricRegistryState state, MonitoringDataCollector collector) {
        MetricsService.processMetadataToAnnotations(state, collector);
        for (String name : state.registry.getNames()) {
            for (Map.Entry<MetricID, Metric> entry : state.registry.getMetrics(name).entrySet()) {
                Object value;
                MetricID metricID = entry.getKey();
                Metric metric = entry.getValue();
                MonitoringDataCollector metricCollector = MetricsService.tagCollector(metricID, collector);
                if (metric instanceof Counting) {
                    metricCollector.collect((CharSequence)MetricsService.toName(metricID, "Count"), ((Counting)((Object)metric)).getCount());
                }
                if (metric instanceof SimpleTimer) {
                    metricCollector.collect((CharSequence)MetricsService.toName(metricID, "Duration"), ((SimpleTimer)metric).getElapsedTime().toMillis());
                }
                if (metric instanceof Timer) {
                    metricCollector.collect((CharSequence)MetricsService.toName(metricID, "MaxDuration"), ((Timer)metric).getSnapshot().getMax());
                }
                if (!(metric instanceof Gauge) || !((value = ((Gauge)metric).getValue()) instanceof Number)) continue;
                metricCollector.collect((CharSequence)MetricsService.toName(metricID, MetricsService.getMetricUnitSuffix(state.registry.getMetadata(name).getUnit())), (Number)value);
            }
        }
    }

    private static void processMetadataToAnnotations(MetricRegistryState state, MonitoringDataCollector collector) {
        MetricID metricID = state.registeredNotAnnotated.poll();
        while (metricID != null) {
            boolean isGauge;
            MonitoringDataCollector metricCollector = MetricsService.tagCollector(metricID, collector);
            Metadata metadata = state.registry.getMetadata(metricID.getName());
            String suffix = "Count";
            String property = "Count";
            boolean bl = isGauge = metadata.getTypeRaw() == MetricType.GAUGE;
            if (isGauge) {
                suffix = MetricsService.getMetricUnitSuffix(metadata.getUnit());
                property = "Value";
            }
            metricCollector.annotate((CharSequence)MetricsService.toName(metricID, suffix), 0L, false, MetricsService.metadataToAnnotations(state.registryName, metadata, property));
            metricID = state.registeredNotAnnotated.poll();
        }
    }

    private static String getMetricUnitSuffix(Optional<String> unit) {
        if (!unit.isPresent()) {
            return "";
        }
        String value = unit.get();
        if ("none".equalsIgnoreCase(value) || value.isEmpty()) {
            return "";
        }
        return MetricsService.toFirstLetterUpperCase(value);
    }

    private static String toFirstLetterUpperCase(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    private static String[] metadataToAnnotations(String registryName, Metadata metadata, String property) {
        String unit = metadata.getUnit().orElse("none");
        return new String[]{"App", registryName, "Name", metadata.getName(), "Type", metadata.getType(), "Unit", unit, "DisplayName", metadata.getDisplayName(), "Description", metadata.getDescription().orElse(""), "Property", property, "BaseUnit", MetricUnitsUtils.baseUnit(unit), "ScaleToBaseUnit", MetricUnitsUtils.scaleToBaseUnit((Number)1L, unit).toString()};
    }

    private static String toName(MetricID metric, String suffix) {
        String name = metric.getName();
        if (name.indexOf(32) >= 0) {
            name = name.replace(' ', '_');
        } else {
            int dotIndex = name.indexOf(46);
            if (dotIndex > 0) {
                name = name.substring(dotIndex + 1);
            }
            if (name.indexOf(46) > 0) {
                String[] words = name.split("\\.");
                name = "";
                for (String word : words) {
                    name = name + MetricsService.toFirstLetterUpperCase(word);
                }
            }
        }
        name = MetricsService.toFirstLetterUpperCase(name);
        return name.endsWith(suffix) || suffix.isEmpty() ? name : name + suffix;
    }

    private static MonitoringDataCollector tagCollector(MetricID metric, MonitoringDataCollector collector) {
        Map<String, String> tags = metric.getTags();
        if (tags.isEmpty()) {
            String name = metric.getName();
            int dotIndex = name.indexOf(46);
            if (dotIndex > 0) {
                return collector.group((CharSequence)name.substring(0, dotIndex));
            }
            return collector;
        }
        StringBuilder tag = new StringBuilder();
        for (Map.Entry<String, String> e : metric.getTags().entrySet()) {
            if (tag.length() > 0) {
                tag.append('_');
            }
            if (!"name".equals(e.getKey())) {
                tag.append(e.getKey().replace(' ', '_'));
            }
            tag.append(e.getValue().replace(' ', '_'));
        }
        return collector.group((CharSequence)tag);
    }

    private static void checkSystemCpuLoadIssue(MBeanMetadataConfig metadataConfig) {
        String mbeanSystemCPULoad = "java.lang:type=OperatingSystem/SystemCpuLoad";
        long count = metadataConfig.getBaseMetadata().stream().map(MBeanMetadata::getMBean).filter(mbeanSystemCPULoad::equalsIgnoreCase).count();
        if ((count += metadataConfig.getVendorMetadata().stream().map(MBeanMetadata::getMBean).filter(mbeanSystemCPULoad::equalsIgnoreCase).count()) > 1L) {
            LOGGER.warning(String.format("Referencing the MBean value %s multiple times possibly leads to inconsistent values for the MBean value.", mbeanSystemCPULoad));
        }
    }

    private void initMetadataConfig(List<MBeanMetadata> baseMetadataList, List<MBeanMetadata> vendorMetadataList, boolean isRetry) {
        if (!baseMetadataList.isEmpty()) {
            this.unresolvedBaseMetadataList = this.helper.registerMetadata(this.getOrAddRegistry(MetricRegistry.Type.BASE.getName()), baseMetadataList, isRetry);
        }
        if (!vendorMetadataList.isEmpty()) {
            this.unresolvedVendorMetadataList = this.helper.registerMetadata(this.getOrAddRegistry(MetricRegistry.Type.VENDOR.getName()), vendorMetadataList, isRetry);
        }
    }

    public void reregisterMetadataConfig() {
        if (this.unresolvedBaseMetadataList == null || this.unresolvedVendorMetadataList == null) {
            this.bootstrap();
        } else {
            this.initMetadataConfig(this.unresolvedBaseMetadataList, this.unresolvedVendorMetadataList, true);
        }
    }

    private MBeanMetadataConfig getConfig() {
        InputStream defaultConfig = MetricsService.class.getResourceAsStream("/metrics.xml");
        MBeanMetadataConfig config = (MBeanMetadataConfig)JAXB.unmarshal((InputStream)defaultConfig, MBeanMetadataConfig.class);
        File metricsResource = new File(this.serverEnv.getConfigDirPath(), "metrics.xml");
        if (metricsResource.exists()) {
            try {
                FileInputStream userMetrics = new FileInputStream(metricsResource);
                MBeanMetadataConfig extraConfig = (MBeanMetadataConfig)JAXB.unmarshal((InputStream)userMetrics, MBeanMetadataConfig.class);
                config.addBaseMetadata(extraConfig.getBaseMetadata());
                config.addVendorMetadata(extraConfig.getVendorMetadata());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return config;
    }

    public Boolean isEnabled() {
        if (this.metricsEnabled == null) {
            this.metricsEnabled = Boolean.valueOf(this.metricsServiceConfiguration.getEnabled());
        }
        return this.metricsEnabled;
    }

    public void resetMetricsEnabledProperty() {
        this.metricsEnabled = null;
    }

    public Boolean isMetricsSecure() {
        if (this.metricsSecure == null) {
            this.metricsSecure = Boolean.valueOf(this.metricsServiceConfiguration.getSecureMetrics());
        }
        return this.metricsSecure;
    }

    public void resetMetricsSecureProperty() {
        this.metricsSecure = null;
    }

    public boolean isSecurityEnabled() {
        return Boolean.parseBoolean(this.metricsServiceConfiguration.getSecurityEnabled());
    }

    public <T extends Metric> T getApplicationMetric(MetricID metricID, Class<T> type) {
        return this.getOrAddRegistryInternal(this.getApplicationName()).getMetric(metricID, type);
    }

    public Set<MetricID> getMetricsIDs(String registryName, String metricName) throws NoSuchRegistryException {
        return this.getRegistryInternal(registryName).getMetricsIDs(metricName);
    }

    public MetricRegistry getRegistry(String registryName) throws NoSuchRegistryException {
        return this.getRegistryInternal(registryName);
    }

    private MetricRegistryImpl getRegistryInternal(String registryName) throws NoSuchRegistryException {
        MetricRegistryState state = this.registriesByName.get(registryName.toLowerCase());
        if (state == null) {
            throw new NoSuchRegistryException(registryName);
        }
        return state.registry;
    }

    public List<MetricRegistry> getAllRegistry() {
        ArrayList<MetricRegistry> metricRegistries = new ArrayList<MetricRegistry>();
        this.registriesByName.values().forEach(entry -> metricRegistries.add(entry.registry));
        return metricRegistries;
    }

    public Set<String> getAllRegistryNames() {
        return this.registriesByName.keySet();
    }

    public MetricRegistry getOrAddRegistry(String registryName) {
        return this.getOrAddRegistryInternal(registryName);
    }

    private MetricRegistryImpl getOrAddRegistryInternal(String registryName) {
        return this.registriesByName.computeIfAbsent((String)registryName.toLowerCase(), (Function<String, MetricRegistryState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getOrAddRegistryInternal$2(java.lang.String java.lang.String ), (Ljava/lang/String;)Lfish/payara/microprofile/metrics/MetricsService$MetricRegistryState;)((String)registryName)).registry;
    }

    public MetricRegistry getApplicationRegistry() {
        return this.getOrAddRegistry(this.getApplicationName());
    }

    public MetricRegistry removeRegistry(String registryName) {
        MetricRegistryState state = this.registriesByName.remove(registryName.toLowerCase());
        return state == null ? null : state.registry;
    }

    public void registerApplication(String applicationName) {
        this.getOrAddRegistry(applicationName);
    }

    public void deregisterApplication(String applicationName) {
        this.removeRegistry(applicationName);
    }

    public String getApplicationName() {
        InvocationManager invocationManager = (InvocationManager)Globals.getDefaultBaseServiceLocator().getService(InvocationManager.class, new Annotation[0]);
        ComponentInvocation current = invocationManager.getCurrentInvocation();
        if (current == null) {
            return invocationManager.peekAppEnvironment().getName();
        }
        String appName = current.getAppName();
        if (appName == null) {
            appName = current.getModuleName();
        }
        if (appName == null) {
            appName = current.getComponentId();
        }
        return appName;
    }

    private void bootstrap() {
        MBeanMetadataConfig metadataConfig = this.getConfig();
        MetricsService.checkSystemCpuLoadIssue(metadataConfig);
        this.initMetadataConfig(metadataConfig.getBaseMetadata(), metadataConfig.getVendorMetadata(), false);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unchangedList = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            unchangedList.add(new UnprocessedChangeEvent(event, "Microprofile Metrics configuration changed:" + event.getPropertyName() + " was changed from " + event.getOldValue().toString() + " to " + event.getNewValue().toString()));
        }
        return new UnprocessedChangeEvents(unchangedList);
    }

    private static /* synthetic */ MetricRegistryState lambda$getOrAddRegistryInternal$2(String registryName, String key) {
        return new MetricRegistryState(registryName);
    }

    private static final class MetricRegistryState
    implements MetricRegistrationListener {
        final String registryName;
        final MetricRegistryImpl registry = new MetricRegistryImpl();
        final Queue<MetricID> registeredNotAnnotated = new ConcurrentLinkedQueue<MetricID>();

        public MetricRegistryState(String registryName) {
            this.registryName = registryName;
            this.registry.addListener(this);
        }

        @Override
        public void onRegistration(MetricID registered, MetricRegistry registry) {
            this.registeredNotAnnotated.add(registered);
        }
    }
}

