/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public final class MetricUtils<T extends Metric> {
    private static final Map<Class<? extends Metric>, MetricUtils<?>> TYPES = new HashMap();
    private final ByJust<String, T> byName;
    private final By<String, Tag[], T> byNameAndTags;
    private final By<Metadata, Tag[], T> byMetadataAndTags;

    private MetricUtils(ByJust<String, T> byName, By<String, Tag[], T> byNameAndTags, By<Metadata, Tag[], T> byMetadataAndTags) {
        this.byName = byName;
        this.byNameAndTags = byNameAndTags;
        this.byMetadataAndTags = byMetadataAndTags;
    }

    static <T extends Metric> void register(Class<T> type, ByJust<String, T> byName, By<String, Tag[], T> byNameAndTags, By<Metadata, Tag[], T> byMetadataAndTags) {
        TYPES.put(type, new MetricUtils<T>(byName, byNameAndTags, byMetadataAndTags));
    }

    public static <T extends Metric> T getOrRegisterByName(MetricRegistry registry, Class<T> metric, String name) {
        return (T)((Metric)MetricUtils.getOrRegister(metric).byName.apply(registry, name));
    }

    public static <T extends Metric> T getOrRegisterByNameAndTags(MetricRegistry registry, Class<T> metric, String name, Tag ... tags) {
        return (T)((Metric)MetricUtils.getOrRegister(metric).byNameAndTags.apply(registry, name, tags));
    }

    public static <T extends Metric> T getOrRegisterByMetadataAndTags(MetricRegistry registry, Class<T> metric, Metadata metadata, Tag ... tags) {
        return (T)((Metric)MetricUtils.getOrRegister(metric).byMetadataAndTags.apply(registry, metadata, tags));
    }

    private static <T extends Metric> MetricUtils<?> getOrRegister(Class<T> metric) {
        MetricUtils<?> getOrRegister = TYPES.get(metric);
        if (getOrRegister == null) {
            throw new IllegalArgumentException("Cannot get or register metrics of type " + metric);
        }
        return getOrRegister;
    }

    private static Gauge<?> getGauge(MetricRegistry registry, String name) {
        return MetricUtils.getGauge(registry, name, new Tag[0]);
    }

    private static Gauge<?> getGauge(MetricRegistry registry, Metadata metadata, Tag[] tags) {
        return MetricUtils.getGauge(registry, metadata.getName(), tags);
    }

    private static Gauge<?> getGauge(MetricRegistry registry, String name, Tag[] tags) {
        MetricID metricID = new MetricID(name, tags);
        Gauge gauge = (Gauge)registry.getGauges().get(metricID);
        return gauge != null ? gauge : new LazyGauge(() -> (Gauge)registry.getGauges().get(metricID));
    }

    static {
        MetricUtils.register(Counter.class, MetricRegistry::counter, MetricRegistry::counter, MetricRegistry::counter);
        MetricUtils.register(ConcurrentGauge.class, MetricRegistry::concurrentGauge, MetricRegistry::concurrentGauge, MetricRegistry::concurrentGauge);
        MetricUtils.register(Histogram.class, MetricRegistry::histogram, MetricRegistry::histogram, MetricRegistry::histogram);
        MetricUtils.register(Meter.class, MetricRegistry::meter, MetricRegistry::meter, MetricRegistry::meter);
        MetricUtils.register(Timer.class, MetricRegistry::timer, MetricRegistry::timer, MetricRegistry::timer);
        MetricUtils.register(SimpleTimer.class, MetricRegistry::simpleTimer, MetricRegistry::simpleTimer, MetricRegistry::simpleTimer);
        MetricUtils.register(Gauge.class, MetricUtils::getGauge, MetricUtils::getGauge, MetricUtils::getGauge);
    }

    private static final class LazyGauge<T>
    implements Gauge<T> {
        private final AtomicReference<Gauge<T>> gauge = new AtomicReference();
        private final Supplier<Gauge<T>> lookup;

        LazyGauge(Supplier<Gauge<T>> lookup) {
            this.lookup = lookup;
        }

        @Override
        public T getValue() {
            Gauge<T> lazy = this.gauge.updateAndGet(instance -> instance != null ? instance : this.lookup.get());
            return lazy == null ? null : (T)lazy.getValue();
        }
    }

    @FunctionalInterface
    private static interface ByJust<A, R> {
        public R apply(MetricRegistry var1, A var2);
    }

    @FunctionalInterface
    private static interface By<A, B, R> {
        public R apply(MetricRegistry var1, A var2, B var3);
    }
}

