/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.ConcurrentGauge;

@Vetoed
public class ConcurrentGaugeImpl
implements ConcurrentGauge {
    private final AtomicInteger threads = new AtomicInteger();
    private AtomicReference<MinMax> openStats;
    private volatile MinMax closedStats;
    private final Clock clock;

    public ConcurrentGaugeImpl() {
        this(Clock.DEFAULT);
    }

    public ConcurrentGaugeImpl(Clock clock) {
        this.clock = clock;
        this.openStats = new AtomicReference<MinMax>(new MinMax(0L, this.getCurrentMinute()));
        this.closedStats = new MinMax(0L, this.getCurrentMinute());
    }

    @Override
    public void inc() {
        this.threads.incrementAndGet();
        this.currentStats().updateMax(this.threads.longValue());
    }

    @Override
    public void dec() {
        this.threads.decrementAndGet();
        this.currentStats().updateMin(this.threads.longValue());
    }

    @Override
    public long getCount() {
        return this.threads.get();
    }

    @Override
    public long getMax() {
        this.currentStats();
        return this.closedStats.max.get();
    }

    @Override
    public long getMin() {
        this.currentStats();
        return this.closedStats.min.get();
    }

    private Instant getCurrentMinute() {
        return Instant.ofEpochMilli(this.clock.getTime()).truncatedTo(ChronoUnit.MINUTES);
    }

    private MinMax currentStats() {
        Instant now = this.getCurrentMinute();
        MinMax possiblyOutdated = this.openStats.getAndUpdate(value -> value.markIfOld(now) ? new MinMax(this.threads.longValue(), now) : value);
        if (possiblyOutdated.finished.get()) {
            this.closedStats = possiblyOutdated;
            return this.openStats.get();
        }
        return possiblyOutdated;
    }

    private static class MinMax {
        final AtomicLong min;
        final AtomicLong max;
        final Instant minute;
        final AtomicBoolean finished = new AtomicBoolean(false);

        MinMax(long initialValue, Instant minute) {
            this.min = new AtomicLong(initialValue);
            this.max = new AtomicLong(initialValue);
            this.minute = minute;
        }

        boolean markIfOld(Instant now) {
            return !now.equals(this.minute) && this.finished.compareAndSet(false, true);
        }

        void updateMin(long value) {
            this.min.accumulateAndGet(value, Math::min);
        }

        void updateMax(long value) {
            this.max.accumulateAndGet(value, Math::max);
        }
    }
}

