/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.SimpleTimer;

@Vetoed
public class SimpleTimerImpl
implements SimpleTimer {
    private final AtomicLong callCount = new AtomicLong();
    private final AtomicLong totalDurationNanos = new AtomicLong();
    private final Clock clock;

    public SimpleTimerImpl(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void update(Duration duration) {
        this.totalDurationNanos.addAndGet(duration.toNanos());
        this.callCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    @Override
    public SimpleTimer.Context time() {
        return new Context(this, this.clock);
    }

    @Override
    public Duration getElapsedTime() {
        return Duration.ofNanos(this.totalDurationNanos.get());
    }

    @Override
    public long getCount() {
        return this.callCount.get();
    }

    private static final class Context
    implements SimpleTimer.Context {
        private final SimpleTimer timer;
        private final Clock clock;
        private final long startTime;

        Context(SimpleTimer timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        @Override
        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

