/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;

public interface MetricExporter {
    public static final Logger LOGGER = Logger.getLogger(MetricExporter.class.getName());

    public MetricExporter in(MetricRegistry.Type var1, boolean var2);

    default public MetricExporter in(MetricRegistry.Type scope) {
        return this.in(scope, true);
    }

    public void export(MetricID var1, Counter var2, Metadata var3);

    public void export(MetricID var1, ConcurrentGauge var2, Metadata var3);

    public void export(MetricID var1, Gauge<?> var2, Metadata var3);

    public void export(MetricID var1, Histogram var2, Metadata var3);

    public void export(MetricID var1, Meter var2, Metadata var3);

    public void export(MetricID var1, SimpleTimer var2, Metadata var3);

    public void export(MetricID var1, Timer var2, Metadata var3);

    default public void export(MetricID metricID, Metric metric, Metadata metadata) {
        switch (MetricType.from(metric.getClass())) {
            case COUNTER: {
                this.export(metricID, (Counter)metric, metadata);
                break;
            }
            case CONCURRENT_GAUGE: {
                this.export(metricID, (ConcurrentGauge)metric, metadata);
                break;
            }
            case GAUGE: {
                this.export(metricID, (Gauge)metric, metadata);
                break;
            }
            case HISTOGRAM: {
                this.export(metricID, (Histogram)metric, metadata);
                break;
            }
            case METERED: {
                this.export(metricID, (Meter)metric, metadata);
                break;
            }
            case SIMPLE_TIMER: {
                this.export(metricID, (SimpleTimer)metric, metadata);
                break;
            }
            case TIMER: {
                this.export(metricID, (Timer)metric, metadata);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Metric type {0} for {1} is not supported", new Object[]{metric.getClass(), metricID});
            }
        }
    }

    public void exportComplete();
}

