/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import fish.payara.microprofile.metrics.exception.NoSuchMetricException;
import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import fish.payara.microprofile.metrics.impl.MetricRegistryImpl;
import fish.payara.microprofile.metrics.writer.MetricExporter;
import fish.payara.microprofile.metrics.writer.MetricsWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MetricsWriterImpl
implements MetricsWriter {
    private final MetricExporter exporter;
    private final Supplier<Set<String>> registryNames;
    private final Function<String, MetricRegistry> getMetricsRegistryByName;

    public MetricsWriterImpl(MetricExporter exporter, Supplier<Set<String>> registryNames, Function<String, MetricRegistry> getMetricsRegistryByName) {
        this.exporter = exporter;
        this.registryNames = registryNames;
        this.getMetricsRegistryByName = getMetricsRegistryByName;
    }

    @Override
    public void write(MetricRegistry.Type scope, String metricName) throws NoSuchRegistryException, NoSuchMetricException {
        MetricExporter exporter = this.exporter.in(scope, false);
        if (scope == MetricRegistry.Type.APPLICATION) {
            this.writeApplicationRegistries(exporter, this.registryNames.get(), metricName);
        } else {
            String registryName = scope.getName();
            MetricsWriterImpl.writeMetricFamily(exporter, registryName, metricName, this.getMetricsRegistry(registryName), false);
        }
        exporter.exportComplete();
    }

    @Override
    public void write(MetricRegistry.Type scope) throws NoSuchRegistryException {
        MetricExporter exporter = this.exporter.in(scope, false);
        if (scope == MetricRegistry.Type.APPLICATION) {
            this.writeApplicationRegistries(exporter, this.registryNames.get(), new String[0]);
        } else {
            String registryName = scope.getName();
            MetricsWriterImpl.writeRegistry(exporter, registryName, this.getMetricsRegistry(registryName), false);
        }
        exporter.exportComplete();
    }

    @Override
    public void write() throws IOException {
        Set<String> allNames = this.registryNames.get();
        MetricExporter exporter = this.exporter;
        exporter = exporter.in(MetricRegistry.Type.BASE);
        MetricsWriterImpl.writeRegistry(exporter, MetricRegistry.Type.BASE.getName(), this.getMetricsRegistry(MetricRegistry.Type.BASE.getName()), false);
        exporter = exporter.in(MetricRegistry.Type.VENDOR);
        MetricsWriterImpl.writeRegistry(exporter, MetricRegistry.Type.VENDOR.getName(), this.getMetricsRegistry(MetricRegistry.Type.VENDOR.getName()), false);
        exporter = exporter.in(MetricRegistry.Type.APPLICATION);
        this.writeApplicationRegistries(exporter, allNames, new String[0]);
        exporter.exportComplete();
    }

    private void writeApplicationRegistries(MetricExporter exporter, Set<String> allNames, String ... metricNames) {
        Predicate<String> filter;
        TreeMap<String, MetricRegistryImpl> registries = new TreeMap<String, MetricRegistryImpl>();
        for (String registryName : MetricsWriterImpl.getApplicationRegistryNames(allNames)) {
            registries.put(registryName, this.getMetricsRegistry(registryName));
        }
        HashSet<String> filterNames = new HashSet<String>(Arrays.asList(metricNames));
        Predicate<String> predicate = filter = metricNames.length == 0 ? name -> true : name -> filterNames.contains(name);
        if (!MetricsWriterImpl.hasNameCollisions(registries.values(), filter)) {
            for (Map.Entry registry : registries.entrySet()) {
                MetricsWriterImpl.writeRegistry(exporter, (String)registry.getKey(), (MetricRegistryImpl)registry.getValue(), false);
            }
            return;
        }
        for (String metricName : MetricsWriterImpl.allMetricNames(registries.values(), filter)) {
            for (Map.Entry registry : registries.entrySet()) {
                if (((MetricRegistryImpl)registry.getValue()).getMetadata(metricName) == null) continue;
                MetricsWriterImpl.writeMetricFamily(exporter, (String)registry.getKey(), metricName, (MetricRegistryImpl)registry.getValue(), true);
            }
        }
    }

    private static void writeRegistry(MetricExporter exporter, String registryName, MetricRegistryImpl registry, boolean addAppTag) {
        for (String metricName : registry.getNames()) {
            MetricsWriterImpl.writeMetricFamily(exporter, registryName, metricName, registry, addAppTag);
        }
    }

    private static void writeMetricFamily(MetricExporter exporter, String registryName, String metricName, MetricRegistryImpl registry, boolean addAppTag) {
        Metadata metadata = registry.getMetadata(metricName);
        for (Map.Entry<MetricID, Metric> metric : registry.getMetrics(metricName).entrySet()) {
            MetricID metricID = metric.getKey();
            if (addAppTag) {
                Tag[] tagsWithoutApp = metricID.getTagsAsArray();
                Tag[] tags = Arrays.copyOf(tagsWithoutApp, tagsWithoutApp.length + 1);
                tags[tagsWithoutApp.length] = new Tag("_app", registryName);
                metricID = new MetricID(metricID.getName(), tags);
            }
            exporter.export(metricID, metric.getValue(), metadata);
        }
    }

    private MetricRegistryImpl getMetricsRegistry(String name) {
        return (MetricRegistryImpl)this.getMetricsRegistryByName.apply(name);
    }

    private static Set<String> getApplicationRegistryNames(Set<String> names) {
        TreeSet<String> appNames = new TreeSet<String>(names);
        appNames.remove(MetricRegistry.Type.BASE.getName());
        appNames.remove(MetricRegistry.Type.VENDOR.getName());
        return appNames;
    }

    private static boolean hasNameCollisions(Collection<? extends MetricRegistry> registries, Predicate<String> filter) {
        HashSet<String> allMetricNames = new HashSet<String>();
        for (MetricRegistry metricRegistry : registries) {
            SortedSet<String> names = metricRegistry.getNames();
            for (String name : names) {
                if (!filter.test(name)) continue;
                if (allMetricNames.contains(name)) {
                    return true;
                }
                allMetricNames.add(name);
            }
        }
        return false;
    }

    private static Set<String> allMetricNames(Collection<? extends MetricRegistry> registries, Predicate<String> filter) {
        TreeSet<String> allNames = new TreeSet<String>();
        for (MetricRegistry metricRegistry : registries) {
            for (String metricName : metricRegistry.getNames()) {
                if (!filter.test(metricName)) continue;
                allNames.add(metricName);
            }
        }
        return allNames;
    }
}

