/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import fish.payara.microprofile.metrics.MetricUnitsUtils;
import fish.payara.microprofile.metrics.writer.MetricExporter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.logging.Level;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Sampling;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class OpenMetricsExporter
implements MetricExporter {
    protected final MetricRegistry.Type scope;
    protected final PrintWriter out;
    protected final Set<String> typeWrittenByGlobalName;
    protected final Set<String> helpWrittenByGlobalName;

    public OpenMetricsExporter(Writer out) {
        this(null, out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out), new HashSet<String>(), new HashSet<String>());
    }

    protected OpenMetricsExporter(MetricRegistry.Type scope, PrintWriter out, Set<String> typeWrittenByGlobalName, Set<String> helpWrittenByGlobalName) {
        this.scope = scope;
        this.out = out;
        this.typeWrittenByGlobalName = typeWrittenByGlobalName;
        this.helpWrittenByGlobalName = helpWrittenByGlobalName;
    }

    @Override
    public MetricExporter in(MetricRegistry.Type scope, boolean asNode) {
        return new OpenMetricsExporter(scope, this.out, this.typeWrittenByGlobalName, this.helpWrittenByGlobalName);
    }

    @Override
    public void exportComplete() {
    }

    @Override
    public void export(MetricID metricID, Counter counter, Metadata metadata) {
        String total = this.globalName(metricID, "_total");
        this.appendTYPE(total, OpenMetricsType.counter);
        this.appendHELP(total, metadata);
        this.appendValue(total, metricID.getTagsAsArray(), counter.getCount());
    }

    @Override
    public void export(MetricID metricID, ConcurrentGauge gauge, Metadata metadata) {
        Tag[] tags = metricID.getTagsAsArray();
        String current = this.globalName(metricID, "_current");
        this.appendTYPE(current, OpenMetricsType.gauge);
        this.appendHELP(current, metadata);
        this.appendValue(current, tags, gauge.getCount());
        String min = this.globalName(metricID, "_min");
        this.appendTYPE(min, OpenMetricsType.gauge);
        this.appendValue(min, tags, gauge.getMin());
        String max = this.globalName(metricID, "_max");
        this.appendTYPE(max, OpenMetricsType.gauge);
        this.appendValue(max, tags, gauge.getMax());
    }

    @Override
    public void export(MetricID metricID, Gauge<?> gauge, Metadata metadata) {
        Object value = null;
        try {
            value = gauge.getValue();
        }
        catch (IllegalStateException ex) {
            return;
        }
        if (!(value instanceof Number)) {
            LOGGER.log(Level.FINER, "Skipping OpenMetrics output for Gauge: {0} of type {1}", new Object[]{metricID, value.getClass()});
            return;
        }
        String valueName = this.globalName(metricID, metadata);
        this.appendTYPE(valueName, OpenMetricsType.gauge);
        this.appendHELP(valueName, metadata);
        this.appendValue(valueName, metricID.getTagsAsArray(), MetricUnitsUtils.scaleToBaseUnit((Number)value, metadata));
    }

    @Override
    public void export(MetricID metricID, Histogram histogram, Metadata metadata) {
        this.exportSampling(metricID, histogram, histogram::getCount, metadata);
    }

    private void exportSampling(MetricID metricID, Sampling sampling, LongSupplier count, Metadata metadata) {
        Tag[] tags = metricID.getTagsAsArray();
        Snapshot snapshot = sampling.getSnapshot();
        String mean = this.globalName(metricID, "_mean", metadata);
        this.appendTYPE(mean, OpenMetricsType.gauge);
        this.appendValue(mean, tags, MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getMean(), metadata));
        String max = this.globalName(metricID, "_max", metadata);
        this.appendTYPE(max, OpenMetricsType.gauge);
        this.appendValue(max, tags, MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getMax(), metadata));
        String min = this.globalName(metricID, "_min", metadata);
        this.appendTYPE(min, OpenMetricsType.gauge);
        this.appendValue(min, tags, MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getMin(), metadata));
        String stddev = this.globalName(metricID, "_stddev", metadata);
        this.appendTYPE(stddev, OpenMetricsType.gauge);
        this.appendValue(stddev, tags, MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getStdDev(), metadata));
        String summary = this.globalName(metricID, metadata);
        this.appendTYPE(summary, OpenMetricsType.summary);
        this.appendHELP(summary, metadata);
        this.appendValue(this.globalName(metricID, metadata, "_count"), tags, count.getAsLong());
        this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.5", tags), MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.getMedian(), metadata));
        this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.75", tags), MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.get75thPercentile(), metadata));
        this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.95", tags), MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.get95thPercentile(), metadata));
        this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.98", tags), MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.get98thPercentile(), metadata));
        this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.99", tags), MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.get99thPercentile(), metadata));
        this.appendValue(summary, OpenMetricsExporter.tags("quantile", "0.999", tags), MetricUnitsUtils.scaleToBaseUnit((Number)snapshot.get999thPercentile(), metadata));
    }

    @Override
    public void export(MetricID metricID, Meter meter, Metadata metadata) {
        Tag[] tags = metricID.getTagsAsArray();
        String total = this.globalName(metricID, "_total");
        this.appendTYPE(total, OpenMetricsType.counter);
        this.appendHELP(total, metadata);
        this.appendValue(total, tags, meter.getCount());
        this.exportMetered(metricID, meter);
    }

    private void exportMetered(MetricID metricID, Metered metered) {
        Tag[] tags = metricID.getTagsAsArray();
        String rate = this.globalName(metricID, "_rate_per_second");
        this.appendTYPE(rate, OpenMetricsType.gauge);
        this.appendValue(rate, tags, metered.getMeanRate());
        String oneMinRate = this.globalName(metricID, "_one_min_rate_per_second");
        this.appendTYPE(oneMinRate, OpenMetricsType.gauge);
        this.appendValue(oneMinRate, tags, metered.getOneMinuteRate());
        String fiveMinRate = this.globalName(metricID, "_five_min_rate_per_second");
        this.appendTYPE(fiveMinRate, OpenMetricsType.gauge);
        this.appendValue(fiveMinRate, tags, metered.getFiveMinuteRate());
        String fifteenMinRate = this.globalName(metricID, "_fifteen_min_rate_per_second");
        this.appendTYPE(fifteenMinRate, OpenMetricsType.gauge);
        this.appendValue(fifteenMinRate, tags, metered.getFifteenMinuteRate());
    }

    @Override
    public void export(MetricID metricID, SimpleTimer timer, Metadata metadata) {
        Tag[] tags = metricID.getTagsAsArray();
        String total = this.globalName(metricID, "_total");
        this.appendTYPE(total, OpenMetricsType.counter);
        this.appendHELP(total, metadata);
        this.appendValue(total, tags, timer.getCount());
        String elapsedTime = this.globalName(metricID, "_elapsedTime_seconds");
        this.appendTYPE(elapsedTime, OpenMetricsType.gauge);
        this.appendValue(elapsedTime, tags, (double)timer.getElapsedTime().toMillis() / 1000.0);
    }

    @Override
    public void export(MetricID metricID, Timer timer, Metadata metadata) {
        this.exportMetered(metricID, timer);
        this.exportSampling(metricID, timer, timer::getCount, metadata);
    }

    protected void appendTYPE(String globalName, OpenMetricsType type) {
        if (this.typeWrittenByGlobalName.contains(globalName)) {
            return;
        }
        this.typeWrittenByGlobalName.add(globalName);
        this.out.append("# TYPE ").append(globalName).append(' ').append(type.name()).append('\n');
    }

    protected void appendHELP(String globalName, Metadata metadata) {
        if (this.helpWrittenByGlobalName.contains(globalName)) {
            return;
        }
        this.helpWrittenByGlobalName.add(globalName);
        Optional<String> description = metadata.getDescription();
        if (!description.isPresent()) {
            return;
        }
        String text = description.get();
        if (text.isEmpty()) {
            return;
        }
        this.out.append("# HELP ").append(globalName).append(' ').append(text).append('\n');
    }

    protected void appendValue(String globalName, Tag[] tags, Number value) {
        this.out.append(globalName);
        this.out.append(OpenMetricsExporter.tagsToString(tags));
        this.out.append(' ').append(this.roundValue(value)).append('\n');
    }

    private void appendValue(String globalName, Tag[] tags, long value) {
        this.appendValue(globalName, tags, (Number)value);
    }

    private void appendValue(String globalName, Tag[] tags, double value) {
        this.appendValue(globalName, tags, (Number)value);
    }

    protected String roundValue(Number value) {
        String valString = value.toString();
        if (valString.endsWith(".0")) {
            valString = valString.substring(0, valString.length() - 2);
        }
        if (valString.endsWith("000000001")) {
            valString = valString.substring(0, valString.length() - 9);
        }
        if (valString.contains("000000001E")) {
            valString = valString.replace("000000001E", "E");
        }
        return valString;
    }

    protected static String tagsToString(Tag[] tags) {
        if (tags.length == 0) {
            return "";
        }
        String result = "";
        result = result + "{";
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + OpenMetricsExporter.sanitizeMetricName(tags[i].getTagName()) + "=\"" + OpenMetricsExporter.escapeTagValue(tags[i].getTagValue()) + '\"';
        }
        result = result + "}";
        return result;
    }

    private String globalName(MetricID metricID, Metadata unit) {
        return this.globalName(metricID, "", unit, "");
    }

    private String globalName(MetricID metricID, String infix, Metadata unit) {
        return this.globalName(metricID, infix, unit, "");
    }

    private String globalName(MetricID metricID, Metadata unit, String suffix) {
        return this.globalName(metricID, "", unit, suffix);
    }

    private String globalName(MetricID metricID, String infix, Metadata metadata, String suffix) {
        String unit;
        if (!metadata.getUnit().isPresent()) {
            return this.globalName(metricID, infix + suffix);
        }
        switch (unit = metadata.getUnit().get()) {
            case "nanoseconds": 
            case "microseconds": 
            case "milliseconds": 
            case "seconds": 
            case "minutes": 
            case "hours": 
            case "days": {
                return this.globalName(metricID, infix + "_seconds" + suffix);
            }
            case "bits": 
            case "bytes": 
            case "kilobits": 
            case "megabits": 
            case "gigabits": 
            case "kibibits": 
            case "mebibits": 
            case "gibibits": 
            case "kilobytes": 
            case "megabytes": 
            case "gigabytes": {
                return this.globalName(metricID, infix + "_bytes" + suffix);
            }
            case "percent": {
                return this.globalName(metricID, infix + "_ratio" + suffix);
            }
            case "per_second": {
                return this.globalName(metricID, infix + "_per_second" + suffix);
            }
            case "none": {
                return this.globalName(metricID, infix + suffix);
            }
        }
        return this.globalName(metricID, infix + "_" + unit + suffix);
    }

    private String globalName(MetricID metricID, String suffix) {
        String name = metricID.getName();
        return OpenMetricsExporter.sanitizeMetricName(!suffix.isEmpty() && name.endsWith(suffix) ? this.scope.getName() + '_' + name : this.scope.getName() + '_' + name + suffix);
    }

    private static CharSequence escapeTagValue(String name) {
        StringBuilder str = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\n') {
                str.append("\\n");
                continue;
            }
            if (c == '\\' || c == '\"') {
                str.append('\\');
            }
            str.append(c);
        }
        return str;
    }

    public static String sanitizeMetricName(String name) {
        String out = name.replaceAll("[^a-zA-Z0-9_]+", "_");
        return out.replaceAll(":_", ":");
    }

    private static Tag[] tags(String name, String value, Tag[] rest) {
        Tag tag = new Tag(name, value);
        if (rest.length == 0) {
            return new Tag[]{tag};
        }
        Tag[] res = Arrays.copyOf(rest, rest.length + 1);
        res[rest.length] = tag;
        return res;
    }

    protected static enum OpenMetricsType {
        counter,
        gauge,
        summary;

    }
}

