/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.JavaEEScanner;

public class JarScanner
extends JavaEEScanner
implements Scanner<Object> {
    private File jarFile;
    private Set<JarEntry> entries = new HashSet<JarEntry>();
    private ClassLoader classLoader = null;

    @Override
    public void process(File jarFile, Object bundleDesc, ClassLoader loader) throws IOException {
        this.jarFile = jarFile;
        try (JarFile jf = new JarFile(jarFile);){
            Enumeration<JarEntry> entriesEnum = jf.entries();
            while (entriesEnum.hasMoreElements()) {
                JarEntry je = entriesEnum.nextElement();
                if (!je.getName().endsWith(".class")) continue;
                this.entries.add(je);
            }
        }
        this.initTypes(jarFile);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            final URL[] urls = new URL[1];
            try {
                if (this.jarFile == null) {
                    throw new IllegalStateException("jarFile must first be set with the process method.");
                }
                urls[0] = this.jarFile.getAbsoluteFile().toURL();
                this.classLoader = new PrivilegedAction<URLClassLoader>(){

                    @Override
                    public URLClassLoader run() {
                        return new URLClassLoader(urls);
                    }
                }.run();
            }
            catch (Exception e) {
                AnnotationUtils.getLogger().log(Level.SEVERE, null, e);
            }
        }
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        return this.getElements(this.entries.stream().map(ZipEntry::getName).collect(Collectors.toSet()));
    }

    @Override
    public Set<Class> getElements(Set<String> fileNames) {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String fileName : fileNames) {
            String className = fileName.replace(File.separatorChar, '.');
            className = className.substring(0, className.length() - 6);
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationUtils.getLogger().log(Level.SEVERE, null, cnfe);
            }
        }
        return elements;
    }
}

