/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.glassfish.admingui.common.util.GuiUtil;

public class NewSSLHandlers {
    private static Set<String> COMMON_CIPHERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA")));
    private static Set<String> BIT_CIPHERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA")));

    public static void convertToDifferentCiphersGroup(HandlerContext handlerCtx) {
        List<String> ciphersList = null;
        Object ciphers = handlerCtx.getInputValue("ciphers");
        if (ciphers != null) {
            ciphersList = ciphers instanceof String ? Arrays.asList(NewSSLHandlers.getSelectedCiphersList((String)ciphers)) : Arrays.asList((String[])ciphers);
        }
        handlerCtx.setOutputValue("CommonCiphersList", (Object)NewSSLHandlers.getCommonCiphers(ciphersList));
        handlerCtx.setOutputValue("EphemeralCiphersList", (Object)NewSSLHandlers.getEphemeralCiphers(ciphersList));
        handlerCtx.setOutputValue("OtherCiphersList", (Object)NewSSLHandlers.getOtherCiphers(ciphersList));
        handlerCtx.setOutputValue("EccCiphersList", (Object)NewSSLHandlers.getEccCiphers(ciphersList));
    }

    public static void convertCiphersItemsToStr(HandlerContext handlerCtx) {
        String[] common = (String[])handlerCtx.getInputValue("common");
        String[] ephemeral = (String[])handlerCtx.getInputValue("ephemeral");
        String[] other = (String[])handlerCtx.getInputValue("other");
        String[] ecc = (String[])handlerCtx.getInputValue("ecc");
        String ciphers = NewSSLHandlers.processSelectedCiphers(common, "");
        ciphers = NewSSLHandlers.processSelectedCiphers(ephemeral, ciphers);
        ciphers = NewSSLHandlers.processSelectedCiphers(other, ciphers);
        ciphers = NewSSLHandlers.processSelectedCiphers(ecc, ciphers);
        handlerCtx.setOutputValue("ciphers", (Object)ciphers);
    }

    private static String[] getSelectedCiphersList(String selectedCiphers) {
        if (selectedCiphers != null) {
            return NewSSLHandlers.filterCiphers(Arrays.asList(selectedCiphers.split(",")), cipher -> cipher.startsWith("+"), cipher -> cipher.substring(1));
        }
        return new String[0];
    }

    private static String processSelectedCiphers(String[] selectedCiphers, String ciphers) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (!GuiUtil.isEmpty(ciphers)) {
            sb.append(ciphers);
            sep = ",";
        }
        if (selectedCiphers != null) {
            for (String selectedCipher : selectedCiphers) {
                sb.append(sep).append("+").append(selectedCipher);
                sep = ",";
            }
        }
        return sb.toString();
    }

    private static String[] getCommonCiphers(List<String> ciphers) {
        return NewSSLHandlers.filterCiphers(ciphers, cypher -> COMMON_CIPHERS.contains(cypher));
    }

    private static String[] getEccCiphers(List<String> ciphers) {
        return NewSSLHandlers.filterCiphers(ciphers, cipher -> !BIT_CIPHERS.contains(cipher) && (cipher.contains("_ECDH_") || cipher.contains("_ECDHE_")));
    }

    private static String[] getEphemeralCiphers(List<String> ciphers) {
        return NewSSLHandlers.filterCiphers(ciphers, cipher -> !BIT_CIPHERS.contains(cipher) && (cipher.contains("_DHE_RSA_") || cipher.contains("_DHE_DSS_")));
    }

    private static String[] getOtherCiphers(List<String> ciphers) {
        return NewSSLHandlers.filterCiphers(ciphers, cypher -> BIT_CIPHERS.contains(cypher));
    }

    private static String[] filterCiphers(List<String> ciphers, Predicate<String> filter) {
        return NewSSLHandlers.filterCiphers(ciphers, filter, str -> str);
    }

    private static String[] filterCiphers(List<String> ciphers, Predicate<String> filter, Function<String, String> transformation) {
        if (ciphers != null) {
            return (String[])ciphers.stream().filter(filter).map(transformation).toArray(String[]::new);
        }
        return new String[0];
    }
}

