/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.glassfish.admingui.common.handlers.UtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;

class PropertyList
implements Iterable<Map.Entry<String, String>> {
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    private PropertyList() {
    }

    void put(String key, String value) {
        if (GuiUtil.isEmpty(key)) {
            return;
        }
        if (!GuiUtil.isEmpty(value)) {
            this.properties.put(key, value);
        }
    }

    void put(String key, Map<String, String> sourceMap, String sourceKey) {
        if (sourceMap != null) {
            this.put(key, sourceMap.get(sourceKey));
        }
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public String get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.properties.entrySet().iterator();
    }

    public List<Map<String, String>> toList() {
        return this.properties.entrySet().stream().map(e -> PropertyList.toPropertyEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public String toParamValue() {
        StringBuilder paramValue = new StringBuilder();
        for (Map.Entry<String, String> oneProp : this) {
            paramValue.append(oneProp.getKey()).append("=");
            String value = oneProp.getValue().replaceAll("\\\\", "\\\\\\\\");
            value = UtilHandlers.escapePropertyValue(value);
            paramValue.append(value).append(":");
        }
        return paramValue.toString();
    }

    static Map<String, String> toPropertyEntry(String name, String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", name);
        result.put("value", value);
        return result;
    }

    static PropertyList fromList(List<Map<String, String>> propertyList) {
        PropertyList result = new PropertyList();
        for (Map<String, String> entry : propertyList) {
            result.put(entry.get("name"), entry.get("value"));
        }
        return result;
    }

    static PropertyList fromMap(Map<String, String> map) {
        PropertyList result = new PropertyList();
        result.properties.putAll(map);
        return result;
    }
}

