/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.FieldInfo;
import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

class FieldInfoVector {
    List<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
    private int classNameLength = 0;
    private int fieldNameLength = 0;
    private int modifiersLength = 0;

    FieldInfoVector() {
    }

    void addElement(FieldInfo o) {
        this.fieldInfos.add(o);
    }

    public String toString() {
        int veclen = this.fieldInfos.size();
        StringBuilder s = new StringBuilder();
        this.setLongestNames();
        s.append(StringUtils.padRight("Class", this.classNameLength));
        s.append(StringUtils.padRight("Modifiers", this.modifiersLength));
        s.append(StringUtils.padRight("Field", this.fieldNameLength));
        s.append("Value");
        s.append("\n\n");
        for (int i = 0; i < veclen; ++i) {
            FieldInfo fi = this.fetch(i);
            s.append(StringUtils.padRight(fi.className, this.classNameLength));
            s.append(StringUtils.padRight(fi.modifiers, this.modifiersLength));
            s.append(StringUtils.padRight(fi.field.getName(), this.fieldNameLength));
            s.append(fi.value);
            s.append('\n');
        }
        return s.toString();
    }

    private FieldInfo fetch(int i) {
        return this.fieldInfos.get(i);
    }

    private void setLongestNames() {
        int veclen = this.fieldInfos.size();
        this.classNameLength = 5;
        this.fieldNameLength = 5;
        this.modifiersLength = 5;
        for (int i = 0; i < veclen; ++i) {
            FieldInfo fi = this.fetch(i);
            int clen = fi.className.length();
            int flen = fi.field.getName().length();
            int mlen = fi.modifiers.length();
            if (clen > this.classNameLength) {
                this.classNameLength = clen;
            }
            if (flen > this.fieldNameLength) {
                this.fieldNameLength = flen;
            }
            if (mlen <= this.modifiersLength) continue;
            this.modifiersLength = mlen;
        }
        this.classNameLength += 2;
        this.fieldNameLength += 2;
        this.modifiersLength += 2;
    }
}

