/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.AppTenants;
import com.sun.enterprise.config.serverbeans.ApplicationExtension;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.customvalidators.ContextRootCheck;
import fish.payara.api.admin.config.ApplicationDeploymentTime;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@RestRedirects(value={@RestRedirect(opType=RestRedirect.OpType.DELETE, commandName="undeploy"), @RestRedirect(opType=RestRedirect.OpType.POST, commandName="redeploy")})
@ContextRootCheck(message="{contextroot.duplicate}", payload={Application.class})
public interface Application
extends ApplicationName,
ApplicationDeploymentTime,
PropertyBag {
    public static final String APP_LOCATION_PROP_NAME = "appLocation";
    public static final String DEPLOYMENT_PLAN_LOCATION_PROP_NAME = "deploymentPlanLocation";
    public static final String ARCHIVE_TYPE_PROP_NAME = "archiveType";
    public static final String ALT_DD_LOCATION_PROP_NAME = "altDDLocation";
    public static final String RUNTIME_ALT_DD_LOCATION_PROP_NAME = "runtimeAltDDLocation";

    @Attribute
    public String getContextRoot();

    public void setContextRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLocation();

    public void setLocation(String var1) throws PropertyVetoException;

    @Attribute(required=true)
    @NotNull
    public String getObjectType();

    public void setObjectType(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1) throws PropertyVetoException;

    @Attribute
    public String getLibraries();

    public void setLibraries(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAvailabilityEnabled();

    public void setAvailabilityEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getAsyncReplication();

    public void setAsyncReplication(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDirectoryDeployed();

    public void setDirectoryDeployed(String var1) throws PropertyVetoException;

    @Attribute
    public String getDescription();

    public void setDescription(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="100", dataType=Integer.class)
    public String getDeploymentOrder();

    public void setDeploymentOrder(String var1) throws PropertyVetoException;

    @Element
    public List<Module> getModule();

    @Element
    public List<Engine> getEngine();

    @Element
    public Resources getResources();

    public void setResources(Resources var1) throws PropertyVetoException;

    @Element
    public AppTenants getAppTenants();

    public void setAppTenants(AppTenants var1);

    @Element(value="*")
    public List<ApplicationExtension> getExtensions();

    @DuckTyped
    public <T extends ApplicationExtension> T getExtensionByType(Class<T> var1);

    @DuckTyped
    public <T extends ApplicationExtension> List<T> getExtensionsByType(Class<T> var1);

    @DuckTyped
    public Module getModule(String var1);

    @DuckTyped
    public Properties getDeployProperties();

    @DuckTyped
    public DeployCommandParameters getDeployParameters(ApplicationRef var1);

    @DuckTyped
    public Map<String, Properties> getModulePropertiesMap();

    @DuckTyped
    public boolean isStandaloneModule();

    @DuckTyped
    public boolean containsSnifferType(String var1);

    @DuckTyped
    public boolean isLifecycleModule();

    @DuckTyped
    public void recordFileLocations(File var1, File var2);

    @DuckTyped
    public File application();

    @DuckTyped
    public File deploymentPlan();

    @DuckTyped
    public String archiveType();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    public static class Duck {
        public static Module getModule(Application instance, String name) {
            for (Module module : instance.getModule()) {
                if (!module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        public static Properties getDeployProperties(Application instance) {
            Properties deploymentProps = new Properties();
            for (Property prop : instance.getProperty()) {
                if (prop.getValue() == null) continue;
                deploymentProps.put(prop.getName(), prop.getValue());
            }
            deploymentProps.setProperty("object-type", instance.getObjectType());
            if (instance.getContextRoot() != null) {
                deploymentProps.setProperty("context-root", instance.getContextRoot());
            }
            if (instance.getDirectoryDeployed() != null) {
                deploymentProps.setProperty("directory-deployed", instance.getDirectoryDeployed());
            }
            return deploymentProps;
        }

        public static DeployCommandParameters getDeployParameters(Application app, ApplicationRef appRef) {
            URI uri = null;
            try {
                uri = new URI(app.getLocation());
            }
            catch (URISyntaxException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
            }
            if (uri == null) {
                return null;
            }
            DeployCommandParameters deploymentParams = new DeployCommandParameters(new File(uri));
            deploymentParams.name = app.getName();
            deploymentParams.description = app.getDescription();
            deploymentParams.enabled = Boolean.valueOf(app.getEnabled()) != false && appRef != null && Boolean.valueOf(appRef.getEnabled()) != false ? Boolean.TRUE : Boolean.FALSE;
            deploymentParams.contextroot = app.getContextRoot();
            deploymentParams.libraries = app.getLibraries();
            deploymentParams.availabilityenabled = Boolean.parseBoolean(app.getAvailabilityEnabled());
            deploymentParams.asyncreplication = Boolean.parseBoolean(app.getAsyncReplication());
            if (appRef != null) {
                deploymentParams.lbenabled = appRef.getLbEnabled();
            }
            if (appRef != null) {
                deploymentParams.virtualservers = appRef.getVirtualServers();
            }
            deploymentParams.deploymentorder = new Integer(app.getDeploymentOrder());
            for (Property prop : app.getProperty()) {
                switch (prop.getName()) {
                    case "archiveType": {
                        deploymentParams.type = prop.getValue();
                        break;
                    }
                    case "altDDLocation": {
                        URI altDDUri = null;
                        try {
                            altDDUri = new URI(prop.getValue());
                        }
                        catch (URISyntaxException e) {
                            Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
                        }
                        if (altDDUri == null) break;
                        deploymentParams.altdd = new File(altDDUri);
                        break;
                    }
                    case "runtimeAltDDLocation": {
                        URI runtimeAltDDUri = null;
                        try {
                            runtimeAltDDUri = new URI(prop.getValue());
                        }
                        catch (URISyntaxException e) {
                            Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
                        }
                        if (runtimeAltDDUri == null) break;
                        deploymentParams.runtimealtdd = new File(runtimeAltDDUri);
                        break;
                    }
                }
            }
            return deploymentParams;
        }

        public static Map<String, Properties> getModulePropertiesMap(Application me) {
            HashMap<String, Properties> modulePropertiesMap = new HashMap<String, Properties>();
            for (Module module : me.getModule()) {
                if (module.getProperty() == null) continue;
                Properties moduleProps = new Properties();
                for (Property property : module.getProperty()) {
                    if (property.getValue() == null) continue;
                    moduleProps.put(property.getName(), property.getValue());
                }
                modulePropertiesMap.put(module.getName(), moduleProps);
            }
            return modulePropertiesMap;
        }

        public static boolean isStandaloneModule(Application me) {
            return Boolean.valueOf(me.getDeployProperties().getProperty("isComposite")) == false;
        }

        public static boolean isLifecycleModule(Application me) {
            return Boolean.valueOf(me.getDeployProperties().getProperty("isLifecycle"));
        }

        public static boolean containsSnifferType(Application app, String snifferType) {
            ArrayList<Engine> engineList = new ArrayList<Engine>();
            engineList.addAll(app.getEngine());
            for (Module module : app.getModule()) {
                engineList.addAll(module.getEngines());
            }
            for (Engine engine : engineList) {
                if (!engine.getSniffer().equals(snifferType)) continue;
                return true;
            }
            return false;
        }

        public static File application(Application instance) {
            return Duck.fileForProp(instance, Application.APP_LOCATION_PROP_NAME);
        }

        public static File deploymentPlan(Application instance) {
            return Duck.fileForProp(instance, Application.DEPLOYMENT_PLAN_LOCATION_PROP_NAME);
        }

        public static File altDD(Application instance) {
            return Duck.fileForProp(instance, Application.ALT_DD_LOCATION_PROP_NAME);
        }

        public static File runtimeAltDD(Application instance) {
            return Duck.fileForProp(instance, Application.RUNTIME_ALT_DD_LOCATION_PROP_NAME);
        }

        public static String archiveType(Application instance) {
            for (Property p : instance.getProperty()) {
                if (!p.getName().equals(Application.ARCHIVE_TYPE_PROP_NAME)) continue;
                return p.getValue();
            }
            return null;
        }

        private static File fileForProp(Application instance, String propName) {
            for (Property p : instance.getProperty()) {
                if (!p.getName().equals(propName)) continue;
                return new File(URI.create(p.getValue()));
            }
            return null;
        }

        public static <T extends ApplicationExtension> T getExtensionByType(Application a, Class<T> type) {
            for (ApplicationExtension extension : a.getExtensions()) {
                try {
                    return (T)((ApplicationExtension)type.cast(extension));
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        public static <T extends ApplicationExtension> List<T> getExtensionsByType(Application a, Class<T> type) {
            ArrayList<T> exts = new ArrayList<T>();
            for (ApplicationExtension extension : a.getExtensions()) {
                try {
                    exts.add(type.cast(extension));
                }
                catch (Exception exception) {}
            }
            return exts;
        }
    }
}

