/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
public interface SecureAdminPrincipal
extends ConfigBeanProxy {
    @Param(primary=true)
    public void setDn(String var1);

    @Attribute(key=true)
    public String getDn();

    @Service
    @PerLookup
    public static class Resolver
    implements CrudResolver {
        @Param(primary=true)
        private String value;
        @Param(optional=true, name="alias", defaultValue="false")
        private boolean isAlias = true;
        @Inject
        ServiceLocator habitat;
        @Inject
        private SecureAdminHelper helper;
        protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecureAdminPrincipal.class);

        @Override
        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            try {
                this.value = this.helper.getDN(this.value, this.isAlias);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (!SecureAdminPrincipal.class.isAssignableFrom(type)) {
                String msg = localStrings.getLocalString(SecureAdminPrincipal.class, "SecureAdminPrincipalResolver.configTypeNotNamed", "Config type {0} must extend {1} but does not", new Object[]{type.getSimpleName(), Named.class.getName()});
                throw new IllegalArgumentException(msg);
            }
            for (ConfigBeanProxy candidate : this.habitat.getAllServices(type, new Annotation[0])) {
                if (!this.value.equals(((SecureAdminPrincipal)candidate).getDn())) continue;
                return (T)candidate;
            }
            String msg = localStrings.getLocalString(SecureAdminPrincipal.class, "SecureAdminPrincipalResolver.target_object_not_found", "Cannot find a {0} with a name {1}", new Object[]{type.getSimpleName(), this.value});
            throw new RuntimeException(msg);
        }
    }

    @Service
    @PerLookup
    public static class CrDecorator
    implements CreationDecorator<SecureAdminPrincipal> {
        @Inject
        Domain domain;
        @Inject
        private SecureAdminHelper helper;
        @Param(optional=false, name="value", primary=true)
        private String value;
        @Param(optional=true, name="alias", defaultValue="false")
        private boolean isAlias = true;

        @Override
        public void decorate(AdminCommandContext context, SecureAdminPrincipal instance) throws TransactionFailure, PropertyVetoException {
            if (!this.isPrincipalDuplicate()) {
                try {
                    instance.setDn(this.helper.getDN(this.value, this.isAlias));
                }
                catch (Exception ex) {
                    throw new TransactionFailure("create", (Throwable)ex);
                }
            } else {
                throw new TransactionFailure("Secure admin principal already exists");
            }
        }

        private boolean isPrincipalDuplicate() throws TransactionFailure {
            boolean principalDuplicate = false;
            SecureAdmin secureAdmin = this.domain.getSecureAdmin();
            for (SecureAdminPrincipal principal : secureAdmin.getSecureAdminPrincipal()) {
                try {
                    if (!this.helper.getDN(this.value, this.isAlias).equals(principal.getDn())) continue;
                    principalDuplicate = true;
                    break;
                }
                catch (Exception ex) {
                    throw new TransactionFailure("create", (Throwable)ex);
                }
            }
            return principalDuplicate;
        }
    }
}

