/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.customvalidators.ContextRootCheck;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.UnexpectedTypeException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

public class ContextRootCheckValidator
implements ConstraintValidator<ContextRootCheck, Application> {
    public void initialize(ContextRootCheck constraintAnnotation) {
    }

    public boolean isValid(Application app, ConstraintValidatorContext cvc) throws UnexpectedTypeException {
        if (app == null) {
            return true;
        }
        Dom dom = Dom.unwrap((ConfigBeanProxy)app);
        ServiceLocator locator = dom.getHabitat();
        if (locator == null) {
            return true;
        }
        ConfigBeansUtilities cbu = (ConfigBeansUtilities)locator.getService(ConfigBeansUtilities.class, new Annotation[0]);
        if (cbu == null) {
            return true;
        }
        Domain domain = cbu.getDomain();
        String appName = app.getName();
        String contextRoot = app.getContextRoot();
        if (contextRoot != null && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        boolean result = true;
        List<String> targets = domain.getAllReferencedTargetsForApplication(appName);
        for (String target : targets) {
            List<Server> servers = domain.getServersInTarget(target);
            for (Server server : servers) {
                ApplicationRef applicationRef = domain.getApplicationRefInServer(server.getName(), appName);
                if (applicationRef == null) continue;
                block2: for (Application application : domain.getApplications().getApplications()) {
                    if (ContextRootCheckValidator.isSameApp(appName, application.getName()) || application.getContextRoot() == null || !application.getContextRoot().equals(contextRoot)) continue;
                    String virtualServers = applicationRef.getVirtualServers();
                    List<String> vsList = Arrays.asList(virtualServers.split(","));
                    ApplicationRef thisAppRef = domain.getApplicationRefInServer(server.getName(), application.getName());
                    if (thisAppRef == null) continue;
                    virtualServers = thisAppRef.getVirtualServers();
                    List<String> thisVsList = Arrays.asList(virtualServers.split(","));
                    for (String vs : thisVsList) {
                        if (!vsList.contains(vs)) continue;
                        result = false;
                        continue block2;
                    }
                }
            }
        }
        return result;
    }

    private static boolean isSameApp(String name1, String name2) {
        try {
            if (name1.equals(name2) || name1.equals(ContextRootCheckValidator.getUntaggedName(name2)) || name2.equals(ContextRootCheckValidator.getUntaggedName(name1)) || ContextRootCheckValidator.getUntaggedName(name1).equals(ContextRootCheckValidator.getUntaggedName(name2))) {
                return true;
            }
        }
        catch (InvalidNameException | NullPointerException exception) {
            // empty catch block
        }
        return false;
    }

    private static String getUntaggedName(String appName) throws InvalidNameException {
        int colonIndex;
        if (appName != null && !appName.isEmpty() && (colonIndex = appName.indexOf(58)) >= 0) {
            if (colonIndex == 0) {
                throw new InvalidNameException("expected application name before colon: " + appName);
            }
            if (colonIndex == appName.length() - 1) {
                throw new InvalidNameException("expected version identifier after colon: " + appName);
            }
            return appName.substring(0, colonIndex);
        }
        return appName;
    }

    private static class InvalidNameException
    extends Exception {
        InvalidNameException(String message) {
            super(message);
        }
    }
}

