/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.glassfish.config.support.Strings;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigView;

public class TranslatedConfigView
implements ConfigView {
    static final Pattern p = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}([^\\$]*)");
    static final Pattern envP = Pattern.compile("([^\\$]*)\\$\\{ENV=([^\\}]*)\\}([^\\$]*)");
    static final Pattern mpConfigP = Pattern.compile("([^\\$]*)\\$\\{MPCONFIG=([^\\}]*)\\}([^\\$]*)");
    private static final String ALIAS_TOKEN = "ALIAS";
    private static final int MAX_SUBSTITUTION_DEPTH = 100;
    private static final boolean SUBSTITUTION_DISABLED = Boolean.valueOf(System.getProperty("fish.payara.substitution.disable", "false"));
    public static final ThreadLocal<Boolean> doSubstitution = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    final ConfigView masterView;
    static ServiceLocator habitat;
    private static DomainScopedPasswordAliasStore domainPasswordAliasStore;

    public static String expandValue(String value) {
        if (value == null || SUBSTITUTION_DISABLED) {
            return value;
        }
        return (String)TranslatedConfigView.getTranslatedValue(value);
    }

    public static String expandConfigValue(String value) {
        return (String)TranslatedConfigView.getTranslatedValue(value);
    }

    private static Object getTranslatedValue(Object value) {
        if (value != null && value instanceof String) {
            Object newValue;
            int i;
            String stringValue = value.toString();
            if (stringValue.indexOf(36) == -1) {
                return value;
            }
            if (!doSubstitution.get().booleanValue()) {
                return value;
            }
            if (TranslatedConfigView.domainPasswordAliasStore() != null && TranslatedConfigView.getAlias(stringValue) != null) {
                try {
                    return TranslatedConfigView.getRealPasswordFromAlias(stringValue);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.aliaserror", stringValue, e.getLocalizedMessage()));
                    return stringValue;
                }
            }
            String origValue = stringValue;
            Matcher m3 = mpConfigP.matcher(stringValue);
            for (i = 0; m3.find() && i < 100; ++i) {
                String matchValue = m3.group(2).trim();
                Config config = TranslatedConfigView.configResolver().getConfig();
                newValue = config.getOptionalValue(matchValue, String.class);
                if (newValue == null || !((Optional)newValue).isPresent()) continue;
                stringValue = m3.replaceFirst(Matcher.quoteReplacement(m3.group(1) + (String)((Optional)newValue).get() + m3.group(3)));
                m3.reset(stringValue);
            }
            if (i >= 100) {
                Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.badprop", i, origValue));
            }
            Matcher m2 = envP.matcher(stringValue);
            for (i = 0; m2.find() && i < 100; ++i) {
                String matchValue = m2.group(2).trim();
                newValue = System.getenv(matchValue);
                if (newValue == null) continue;
                stringValue = m2.replaceFirst(Matcher.quoteReplacement(m2.group(1) + (String)newValue + m2.group(3)));
                m2.reset(stringValue);
            }
            if (i >= 100) {
                Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.badprop", i, origValue));
            }
            Matcher m = p.matcher(stringValue);
            for (i = 0; m.find() && i < 100; ++i) {
                String matchValue = m.group(2).trim();
                String newValue2 = System.getProperty(matchValue);
                if (newValue2 == null) continue;
                stringValue = m.replaceFirst(Matcher.quoteReplacement(m.group(1) + newValue2 + m.group(3)));
                m.reset(stringValue);
            }
            if (i >= 100) {
                Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.badprop", i, origValue));
            }
            return stringValue;
        }
        return value;
    }

    TranslatedConfigView(ConfigView master) {
        this.masterView = master;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return TranslatedConfigView.getTranslatedValue(this.masterView.invoke(proxy, method, args));
    }

    public ConfigView getMasterView() {
        return this.masterView;
    }

    public void setMasterView(ConfigView view) {
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.masterView.getProxyType();
    }

    public <T extends ConfigBeanProxy> T getProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)((Object)this))));
    }

    public static void setHabitat(ServiceLocator h) {
        habitat = h;
    }

    private static DomainScopedPasswordAliasStore domainPasswordAliasStore() {
        if (habitat != null) {
            domainPasswordAliasStore = AccessController.doPrivileged(new PrivilegedAction<DomainScopedPasswordAliasStore>(){

                @Override
                public DomainScopedPasswordAliasStore run() {
                    return (DomainScopedPasswordAliasStore)habitat.getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);
                }
            });
        }
        return domainPasswordAliasStore;
    }

    private static ConfigProviderResolver configResolver() {
        if (habitat != null) {
            return AccessController.doPrivileged(() -> (ConfigProviderResolver)habitat.getService(ConfigProviderResolver.class, new Annotation[0]));
        }
        throw new IllegalStateException("Trying to access MP Config before Service Locator started");
    }

    public static String getAlias(String propName) {
        int lastIdx;
        String aliasName = null;
        String starter = "${ALIAS=";
        String ender = "}";
        if ((propName = propName.trim()).startsWith(starter) && propName.endsWith(ender) && (lastIdx = (propName = propName.substring(starter.length())).length() - 1) > 1 && (propName = propName.substring(0, lastIdx)) != null) {
            aliasName = propName.trim();
        }
        return aliasName;
    }

    public static String getRealPasswordFromAlias(String at) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String an = TranslatedConfigView.getAlias(at);
        boolean exists = domainPasswordAliasStore.containsKey(an);
        if (!exists) {
            String msg = String.format("Alias  %s does not exist", an);
            throw new IllegalArgumentException(msg);
        }
        return new String(domainPasswordAliasStore.get(an));
    }

    static {
        domainPasswordAliasStore = null;
    }
}

