/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.node.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_delete-node-temp")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.POST, path="_delete-node-temp", description="Delete Node Temp")})
public class DeleteNodeTempCommand
implements AdminCommand {
    @Param(name="name", primary=true)
    private String name;
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setMessage("No node found with given name: " + this.name);
            return;
        }
        if (!node.getType().equals("TEMP")) {
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setMessage("Node with given name is not a temp node: " + this.name);
            return;
        }
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_delete-node", actionReport, context.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"DEFAULT", (Object)this.name);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
    }
}

