/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.digest.impl;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.impl.NestedDigestAlgoParamImpl;
import javax.inject.Provider;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;

public class CNonceValidator {
    private WebBundleDescriptor webDescriptor;
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    private CNonceCacheFactory cNonceCacheFactory;
    private CNonceCache cnonces;
    private AppCNonceCacheMap haCNonceCacheMap;

    public CNonceValidator(WebBundleDescriptor webDescriptor, Provider<AppCNonceCacheMap> appCNonceCacheMapProvider, Provider<CNonceCacheFactory> cNonceCacheFactoryProvider) {
        this.webDescriptor = webDescriptor;
        this.appCNonceCacheMapProvider = appCNonceCacheMapProvider;
        this.cNonceCacheFactoryProvider = cNonceCacheFactoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestAlgorithmParameter[] validateCnonce(DigestAlgorithmParameter[] parameters) {
        if (this.cnonces == null) {
            this.init();
        }
        String cnonce = null;
        String nc = null;
        for (DigestAlgorithmParameter digestParameter : parameters) {
            if (digestParameter instanceof NestedDigestAlgoParamImpl) {
                for (DigestAlgorithmParameter nestedDigestParameter : this.getNestedParams(digestParameter)) {
                    if (this.isCnonce(nestedDigestParameter)) {
                        cnonce = new String(nestedDigestParameter.getValue());
                    } else if (this.isNc(nestedDigestParameter)) {
                        nc = new String(nestedDigestParameter.getValue());
                    }
                    if (cnonce != null && nc != null) break;
                }
                if (cnonce != null && nc != null) break;
            }
            if (this.isCnonce(digestParameter)) {
                cnonce = new String(digestParameter.getValue());
                continue;
            }
            if (!this.isNc(digestParameter)) continue;
            nc = new String(digestParameter.getValue());
        }
        long currentTime = System.currentTimeMillis();
        long count = this.getHexCount(nc);
        NonceInfo info = this.getValidatedNonceInfo(cnonce, count);
        info.setCount(count);
        info.setTimestamp(currentTime);
        CNonceCache cNonceCache = this.cnonces;
        synchronized (cNonceCache) {
            this.cnonces.put((Object)cnonce, (Object)info);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String appName = this.webDescriptor.getApplication().getAppName();
        CNonceValidator cNonceValidator = this;
        synchronized (cNonceValidator) {
            if (this.haCNonceCacheMap == null) {
                this.haCNonceCacheMap = (AppCNonceCacheMap)this.appCNonceCacheMapProvider.get();
            }
            if (this.haCNonceCacheMap != null) {
                this.cnonces = (CNonceCache)this.haCNonceCacheMap.get(appName);
            }
            if (this.cnonces == null) {
                if (this.cNonceCacheFactory == null) {
                    this.cNonceCacheFactory = (CNonceCacheFactory)this.cNonceCacheFactoryProvider.get();
                }
                this.cnonces = this.cNonceCacheFactory.createCNonceCache(this.webDescriptor.getApplication().getAppName(), null, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NonceInfo getValidatedNonceInfo(String cnonce, long count) {
        NonceInfo info;
        CNonceCache cNonceCache = this.cnonces;
        synchronized (cNonceCache) {
            info = (NonceInfo)this.cnonces.get((Object)cnonce);
        }
        if (info == null) {
            return new NonceInfo();
        }
        if (count <= info.getCount()) {
            throw new RuntimeException("Invalid Request : Possible Replay Attack detected ?");
        }
        return info;
    }

    private DigestAlgorithmParameter[] getNestedParams(DigestAlgorithmParameter digestParameter) {
        NestedDigestAlgoParamImpl nestedParameter = (NestedDigestAlgoParamImpl)digestParameter;
        return (DigestAlgorithmParameter[])nestedParameter.getNestedParams();
    }

    private boolean isCnonce(DigestAlgorithmParameter digestParameter) {
        return "cnonce".equals(digestParameter.getName());
    }

    private boolean isNc(DigestAlgorithmParameter digestParameter) {
        return "nc".equals(digestParameter.getName());
    }

    private long getHexCount(String nc) {
        try {
            return Long.parseLong(nc, 16);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
    }
}

