/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.auth.realm;

import com.sun.enterprise.security.BaseRealm;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.digest.api.Password;
import com.sun.enterprise.security.auth.digest.impl.DigestProcessor;
import com.sun.enterprise.security.ee.auth.realm.DigestRealm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;

public abstract class DigestRealmBase
extends BaseRealm
implements DigestRealm {
    protected boolean validate(Password passwd, DigestAlgorithmParameter[] params) {
        try {
            return new DigestValidatorImpl().validate(passwd, params);
        }
        catch (NoSuchAlgorithmException ex) {
            _logger.log(Level.SEVERE, "invalid.digest.algo", ex);
            return false;
        }
    }

    private static class DigestValidatorImpl
    extends DigestProcessor {
        private DigestAlgorithmParameter data;
        private DigestAlgorithmParameter clientResponse;
        private DigestAlgorithmParameter key;
        private String algorithm = "MD5";

        private DigestValidatorImpl() {
        }

        @Override
        protected final boolean validate(Password passwd, DigestAlgorithmParameter[] params) throws NoSuchAlgorithmException {
            for (int i = 0; i < params.length; ++i) {
                DigestAlgorithmParameter dap = params[i];
                if ("A1".equals(dap.getName()) && dap instanceof Key) {
                    this.key = dap;
                    continue;
                }
                if ("response".equals(dap.getName())) {
                    this.clientResponse = dap;
                    continue;
                }
                this.data = dap;
            }
            this.setPassword(passwd);
            try {
                byte[] p1 = this.valueOf(this.key);
                byte[] p2 = this.valueOf(this.data);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(p1);
                bos.write(":".getBytes());
                bos.write(p2);
                byte[] derivedKey = this.encode(MessageDigest.getInstance(this.algorithm).digest(bos.toByteArray())).getBytes();
                byte[] suppliedKey = this.clientResponse.getValue();
                boolean result = true;
                if (derivedKey.length == suppliedKey.length) {
                    for (int i = 0; i < derivedKey.length; ++i) {
                        if (derivedKey[i] == suppliedKey[i]) continue;
                        result = false;
                        break;
                    }
                } else {
                    result = false;
                }
                return result;
            }
            catch (IOException ex) {
                _logger.log(Level.SEVERE, "digest.error", new Object[]{ex.getMessage()});
                return false;
            }
        }
    }
}

