/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jaspic;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.jaspic.WebServicesDelegate;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessagePolicy;
import org.glassfish.internal.api.Globals;

public class AuthMessagePolicy {
    private static final String SENDER = "sender";
    private static final String CONTENT = "content";
    private static final String BEFORE_CONTENT = "before-content";
    private static final String HANDLER_CLASS_PROPERTY = "security.jaspic.config.ConfigHelper.CallbackHandler";
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.enterprise.security.jaspic.callback.ContainerCallbackHandler";
    private static final MessagePolicy MANDATORY_POLICY = AuthMessagePolicy.getMessagePolicy("sender", null, true);
    private static final MessagePolicy OPTIONAL_POLICY = AuthMessagePolicy.getMessagePolicy("sender", null, false);
    private static String handlerClassName;

    private AuthMessagePolicy() {
    }

    public static MessageSecurityBindingDescriptor getMessageSecurityBinding(String layer, Map<String, ?> properties) {
        String bindingLayer;
        if (properties == null) {
            return null;
        }
        MessageSecurityBindingDescriptor messageSecurityBinding = null;
        WebServiceEndpoint webServiceEndpoint = (WebServiceEndpoint)properties.get("SERVICE_ENDPOINT");
        if (webServiceEndpoint != null) {
            messageSecurityBinding = webServiceEndpoint.getMessageSecurityBinding();
        } else {
            WebServicesDelegate webServicesDelegate;
            ServiceReferenceDescriptor serviceReference = (ServiceReferenceDescriptor)properties.get("SERVICE_REF");
            if (serviceReference != null && (webServicesDelegate = (WebServicesDelegate)Globals.get(WebServicesDelegate.class)) != null) {
                messageSecurityBinding = webServicesDelegate.getBinding(serviceReference, properties);
            }
        }
        if (messageSecurityBinding != null && ((bindingLayer = messageSecurityBinding.getAttributeValue("AuthLayer")) == null || layer.equals(bindingLayer))) {
            return messageSecurityBinding;
        }
        return null;
    }

    public static MessagePolicy getMessagePolicy(String authSource, String authRecipient) {
        boolean sourceSender = SENDER.equals(authSource);
        boolean sourceContent = CONTENT.equals(authSource);
        boolean recipientAuth = authRecipient != null;
        boolean mandatory = sourceSender || sourceContent || recipientAuth;
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient, mandatory);
    }

    public static MessagePolicy getMessagePolicy(String authSource, String authRecipient, boolean mandatory) {
        boolean sourceSender = SENDER.equals(authSource);
        boolean sourceContent = CONTENT.equals(authSource);
        boolean recipientAuth = authRecipient != null;
        boolean beforeContent = BEFORE_CONTENT.equals(authRecipient);
        ArrayList<MessagePolicy.TargetPolicy> targetPolicies = new ArrayList<MessagePolicy.TargetPolicy>();
        if (recipientAuth && beforeContent) {
            targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateRecipient"));
            if (sourceSender) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender"));
            } else if (sourceContent) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateContent"));
            }
        } else {
            if (sourceSender) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateSender"));
            } else if (sourceContent) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateContent"));
            }
            if (recipientAuth) {
                targetPolicies.add(new MessagePolicy.TargetPolicy(null, () -> "#authenticateRecipient"));
            }
        }
        return new MessagePolicy(targetPolicies.toArray(new MessagePolicy.TargetPolicy[targetPolicies.size()]), mandatory);
    }

    public static MessagePolicy getMessagePolicy(ProtectionDescriptor protectionDescriptor) {
        if (protectionDescriptor == null) {
            return null;
        }
        String source = protectionDescriptor.getAttributeValue("AuthSource");
        String recipient = protectionDescriptor.getAttributeValue("AuthRecipient");
        return AuthMessagePolicy.getMessagePolicy(source, recipient);
    }

    public static String getProviderID(MessageSecurityBindingDescriptor binding) {
        String layer;
        String providerID = null;
        if (binding != null && "SOAP".equals(layer = binding.getAttributeValue("AuthLayer"))) {
            providerID = binding.getAttributeValue("ProviderID");
        }
        return providerID;
    }

    public static MessagePolicy[] getSOAPPolicies(MessageSecurityBindingDescriptor binding, String operation, boolean onePolicy) {
        MessagePolicy requestPolicy = null;
        MessagePolicy responsePolicy = null;
        if (binding != null) {
            List messageSecurityDescriptors = null;
            String layer = binding.getAttributeValue("AuthLayer");
            if ("SOAP".equals(layer)) {
                messageSecurityDescriptors = binding.getMessageSecurityDescriptors();
            }
            if (messageSecurityDescriptors != null) {
                if (onePolicy) {
                    if (messageSecurityDescriptors.size() > 0) {
                        MessageSecurityDescriptor msd = (MessageSecurityDescriptor)messageSecurityDescriptors.get(0);
                        requestPolicy = AuthMessagePolicy.getMessagePolicy(msd.getRequestProtectionDescriptor());
                        responsePolicy = AuthMessagePolicy.getMessagePolicy(msd.getResponseProtectionDescriptor());
                    }
                } else {
                    MessageSecurityDescriptor matchMsd = null;
                    for (int i = 0; i < messageSecurityDescriptors.size(); ++i) {
                        MessageSecurityDescriptor msd = (MessageSecurityDescriptor)messageSecurityDescriptors.get(i);
                        List msgDescs = msd.getMessageDescriptors();
                        for (int j = i + 1; j < msgDescs.size(); ++j) {
                            MessageDescriptor msgDesc = (MessageDescriptor)msgDescs.get(j);
                            String opName = msgDesc.getOperationName();
                            if (opName == null && matchMsd == null) {
                                matchMsd = msd;
                                continue;
                            }
                            if (opName == null || !opName.equals(operation)) continue;
                            matchMsd = msd;
                            break;
                        }
                        if (matchMsd == null) continue;
                        requestPolicy = AuthMessagePolicy.getMessagePolicy(matchMsd.getRequestProtectionDescriptor());
                        responsePolicy = AuthMessagePolicy.getMessagePolicy(matchMsd.getResponseProtectionDescriptor());
                    }
                }
            }
        }
        return new MessagePolicy[]{requestPolicy, responsePolicy};
    }

    public static boolean oneSOAPPolicy(MessageSecurityBindingDescriptor binding) {
        boolean onePolicy = true;
        List messageSecurityDescriptor = null;
        if (binding != null && "SOAP".equals(binding.getAttributeValue("AuthLayer"))) {
            messageSecurityDescriptor = binding.getMessageSecurityDescriptors();
        }
        if (messageSecurityDescriptor == null) {
            return true;
        }
        for (int i = 0; i < messageSecurityDescriptor.size(); ++i) {
            MessageSecurityDescriptor msd = (MessageSecurityDescriptor)messageSecurityDescriptor.get(i);
            for (int j = 0; j < messageSecurityDescriptor.size(); ++j) {
                if (j == i || AuthMessagePolicy.policiesAreEqual(msd, (MessageSecurityDescriptor)messageSecurityDescriptor.get(j))) continue;
                onePolicy = false;
            }
        }
        return onePolicy;
    }

    public static SunWebApp getSunWebApp(Map<String, ?> properties) {
        if (properties == null) {
            return null;
        }
        return ((WebBundleDescriptor)properties.get("WEB_BUNDLE")).getSunDescriptor();
    }

    public static String getProviderID(SunWebApp sunWebApp) {
        String providerID = null;
        if (sunWebApp != null) {
            providerID = sunWebApp.getAttributeValue("HttpServletSecurityProvider");
        }
        return providerID;
    }

    public static MessagePolicy[] getHttpServletPolicies(String authContextID) {
        if (Boolean.valueOf(authContextID).booleanValue()) {
            return new MessagePolicy[]{MANDATORY_POLICY, null};
        }
        return new MessagePolicy[]{OPTIONAL_POLICY, null};
    }

    public static CallbackHandler getDefaultCallbackHandler() {
        try {
            return (CallbackHandler)AppservAccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (handlerClassName == null) {
                        handlerClassName = System.getProperty(AuthMessagePolicy.HANDLER_CLASS_PROPERTY, AuthMessagePolicy.DEFAULT_HANDLER_CLASS);
                    }
                    return Class.forName(handlerClassName, true, loader).newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
    }

    private static boolean policiesAreEqual(MessageSecurityDescriptor reference, MessageSecurityDescriptor other) {
        return AuthMessagePolicy.protectionDescriptorsAreEqual(reference.getRequestProtectionDescriptor(), other.getRequestProtectionDescriptor()) && AuthMessagePolicy.protectionDescriptorsAreEqual(reference.getResponseProtectionDescriptor(), other.getResponseProtectionDescriptor());
    }

    private static boolean protectionDescriptorsAreEqual(ProtectionDescriptor pd1, ProtectionDescriptor pd2) {
        String authSource1 = pd1.getAttributeValue("AuthSource");
        String authRecipient1 = pd1.getAttributeValue("AuthRecipient");
        String authSource2 = pd2.getAttributeValue("AuthSource");
        String authRecipient2 = pd2.getAttributeValue("AuthRecipient");
        boolean sameAuthSource = authSource1 == null && authSource2 == null || authSource1 != null && authSource1.equals(authSource2);
        boolean sameAuthRecipient = authRecipient1 == null && authRecipient2 == null || authRecipient1 != null && authRecipient1.equals(authRecipient2);
        return sameAuthSource && sameAuthRecipient;
    }
}

